/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.model.util;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.koneki.simulators.omadm.model.CommandManagement;
import org.eclipse.koneki.simulators.omadm.model.Device;
import org.eclipse.koneki.simulators.omadm.model.DeviceIdType;
import org.eclipse.koneki.simulators.omadm.model.Node;
import org.eclipse.koneki.simulators.omadm.model.NodeFormat;
import org.eclipse.koneki.simulators.omadm.model.OMADMSimulation;
import org.eclipse.koneki.simulators.omadm.model.OMADMSimulatorPackage;
import org.eclipse.koneki.simulators.omadm.model.internal.OMADMSimulationModelPlugin;
import org.eclipse.koneki.simulators.omadm.model.util.DeviceHelpers;
import org.eclipse.koneki.simulators.omadm.model.util.NodeHelpers;

public class OMADMSimulatorValidator
extends EObjectValidator {
    public static final OMADMSimulatorValidator INSTANCE = new OMADMSimulatorValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.koneki.simulators.omadm.model";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return OMADMSimulatorPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateOMADMSimulation((OMADMSimulation)value, diagnostics, context);
            }
            case 1: {
                return this.validateDevice((Device)value, diagnostics, context);
            }
            case 2: {
                return this.validateNode((Node)value, diagnostics, context);
            }
            case 3: {
                return this.validateDeviceIdType((DeviceIdType)((Object)value), diagnostics, context);
            }
            case 4: {
                return this.validateNodeFormat((NodeFormat)((Object)value), diagnostics, context);
            }
            case 5: {
                return this.validateCommandManagement((CommandManagement)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateOMADMSimulation(OMADMSimulation omadmSimulation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(omadmSimulation, diagnostics, context);
    }

    public boolean validateDevice(Device device, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(device, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(device, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(device, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(device, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(device, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(device, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(device, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(device, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(device, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDevice_deviceIdMustBeValid(device, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDevice_rootNodeCategoryMustBeValid(device, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDevice_serverURLMustBeValid(device, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDevice_loginMustBeValid(device, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDevice_passwordURLMustBeValid(device, diagnostics, context);
        }
        return result;
    }

    public boolean validateDevice_passwordURLMustBeValid(Device device, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateDevice_loginMustBeValid(Device device, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateDevice_serverURLMustBeValid(Device device, DiagnosticChain diagnostics, Map<Object, Object> context) {
        assert (device != null);
        boolean isValid = DeviceHelpers.isValidServerURL(device);
        if (!isValid) {
            diagnostics.add(OMADMSimulatorValidator.createErrorDiagnostic(OMADMSimulatorValidator.createDeviceMessage(device, context, "URL server", "The url server must be valid."), new Object[]{device}));
        }
        return isValid;
    }

    public boolean validateDevice_deviceIdMustBeValid(Device device, DiagnosticChain diagnostics, Map<Object, Object> context) {
        assert (device != null);
        if (DeviceHelpers.isValidDeviceId(device)) {
            return true;
        }
        if (diagnostics != null) {
            switch (device.getDeviceIdType()) {
                case IMEI: {
                    diagnostics.add(OMADMSimulatorValidator.createErrorDiagnostic(OMADMSimulatorValidator.createDeviceMessage(device, context, "IMEI number", "must have 15 digits."), new Object[]{device}));
                    break;
                }
                case MAC_ADDRESS: {
                    diagnostics.add(OMADMSimulatorValidator.createErrorDiagnostic(OMADMSimulatorValidator.createDeviceMessage(device, context, "MAC address", "must have 12 hexadecimal digits."), new Object[]{device}));
                    break;
                }
                default: {
                    diagnostics.add(OMADMSimulatorValidator.createErrorDiagnostic(OMADMSimulatorValidator.createDeviceMessage(device, context, "deviceId", "is invalid."), new Object[]{device}));
                }
            }
        }
        return false;
    }

    public boolean validateDevice_rootNodeCategoryMustBeValid(Device device, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (DeviceHelpers.isValidRootNodeType(device)) {
            return true;
        }
        if (diagnostics != null) {
            diagnostics.add(OMADMSimulatorValidator.createErrorDiagnostic(OMADMSimulatorValidator.createDeviceMessage(device, context, "root node", "must be a root node."), new Object[]{device}));
        }
        return false;
    }

    public boolean validateNode(Node node, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(node, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(node, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNode_nodeNameMustBeValid(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNode_nodeFormatMustBeValid(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNode_nodeTypeMustBeValid(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNode_nodeDataMustBeValid(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNode_nodeManagementMustBeValid(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNode_childrenMustBeAuthorized(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNode_childrenCategoryMustBeValid(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNode_childrenNameMustBeUnique(node, diagnostics, context);
        }
        return result;
    }

    public boolean validateNode_nodeNameMustBeValid(Node node, DiagnosticChain diagnostics, Map<Object, Object> context) {
        assert (node != null);
        if (NodeHelpers.isValidNodeName(node)) {
            return true;
        }
        if (diagnostics != null) {
            if (node.isRoot()) {
                diagnostics.add(OMADMSimulatorValidator.createErrorDiagnostic(OMADMSimulatorValidator.createNodeMessage(node, context, "name", "must be \".\"."), new Object[]{node}));
            } else if (node.isLeaf() || node.isInterior()) {
                diagnostics.add(OMADMSimulatorValidator.createErrorDiagnostic(OMADMSimulatorValidator.createNodeMessage(node, context, "name", "is invalid."), new Object[]{node}));
            }
        }
        return false;
    }

    public boolean validateNode_nodeFormatMustBeValid(Node node, DiagnosticChain diagnostics, Map<Object, Object> context) {
        assert (node != null);
        if (NodeHelpers.isValidNodeFormat(node)) {
            return true;
        }
        if (diagnostics != null) {
            if (node.isRoot() || node.isInterior()) {
                diagnostics.add(OMADMSimulatorValidator.createErrorDiagnostic(OMADMSimulatorValidator.createNodeMessage(node, context, "format", "must be \"" + NodeFormat.NODE.getLiteral() + "\"."), new Object[]{node}));
            } else if (node.isLeaf()) {
                diagnostics.add(OMADMSimulatorValidator.createErrorDiagnostic(OMADMSimulatorValidator.createNodeMessage(node, context, "format", "mustn't be \"" + NodeFormat.NODE.getLiteral() + "\"."), new Object[]{node}));
            }
        }
        return false;
    }

    public boolean validateNode_nodeTypeMustBeValid(Node node, DiagnosticChain diagnostics, Map<Object, Object> context) {
        assert (node != null);
        if (NodeHelpers.isValidNodeType(node)) {
            return true;
        }
        if (diagnostics != null) {
            diagnostics.add(OMADMSimulatorValidator.createErrorDiagnostic(OMADMSimulatorValidator.createNodeMessage(node, context, "type", "must be valid."), new Object[]{node}));
        }
        return false;
    }

    public boolean validateNode_nodeDataMustBeValid(Node node, DiagnosticChain diagnostics, Map<Object, Object> context) {
        assert (node != null);
        if (NodeHelpers.isValidNodeData(node)) {
            return true;
        }
        if (diagnostics != null) {
            diagnostics.add(OMADMSimulatorValidator.createErrorDiagnostic(OMADMSimulatorValidator.createNodeMessage(node, context, "data", "must be valid."), new Object[]{node}));
        }
        return false;
    }

    public boolean validateNode_nodeManagementMustBeValid(Node node, DiagnosticChain diagnostics, Map<Object, Object> context) {
        assert (node != null);
        if (NodeHelpers.isValidNodeManagement(node)) {
            return true;
        }
        if (diagnostics != null) {
            diagnostics.add(OMADMSimulatorValidator.createErrorDiagnostic(OMADMSimulatorValidator.createNodeMessage(node, context, "management", "must be valid."), new Object[]{node}));
        }
        return false;
    }

    public boolean validateNode_childrenMustBeAuthorized(Node node, DiagnosticChain diagnostics, Map<Object, Object> context) {
        assert (node != null);
        if (NodeHelpers.isRespectAuthorizationChildren(node)) {
            return true;
        }
        if (diagnostics != null) {
            diagnostics.add(OMADMSimulatorValidator.createErrorDiagnostic(OMADMSimulatorValidator.createNodeMessage(node, context, "possibility to have children", "isn't authorized."), new Object[]{node}));
        }
        return false;
    }

    public boolean validateNode_childrenCategoryMustBeValid(Node node, DiagnosticChain diagnostics, Map<Object, Object> context) {
        assert (node != null);
        if (NodeHelpers.isValidChildrenType(node)) {
            return true;
        }
        if (diagnostics != null && !node.isLeaf()) {
            diagnostics.add(OMADMSimulatorValidator.createErrorDiagnostic(OMADMSimulatorValidator.createNodeMessage(node, context, "children type", "musn't be a root node."), new Object[]{node}));
        }
        return false;
    }

    public boolean validateNode_childrenNameMustBeUnique(Node node, DiagnosticChain diagnostics, Map<Object, Object> context) {
        assert (node != null);
        if (NodeHelpers.isUniqueChildrenName(node)) {
            return true;
        }
        if (diagnostics != null && !node.isLeaf()) {
            diagnostics.add(OMADMSimulatorValidator.createErrorDiagnostic(OMADMSimulatorValidator.createNodeMessage(node, context, "children name", "isn't unique."), new Object[]{node}));
        }
        return false;
    }

    public boolean validateDeviceIdType(DeviceIdType deviceIdType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateNodeFormat(NodeFormat nodeFormat, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateCommandManagement(CommandManagement commandManagement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return OMADMSimulationModelPlugin.INSTANCE;
    }

    private static final Diagnostic createErrorDiagnostic(String message, Object[] data) {
        assert (message != null);
        assert (data != null);
        return new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, message, data);
    }

    private static final String createNodeMessage(Node node, Map<Object, Object> context, String what, String endMessage) {
        assert (node != null);
        assert (what != null);
        assert (endMessage != null);
        assert (what.matches("\\S+.*\\S+"));
        assert (what.matches("\\S+.*\\S+"));
        return "The " + what + " of the " + OMADMSimulatorValidator.getCategory(node) + " node " + (node.isRoot() ? "" : "\"" + OMADMSimulatorValidator.getObjectLabel((EObject)node, context) + "\" ") + endMessage;
    }

    private static final String createDeviceMessage(Device device, Map<Object, Object> context, String what, String endMessage) {
        assert (device != null);
        assert (what != null);
        assert (endMessage != null);
        assert (what.matches("\\S+.*\\S+"));
        assert (what.matches("\\S+.*\\S+"));
        return "The " + what + " of the " + OMADMSimulatorValidator.getObjectLabel((EObject)device, context) + " " + endMessage;
    }

    private static final String getCategory(Node node) {
        if (node.isRoot()) {
            return "root";
        }
        if (node.isInterior()) {
            return "interior";
        }
        if (node.isLeaf()) {
            return "leaf";
        }
        return "";
    }
}

