/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.emfforms.builder;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public final class EMFHelper {
    private static final String PLATFORM_SCHEME = "platform";
    private static final String FILE_SCHEME = "file";
    private static final String RESOURCE_SEGMENT = "resource";

    private EMFHelper() {
    }

    public static IFile getIFile(URI uri) {
        IFile file = null;
        if (PLATFORM_SCHEME.equals(uri.scheme()) && uri.segmentCount() > 1 && RESOURCE_SEGMENT.equals(uri.segment(0))) {
            StringBuffer platformResourcePath = new StringBuffer();
            int j = 1;
            int size = uri.segmentCount();
            while (j < size) {
                platformResourcePath.append('/');
                platformResourcePath.append(URI.decode((String)uri.segment(j)));
                ++j;
            }
            file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath.toString()));
        } else if (FILE_SCHEME.equals(uri.scheme())) {
            StringBuffer fileResourcePath = new StringBuffer();
            int j = 1;
            int size = uri.segmentCount();
            while (j < size) {
                fileResourcePath.append('/');
                fileResourcePath.append(URI.decode((String)uri.segment(j)));
                ++j;
            }
            file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileResourcePath.toString()));
        }
        return file;
    }

    public static IProject getIProject(Resource resource) {
        IProject result = null;
        URI uri = resource.getURI();
        if (resource.getResourceSet().getURIConverter().exists(uri, null)) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource findMember = root.findMember((IPath)new Path(uri.toPlatformString(true)));
            result = findMember.getProject();
        }
        return result;
    }
}

