/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.emfforms.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.pde.emfforms.builder.EMFHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MarkerHelper {
    public static final String VALIDATION_MARKER_TYPE = "org.eclipse.emf.ecore.diagnostic";

    private MarkerHelper() {
    }

    public static void cleanMarkers(IContainer container) throws CoreException {
        if (container != null) {
            String markerType = VALIDATION_MARKER_TYPE;
            container.deleteMarkers(markerType, true, 2);
        }
    }

    public static void cleanMarkers(IFile file) throws CoreException {
        if (file != null) {
            String markerType = VALIDATION_MARKER_TYPE;
            file.deleteMarkers(markerType, true, 0);
        }
    }

    private static void createMarker(Diagnostic diagnostic, Map<URI, IFile> visitedResources) throws CoreException {
        String markerType = VALIDATION_MARKER_TYPE;
        EObject target = (EObject)diagnostic.getData().get(0);
        Resource r = target.eResource();
        URI resourceUri = r.getURI();
        resourceUri = r.getResourceSet().getURIConverter().normalize(resourceUri);
        IFile file = visitedResources.get(resourceUri);
        if (file == null && (file = EMFHelper.getIFile(resourceUri)) != null) {
            file.deleteMarkers(markerType, true, 0);
            visitedResources.put(resourceUri, file);
        }
        if (file != null) {
            IMarker marker = file.createMarker(markerType);
            marker.setAttribute("sourceId", diagnostic.getCode());
            marker.setAttribute("uri", (Object)EcoreUtil.getURI((EObject)target).toString());
            switch (diagnostic.getSeverity()) {
                case 1: {
                    marker.setAttribute("severity", 0);
                    marker.setAttribute("priority", 0);
                    break;
                }
                case 2: {
                    marker.setAttribute("severity", 1);
                    marker.setAttribute("priority", 1);
                    break;
                }
                case 4: 
                case 8: {
                    marker.setAttribute("severity", 2);
                    marker.setAttribute("priority", 2);
                }
            }
            marker.setAttribute("message", (Object)diagnostic.getMessage());
        }
    }

    public static void createMarkers(final Diagnostic validationDiagnostic, IProgressMonitor monitor) throws CoreException {
        if (validationDiagnostic.getSeverity() == 0) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor m) throws CoreException {
                HashMap visitedResources = new HashMap();
                if (!validationDiagnostic.getChildren().isEmpty()) {
                    m.beginTask("Create validation markers", validationDiagnostic.getChildren().size());
                    for (Diagnostic diagnostic : validationDiagnostic.getChildren()) {
                        List data = diagnostic.getData();
                        if (data != null && !data.isEmpty() && data.get(0) instanceof EObject) {
                            MarkerHelper.createMarker(diagnostic, visitedResources);
                        }
                        m.worked(1);
                    }
                } else {
                    MarkerHelper.createMarker(validationDiagnostic, visitedResources);
                }
                m.done();
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, monitor);
    }
}

