/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.emfforms.internal.editor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EventObject;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.emfforms.editor.AbstractEmfFormPage;
import org.eclipse.pde.emfforms.editor.EmfFormEditor;
import org.eclipse.pde.emfforms.internal.Activator;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSourcePage
extends AbstractEmfFormPage {
    private SourceViewer _sourceViewer;
    public static final String ID = "emfforms.source";
    protected static final int VERTICAL_RULER_WIDTH = 12;
    private EditingDomain _editingDomain;
    private CommandStackListener _commandStackListener;

    public AbstractSourcePage(EmfFormEditor<?> editor) {
        super(editor);
    }

    @Override
    public void bind(DataBindingContext bindingContext) {
        this._editingDomain = this.getEditor().getEditingDomain();
        this._commandStackListener = new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                AbstractSourcePage.this.refreshSourceContent();
            }
        };
        this._editingDomain.getCommandStack().addCommandStackListener(this._commandStackListener);
        this.refreshSourceContent();
    }

    private void refreshSourceContent() {
        EObject obj = (EObject)this.getObservedValue().getValue();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            obj.eResource().save((OutputStream)outputStream, Collections.EMPTY_MAP);
            ((OutputStream)outputStream).close();
        }
        catch (IOException e) {
            Activator.log(e);
        }
        String result = ((Object)outputStream).toString();
        if (this._sourceViewer != null) {
            this._sourceViewer.getDocument().set(result);
        }
    }

    @Override
    public void createContents(Composite parent) {
        GridLayout gl = new GridLayout(this.getNumColumns(), true);
        gl.verticalSpacing = 0;
        parent.setLayout((Layout)gl);
        this._sourceViewer = this.createSourceViewer(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this._sourceViewer.getControl());
    }

    public abstract SourceViewer createSourceViewer(Composite var1);

    @Override
    public String getId() {
        return ID;
    }

    public String getPartName() {
        return "Source";
    }

    @Override
    public Viewer getViewer() {
        return null;
    }

    private IObservableValue getObservedValue() {
        return this.getEditor().getInputObservable();
    }

    public void dispose() {
        if (this._editingDomain != null) {
            this._editingDomain.getCommandStack().removeCommandStackListener(this._commandStackListener);
        }
        super.dispose();
    }
}

