/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.protocols.omadm.client.basic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.Executors;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.koneki.protocols.omadm.CommandHandler;
import org.eclipse.koneki.protocols.omadm.DMGenericAlert;
import org.eclipse.koneki.protocols.omadm.DMNode;
import org.eclipse.koneki.protocols.omadm.ProtocolListener;
import org.eclipse.koneki.protocols.omadm.client.DMClient;
import org.eclipse.koneki.protocols.omadm.client.DMClientException;
import org.eclipse.koneki.protocols.omadm.client.basic.DMBasicSession;
import org.eclipse.koneki.protocols.omadm.client.basic.DMSessionExecutor;
import org.eclipse.koneki.protocols.omadm.client.basic.DMSessionIDGenerator;

public abstract class DMBasicClient
implements DMClient {
    private final DMSessionExecutor sessionExecutor = new DMSessionExecutor(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
    private final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    private final DMSessionIDGenerator sessionIDGenerator = new DMSessionIDGenerator();

    @Override
    public void initiateManagementSession(URI server, URI client, DMNode[] devInfoNodes, CommandHandler commandHandler) {
        this.initiateManagementSession(server, "", client, devInfoNodes, commandHandler, new ProtocolListener[0], new DMGenericAlert[0]);
    }

    @Override
    public void initiateManagementSession(URI server, URI client, DMNode[] devInfoNodes, CommandHandler commandHandler, ProtocolListener[] protocolLinsteners) {
        this.initiateManagementSession(server, "", client, devInfoNodes, commandHandler, protocolLinsteners, new DMGenericAlert[0]);
    }

    @Override
    public void initiateManagementSession(URI server, URI client, DMNode[] devInfoNodes, CommandHandler commandHandler, DMGenericAlert[] genericAlerts) {
        this.initiateManagementSession(server, "", client, devInfoNodes, commandHandler, new ProtocolListener[0], genericAlerts);
    }

    @Override
    public void initiateManagementSession(URI server, String userAuth, URI client, DMNode[] devInfoNodes, CommandHandler commandHandler, ProtocolListener[] protocolLinsteners, DMGenericAlert[] genericAlerts) {
        if (server == null || client == null || devInfoNodes == null || commandHandler == null || protocolLinsteners == null || genericAlerts == null) {
            throw new NullPointerException();
        }
        String sessionID = String.valueOf(this.sessionIDGenerator.nextSessionID(server, client));
        this.execute(client, new DMBasicSession(this, server, userAuth, client, sessionID, devInfoNodes, commandHandler, protocolLinsteners, genericAlerts));
    }

    final void execute(URI client, Runnable command) {
        this.sessionExecutor.execute(client, command);
    }

    final XMLStreamReader createXMLStreamReader(InputStream stream, String encoding, StreamFilter filter) throws XMLStreamException {
        return this.xmlInputFactory.createFilteredReader(this.xmlInputFactory.createXMLStreamReader(stream, encoding), filter);
    }

    final XMLStreamWriter createXMLStreamWriter(OutputStream stream, String encoding) throws XMLStreamException {
        return this.xmlOutputFactory.createXMLStreamWriter(stream, encoding);
    }

    protected abstract void sendAndReceiveMessage(URI var1, String var2, DMMessenger var3) throws IOException, DMClientException;

    protected static interface DMMessenger {
        public void writeMessage(OutputStream var1) throws DMClientException;

        public void readMessage(InputStream var1) throws DMClientException;
    }
}

