/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.editor.dialogs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.koneki.commons.ui.widgets.InfoBanner;
import org.eclipse.koneki.simulators.omadm.editor.dialogs.ApplicationModelFilter;
import org.eclipse.koneki.simulators.omadm.editor.internal.Activator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ApplicationModelSelectionDialog
extends Dialog {
    private static final int DIALOG_WIDTH = 400;
    private static final int DIALOG_HEIGHT = 350;
    private final IContainer root;
    private IFile selection;

    public ApplicationModelSelectionDialog(Shell parentShell, IContainer root) {
        super(parentShell);
        this.root = root;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("Application model selection");
        super.configureShell(newShell);
    }

    public IFile getSelectedApplicationIFile() {
        return this.selection;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridDataFactory.fillDefaults().grab(true, true).hint(400, 350).applyTo((Control)composite);
        InfoBanner infoBanner = new InfoBanner(composite, 0);
        infoBanner.setIcon(Activator.getDefault().getImage("icons/obj32/info.png"));
        infoBanner.getFormText().setText("<form>Associating a Application model will offer you new features:<li bindent=\"20\">Quick overridable paremeters visualization</li><li bindent=\"20\">Quick parameters overriding</li></form>", true, true);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)infoBanner);
        InfoBanner infoBanner2 = new InfoBanner(composite, 0);
        infoBanner2.setIcon(Activator.getDefault().getImage("icons/obj32/info.png"));
        infoBanner2.getFormText().setText("<form>You only see Application models present in the \"" + this.root.getName() + "\" project.</form>", true, true);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)infoBanner2);
        TreeViewer treeViewer = new TreeViewer(composite, 2052);
        treeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        treeViewer.addFilter((ViewerFilter)new FileExtensionFilter(new String[]{"*.xml"}, new ApplicationModelFilter()));
        GridDataFactory.fillDefaults().grab(true, true).applyTo(treeViewer.getControl());
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                boolean validSelection = false;
                if (!sel.isEmpty() && sel.getFirstElement() instanceof IFile) {
                    ApplicationModelSelectionDialog.this.selection = (IFile)sel.getFirstElement();
                    validSelection = true;
                }
                ApplicationModelSelectionDialog.this.getButton(0).setEnabled(validSelection);
            }
        });
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)treeViewer.getTree());
        treeViewer.setInput((Object)this.root);
        composite.setFocus();
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getButton(0).setEnabled(false);
        return control;
    }

    private class FileExtensionFilter
    extends ViewerFilter {
        private final String[] acceptedExtensions;
        private final ViewerFilter customFilter;

        public FileExtensionFilter(String[] acceptedExtensions, ViewerFilter customFilter) {
            this.acceptedExtensions = acceptedExtensions;
            this.customFilter = customFilter;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IResource resource = (IResource)element;
            if (resource instanceof IFolder && !resource.getName().startsWith(".")) {
                return true;
            }
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                String fileExtension = file.getFileExtension();
                String[] stringArray = this.acceptedExtensions;
                int n = this.acceptedExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String extension = stringArray[n2];
                    if (extension.endsWith(fileExtension)) {
                        return this.customFilter.select(viewer, parentElement, element);
                    }
                    ++n2;
                }
            }
            return false;
        }
    }
}

