/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.editor.internal.dashboard;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.koneki.protocols.omadm.CommandHandler;
import org.eclipse.koneki.protocols.omadm.DMGenericAlert;
import org.eclipse.koneki.protocols.omadm.ProtocolListener;
import org.eclipse.koneki.simulators.omadm.DMSimulator;
import org.eclipse.koneki.simulators.omadm.editor.Messages;
import org.eclipse.koneki.simulators.omadm.editor.OMADMSimulatorEditor;
import org.eclipse.koneki.simulators.omadm.editor.internal.Activator;
import org.eclipse.koneki.simulators.omadm.editor.internal.dashboard.ConnectCommandHandler;
import org.eclipse.koneki.simulators.omadm.editor.internal.dashboard.ConnectProtocolListener;
import org.eclipse.koneki.simulators.omadm.editor.internal.dashboard.DashboardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.osgi.framework.ServiceException;

class ConnectSelection
extends SelectionAdapter {
    private final OMADMSimulatorEditor editor;
    private final DashboardPage page;
    private URI server;
    private boolean isFirst;

    public ConnectSelection(OMADMSimulatorEditor editor, DashboardPage page) {
        this.page = page;
        this.editor = editor;
        this.updateServerURI(editor);
        this.isFirst = true;
    }

    public synchronized void widgetSelected(SelectionEvent ev) {
        this.page.getConnectIcon().setEnabled(false);
        Job wakeupJob = new Job(Messages.DashBoardPage_ManagementSection_ConnectButton){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    return ConnectSelection.this.run(monitor);
                }
                catch (ServiceException e) {
                    return new Status(4, "org.eclipse.koneki.simulators.omadm.editor", "An error has occurred.", (Throwable)e);
                }
            }
        };
        wakeupJob.setUser(this.isFirst);
        wakeupJob.schedule();
        this.isFirst = false;
    }

    private synchronized IStatus run(IProgressMonitor monitor) throws ServiceException {
        DMGenericAlert genericAlert;
        monitor.beginTask("Wakeup", -1);
        if (this.server == null) {
            return new Status(4, "org.eclipse.koneki.simulators.omadm.editor", "Your OMA DM Server URL is not set.");
        }
        DMSimulator dmSimulator = Activator.getDefault().getDMSimulator();
        if (dmSimulator == null) {
            return new Status(4, "org.eclipse.koneki.simulators.omadm.editor", "No " + DMSimulator.class.getSimpleName() + " are available.");
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        LinkedList<DMGenericAlert> genericAlerts = new LinkedList<DMGenericAlert>();
        while ((genericAlert = this.page.pollGenericAlert()) != null) {
            genericAlerts.add(genericAlert);
        }
        this.updateServerURI(this.editor);
        dmSimulator.simulate(this.server, this.page.getEditor().getOMADMSimulation().getDevice().getTree(), this.page.getEditor().getEditingDomain(), (CommandHandler)new ConnectCommandHandler(this.page), new ProtocolListener[]{new ConnectProtocolListener(this.page)}, genericAlerts.toArray(new DMGenericAlert[0]));
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private void updateServerURI(OMADMSimulatorEditor e) {
        try {
            this.server = new URI(e.getOMADMSimulation().getDevice().getServerUrl());
        }
        catch (URISyntaxException uRISyntaxException) {
            this.server = null;
        }
    }
}

