/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.editor.internal.dashboard;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.koneki.commons.ui.ANWRTToolkit;
import org.eclipse.koneki.commons.ui.CommonFonts;
import org.eclipse.koneki.commons.ui.widgets.ClickableIconAndLabel;
import org.eclipse.koneki.commons.ui.widgets.InfoBanner;
import org.eclipse.koneki.protocols.omadm.DMGenericAlert;
import org.eclipse.koneki.simulators.omadm.editor.Messages;
import org.eclipse.koneki.simulators.omadm.editor.OMADMSimulatorEditor;
import org.eclipse.koneki.simulators.omadm.editor.internal.Activator;
import org.eclipse.koneki.simulators.omadm.editor.internal.dashboard.ConnectSelection;
import org.eclipse.koneki.simulators.omadm.editor.internal.dashboard.DashboardMasterDetails;
import org.eclipse.koneki.simulators.omadm.model.OMADMSimulatorPackage;
import org.eclipse.pde.emfforms.editor.AbstractEmfFormPage;
import org.eclipse.pde.emfforms.editor.EmfFormEditor;
import org.eclipse.pde.emfforms.editor.EmfMasterDetailBlock;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.widgets.Section;

public class DashboardPage
extends AbstractEmfFormPage {
    private final OMADMSimulatorEditor editor;
    private final EmfMasterDetailBlock masterDetail;
    private TabFolder sessionManagementCompositeTabs;
    private ToolItem clearToolItem;
    private Tree commandsViewTree;
    private Tree messagesViewTree;
    private StyledText messagesViewText;
    private ClickableIconAndLabel connectIcon;
    private Label alertWaitingLabel;
    private Queue<DMGenericAlert> genericAlertsQueue;

    public DashboardPage(OMADMSimulatorEditor editor) {
        super((EmfFormEditor)editor, 1, Messages.DashBoardPage_Title);
        this.editor = editor;
        this.masterDetail = new DashboardMasterDetails(this);
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void bind(DataBindingContext bindingContext) {
        bindingContext.bindValue((IObservableValue)ViewerProperties.input().observe((Viewer)this.masterDetail.getTreeViewer()), EMFEditObservables.observeDetailValue((Realm)Realm.getDefault(), (EditingDomain)this.getEditor().getEditingDomain(), (IObservableValue)this.getEditor().getInputObservable(), (EStructuralFeature)OMADMSimulatorPackage.Literals.OMADM_SIMULATION__DEVICE));
    }

    public void createContents(Composite parent) {
        ANWRTToolkit toolkit = this.getEditor().getANWRTToolkit();
        Composite pageComposite = toolkit.createComposite(this.getManagedForm().getForm().getBody());
        GridLayoutFactory.swtDefaults().numColumns(1).spacing(20, 20).applyTo(pageComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)pageComposite);
        InfoBanner infoBanner = toolkit.createInfoBanner(pageComposite);
        infoBanner.getFormText().setText(Messages.DashBoardPage_InfoBanner, true, true);
        infoBanner.getFormText().setFont(CommonFonts.BOLD);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)infoBanner);
        this.genericAlertsQueue = new ConcurrentLinkedQueue<DMGenericAlert>();
        this.masterDetail.createContent(this.getManagedForm());
        this.createSessionManagement(this.getManagedForm().getForm().getBody(), toolkit);
        this.clearToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (DashboardPage.this.sessionManagementCompositeTabs.getSelectionIndex()) {
                    case 0: {
                        DashboardPage.this.commandsViewTree.removeAll();
                        break;
                    }
                    case 1: {
                        DashboardPage.this.messagesViewTree.removeAll();
                        DashboardPage.this.messagesViewText.setText("");
                        break;
                    }
                }
            }
        });
        this.connectIcon.addSelectionListener((SelectionListener)new ConnectSelection(this.editor, this));
        this.messagesViewTree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Object data = event.item.getData();
                if (data != null && data instanceof String) {
                    DashboardPage.this.messagesViewText.setText((String)data);
                } else {
                    DashboardPage.this.messagesViewText.setText("");
                }
            }
        });
    }

    private void createSessionManagement(Composite parent, ANWRTToolkit toolkit) {
        Section sessionManagementSection = toolkit.createSection(parent, 256);
        sessionManagementSection.setText(Messages.DashBoardPage_ManagementSection_Title);
        sessionManagementSection.marginWidth = 5;
        sessionManagementSection.marginHeight = 5;
        GridDataFactory.fillDefaults().grab(true, true).span(1, 1).hint(1, 200).applyTo((Control)sessionManagementSection);
        Composite sessionManagementComposite = toolkit.createComposite((Composite)sessionManagementSection);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sessionManagementComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(sessionManagementComposite);
        ToolBar sessionManagementToolBar = new ToolBar((Composite)sessionManagementSection, 0x800000);
        this.clearToolItem = new ToolItem(sessionManagementToolBar, 8);
        this.clearToolItem.setImage(Activator.getDefault().getImage("icons/obj16/clear.png"));
        this.clearToolItem.setToolTipText(Messages.DashBoardPage_ManagementSection_Clear);
        this.sessionManagementCompositeTabs = new TabFolder(sessionManagementComposite, 0);
        TabItem commandsTab = new TabItem(this.sessionManagementCompositeTabs, 0);
        commandsTab.setText(Messages.DashBoardPage_ManagementSection_Command);
        commandsTab.setControl(this.createCommandsView((Composite)this.sessionManagementCompositeTabs, toolkit));
        TabItem messagesTab = new TabItem(this.sessionManagementCompositeTabs, 0);
        messagesTab.setText(Messages.DashBoardPage_ManagementSection_Messages);
        messagesTab.setControl(this.createMessagesView((Composite)this.sessionManagementCompositeTabs, toolkit));
        GridDataFactory.fillDefaults().grab(true, true).span(1, 1).applyTo((Control)this.sessionManagementCompositeTabs);
        Composite actionComposite = toolkit.createComposite(sessionManagementComposite);
        GridDataFactory.fillDefaults().grab(false, true).span(1, 1).align(0x1000008, 0x1000000).applyTo((Control)actionComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(actionComposite);
        Label topDummyLabel = toolkit.createLabel(actionComposite, "Wait 99 alerts");
        topDummyLabel.setVisible(false);
        DashboardPage.multiplyFontSize((Control)topDummyLabel, 0.8);
        GridDataFactory.fillDefaults().grab(false, true).span(1, 1).align(0x1000000, 4).applyTo((Control)topDummyLabel);
        this.connectIcon = toolkit.createClickableIconAndLabel(actionComposite, Activator.getDefault().getImage("icons/obj32/start.png"), Messages.DashBoardPage_ManagementSection_ConnectButton, true);
        GridDataFactory.fillDefaults().grab(false, true).span(1, 1).align(0x1000000, 4).applyTo((Control)this.connectIcon);
        this.alertWaitingLabel = toolkit.createLabel(actionComposite, "");
        DashboardPage.multiplyFontSize((Control)this.alertWaitingLabel, 0.8);
        GridDataFactory.fillDefaults().grab(false, true).span(1, 1).align(0x1000000, 4).applyTo((Control)this.alertWaitingLabel);
        Label bottomDummyLabel = toolkit.createLabel(actionComposite, "Wait 99 alerts");
        bottomDummyLabel.setVisible(false);
        DashboardPage.multiplyFontSize((Control)bottomDummyLabel, 0.8);
        GridDataFactory.fillDefaults().grab(false, true).span(1, 1).align(0x1000000, 4).applyTo((Control)bottomDummyLabel);
        sessionManagementSection.setClient((Control)sessionManagementComposite);
        sessionManagementSection.setTextClient((Control)sessionManagementToolBar);
    }

    private Control createCommandsView(Composite parent, ANWRTToolkit toolkit) {
        this.commandsViewTree = toolkit.createTree(parent, 2820);
        this.commandsViewTree.setHeaderVisible(true);
        this.commandsViewTree.setLinesVisible(true);
        TreeColumn sessionColumn = new TreeColumn(this.commandsViewTree, 0);
        sessionColumn.setText(Messages.DashBoardPage_ManagementSection_Session);
        sessionColumn.setWidth(110);
        TreeColumn serverColumn = new TreeColumn(this.commandsViewTree, 0);
        serverColumn.setText(Messages.DashBoardPage_ManagementSection_Server);
        serverColumn.setWidth(325);
        TreeColumn clientColumn = new TreeColumn(this.commandsViewTree, 0);
        clientColumn.setText(Messages.DashBoardPage_ManagementSection_Client);
        clientColumn.setWidth(325);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.commandsViewTree);
        return this.commandsViewTree;
    }

    private Control createMessagesView(Composite parent, ANWRTToolkit toolkit) {
        Composite messagesViewComposite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)messagesViewComposite);
        messagesViewComposite.setLayout((Layout)new FormLayout());
        final Sash sash = new Sash(messagesViewComposite, 512);
        sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((FormData)sash.getLayoutData()).left = new FormAttachment(0, event.x);
                sash.getParent().layout();
            }
        });
        FormData sashData = new FormData();
        sashData.top = new FormAttachment(0, 0);
        sashData.bottom = new FormAttachment(100, 0);
        sashData.left = new FormAttachment(25, 0);
        sash.setLayoutData((Object)sashData);
        this.messagesViewTree = toolkit.createTree(messagesViewComposite, 2820);
        FormData messagesViewTreeData = new FormData();
        messagesViewTreeData.top = new FormAttachment(0, 0);
        messagesViewTreeData.bottom = new FormAttachment(100, 0);
        messagesViewTreeData.left = new FormAttachment(0, 0);
        messagesViewTreeData.right = new FormAttachment((Control)sash, 0);
        this.messagesViewTree.setLayoutData((Object)messagesViewTreeData);
        this.messagesViewText = new StyledText(messagesViewComposite, 2568);
        FormData messagesViewTextData = new FormData();
        messagesViewTextData.top = new FormAttachment(0, 0);
        messagesViewTextData.bottom = new FormAttachment(100, 0);
        messagesViewTextData.left = new FormAttachment((Control)sash, 0);
        messagesViewTextData.right = new FormAttachment(100, 0);
        this.messagesViewText.setLayoutData((Object)messagesViewTextData);
        return messagesViewComposite;
    }

    protected EmfMasterDetailBlock getMainMasterDetailBlock() {
        return this.masterDetail;
    }

    public OMADMSimulatorEditor getEditor() {
        return (OMADMSimulatorEditor)super.getEditor();
    }

    Tree getCommandsViewTree() {
        return this.commandsViewTree;
    }

    Tree getMessagesViewTree() {
        return this.messagesViewTree;
    }

    ClickableIconAndLabel getConnectIcon() {
        return this.connectIcon;
    }

    void addGenericAlert(DMGenericAlert genericAlert) {
        this.genericAlertsQueue.offer(genericAlert);
        this.updateAlertWaitingLabel();
    }

    DMGenericAlert pollGenericAlert() {
        DMGenericAlert genericAlert = this.genericAlertsQueue.poll();
        this.updateAlertWaitingLabel();
        return genericAlert;
    }

    private void updateAlertWaitingLabel() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                StringBuffer sb = new StringBuffer();
                int size = DashboardPage.this.genericAlertsQueue.size();
                if (size != 0) {
                    sb.append("(").append(size).append(" alert");
                    if (size > 1) {
                        sb.append("s");
                    }
                    sb.append(" waiting)");
                }
                DashboardPage.this.alertWaitingLabel.setText(sb.toString());
                DashboardPage.this.alertWaitingLabel.getParent().layout();
            }
        });
    }

    private static void multiplyFontSize(Control control, double k) {
        FontData[] fontData = control.getFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight((int)((double)fontData[i].getHeight() * k));
            ++i;
        }
        final Font newFont = new Font((Device)control.getDisplay(), fontData);
        control.setFont(newFont);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
    }
}

