/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.editor.wizards;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.koneki.simulators.omadm.editor.wizards.Messages;
import org.eclipse.koneki.simulators.omadm.model.Device;
import org.eclipse.koneki.simulators.omadm.model.DeviceIdType;
import org.eclipse.koneki.simulators.omadm.model.Node;
import org.eclipse.koneki.simulators.omadm.model.util.NodeHelpers;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class DevDetailWizardPage
extends WizardPage
implements IWizardPage {
    private static final String HW_V = "HwV";
    private static final String SW_V = "SwV";
    private static final String FW_V = "FwV";
    private static final String OEM = "OEM";
    private static final String DEV_DETAIL = "./DevDetail";
    private Device device;
    private Text devTypText;
    private Text oemText;
    private Text fwVText;
    private Text swVText;
    private Text hwVText;

    public DevDetailWizardPage(Device device, String pageName) {
        super(pageName);
        this.device = device;
    }

    public void createControl(Composite parent) {
        Composite devDetailComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(devDetailComposite);
        new Label(devDetailComposite, 0).setText(Messages.DevDetailWizardPage_DeviceType);
        this.devTypText = new Text(devDetailComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.devTypText);
        new Label(devDetailComposite, 0).setText(Messages.DevDetailWizardPage_OEMName);
        this.oemText = new Text(devDetailComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.oemText);
        new Label(devDetailComposite, 0).setText(Messages.DevDetailWizardPage_FirmwareRevision);
        this.fwVText = new Text(devDetailComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.fwVText);
        new Label(devDetailComposite, 0).setText(Messages.DevDetailWizardPage_SoftwareRevision);
        this.swVText = new Text(devDetailComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.swVText);
        new Label(devDetailComposite, 0).setText(Messages.DevDetailWizardPage_HardwareRevision);
        this.hwVText = new Text(devDetailComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.hwVText);
        this.setControl((Control)devDetailComposite);
    }

    public String getDevTyp() {
        return this.devTypText.getText();
    }

    public boolean isDevTypSet() {
        return !this.devTypText.getText().isEmpty();
    }

    public String getOEM() {
        return this.oemText.getText();
    }

    public boolean isOEMSet() {
        return !this.oemText.getText().isEmpty();
    }

    public String getFwV() {
        return this.fwVText.getText();
    }

    public boolean isFwVSet() {
        return !this.fwVText.getText().isEmpty();
    }

    public String getSwV() {
        return this.swVText.getText();
    }

    public boolean isSwVSet() {
        return !this.swVText.getText().isEmpty();
    }

    public String getHwV() {
        return this.hwVText.getText();
    }

    public boolean isHwVSet() {
        return !this.hwVText.getText().isEmpty();
    }

    public Device getDevice() {
        NodeHelpers.findFirstNode((Node)NodeHelpers.getNode((Node)this.device.getTree(), (String)DEV_DETAIL), (String)FW_V).setData(this.getFwV());
        NodeHelpers.findFirstNode((Node)NodeHelpers.getNode((Node)this.device.getTree(), (String)DEV_DETAIL), (String)SW_V).setData(this.getSwV());
        NodeHelpers.findFirstNode((Node)NodeHelpers.getNode((Node)this.device.getTree(), (String)DEV_DETAIL), (String)HW_V).setData(this.getHwV());
        NodeHelpers.findFirstNode((Node)NodeHelpers.getNode((Node)this.device.getTree(), (String)DEV_DETAIL), (String)OEM).setData(this.getOEM());
        this.device.setDeviceIdType(DeviceIdType.getByName((String)this.devTypText.getText()));
        return this.device;
    }

    public void setDevice(Device device) {
        this.devTypText.setText(device.getDeviceIdType().getName());
        this.device = device;
    }
}

