/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.editor.wizards;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.koneki.simulators.omadm.editor.Messages;
import org.eclipse.koneki.simulators.omadm.model.Device;
import org.eclipse.koneki.simulators.omadm.model.Node;
import org.eclipse.koneki.simulators.omadm.model.util.DeviceHelpers;
import org.eclipse.koneki.simulators.omadm.model.util.NodeHelpers;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class DevInfoWizardPage
extends WizardPage
implements IWizardPage {
    private static final String LANG = "Lang";
    private static final String MOD = "Mod";
    private static final String MAN = "Man";
    private static final String DEV_INFO = "./DevInfo";
    private Device device;
    private Text devIdText;
    private Text manText;
    private Text modText;
    private Text langText;

    public DevInfoWizardPage(Device device, String pageName) {
        super(pageName);
        this.device = device;
    }

    public void createControl(Composite parent) {
        Composite devInfoComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(devInfoComposite);
        new Label(devInfoComposite, 0).setText(Messages.DevInfoWizardPage_DeviceId);
        this.devIdText = new Text(devInfoComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.devIdText);
        new Label(devInfoComposite, 0).setText(Messages.DevInfoWizardPage_ManufacturerName);
        this.manText = new Text(devInfoComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.manText);
        new Label(devInfoComposite, 0).setText(Messages.DevInfoWizardPage_ModelName);
        this.modText = new Text(devInfoComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.modText);
        new Label(devInfoComposite, 0).setText(Messages.DevInfoWizardPage_Language);
        this.langText = new Text(devInfoComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.langText);
        this.hookListeners();
        this.validatePage();
        this.setControl((Control)devInfoComposite);
    }

    private void hookListeners() {
        this.devIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DevInfoWizardPage.this.validatePage();
            }
        });
    }

    private void validatePage() {
        this.device.setDeviceId(this.devIdText.getText());
        if (!DeviceHelpers.isValidDeviceId((Device)this.device)) {
            this.setMessage(Messages.Wizard_DeviceID_Is_Invalid, 3);
            this.setPageComplete(false);
        } else {
            this.setMessage(null);
            this.setPageComplete(true);
        }
    }

    public String getDevId() {
        return this.devIdText.getText();
    }

    public String getMan() {
        return this.manText.getText();
    }

    public boolean isManSet() {
        return !this.manText.getText().isEmpty();
    }

    public String getMod() {
        return this.modText.getText();
    }

    public boolean isModSet() {
        return !this.modText.getText().isEmpty();
    }

    public String getLang() {
        return this.langText.getText();
    }

    public boolean isLangSet() {
        return !this.langText.getText().isEmpty();
    }

    public void setDevId(String devId) {
        this.devIdText.setText(devId);
    }

    public void setDevice(Device device) {
        this.device = device;
        this.devIdText.setText(device.getDeviceId().replace(String.valueOf(device.getDeviceIdType().getName()) + ":", ""));
        this.modText.setText(NodeHelpers.findFirstNode((Node)NodeHelpers.getNode((Node)device.getTree(), (String)DEV_INFO), (String)MOD).getData());
        this.manText.setText(NodeHelpers.findFirstNode((Node)NodeHelpers.getNode((Node)device.getTree(), (String)DEV_INFO), (String)MAN).getData());
        this.langText.setText(NodeHelpers.findFirstNode((Node)NodeHelpers.getNode((Node)device.getTree(), (String)DEV_INFO), (String)LANG).getData());
    }

    public Device getDevice() {
        NodeHelpers.findFirstNode((Node)NodeHelpers.getNode((Node)this.device.getTree(), (String)DEV_INFO), (String)MAN).setData(this.getMan());
        NodeHelpers.findFirstNode((Node)NodeHelpers.getNode((Node)this.device.getTree(), (String)DEV_INFO), (String)MOD).setData(this.getMod());
        NodeHelpers.findFirstNode((Node)NodeHelpers.getNode((Node)this.device.getTree(), (String)DEV_INFO), (String)LANG).setData(this.getLang());
        this.device.setDeviceId(String.valueOf(this.device.getDeviceIdType().getName()) + ":" + this.getDevId());
        return this.device;
    }
}

