/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum NodeFormat implements Enumerator
{
    CHR(0, "CHR", "chr"),
    B64(1, "B64", "b64"),
    BIN(2, "BIN", "bin"),
    INT(3, "INT", "int"),
    NODE(4, "NODE", "node"),
    NULL(5, "NULL", "null"),
    XML(6, "XML", "xml"),
    DATE(7, "DATE", "date"),
    TIME(8, "TIME", "time"),
    FLOAT(9, "FLOAT", "float"),
    BOOL(10, "BOOL", "bool");

    public static final int CHR_VALUE = 0;
    public static final int B64_VALUE = 1;
    public static final int BIN_VALUE = 2;
    public static final int INT_VALUE = 3;
    public static final int NODE_VALUE = 4;
    public static final int NULL_VALUE = 5;
    public static final int XML_VALUE = 6;
    public static final int DATE_VALUE = 7;
    public static final int TIME_VALUE = 8;
    public static final int FLOAT_VALUE = 9;
    public static final int BOOL_VALUE = 10;
    private static final NodeFormat[] VALUES_ARRAY;
    public static final List<NodeFormat> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new NodeFormat[]{CHR, B64, BIN, INT, NODE, NULL, XML, DATE, TIME, FLOAT, BOOL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static NodeFormat get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            NodeFormat result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static NodeFormat getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            NodeFormat result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static NodeFormat get(int value) {
        switch (value) {
            case 0: {
                return CHR;
            }
            case 1: {
                return B64;
            }
            case 2: {
                return BIN;
            }
            case 3: {
                return INT;
            }
            case 4: {
                return NODE;
            }
            case 5: {
                return NULL;
            }
            case 6: {
                return XML;
            }
            case 7: {
                return DATE;
            }
            case 8: {
                return TIME;
            }
            case 9: {
                return FLOAT;
            }
            case 10: {
                return BOOL;
            }
        }
        return null;
    }

    private NodeFormat(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

