/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.basic;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.koneki.protocols.omadm.DMNode;
import org.eclipse.koneki.protocols.omadm.Result;
import org.eclipse.koneki.protocols.omadm.Status;
import org.eclipse.koneki.protocols.omadm.StatusCode;
import org.eclipse.koneki.simulators.omadm.model.CommandManagement;
import org.eclipse.koneki.simulators.omadm.model.Node;
import org.eclipse.koneki.simulators.omadm.model.NodeFormat;
import org.eclipse.koneki.simulators.omadm.model.OMADMSimulatorFactory;
import org.eclipse.koneki.simulators.omadm.model.OMADMSimulatorPackage;
import org.eclipse.koneki.simulators.omadm.model.util.NodeHelpers;

public abstract class DMCommandHelper {
    public static Status add(Node tree, EditingDomain editingDomain, String target, String format, String type, String data, boolean mustWork) {
        Node node = NodeHelpers.getNode((Node)tree, (String)target);
        if (node != null) {
            if (mustWork) {
                return DMCommandHelper.replace(tree, editingDomain, target, format, type, data, true);
            }
            return StatusCode.ALREADY_EXISTS;
        }
        Node ancestorNode = NodeHelpers.getExistAncestorNode((Node)tree, (String)target);
        if (ancestorNode.isLeaf()) {
            if (mustWork) {
                DMCommandHelper.replace(tree, editingDomain, ancestorNode.getPath(), NodeFormat.NODE.getLiteral(), "", "", true);
            } else {
                return StatusCode.COMMAND_NOT_ALLOWED;
            }
        }
        CompoundCommand compoundCommand = new CompoundCommand();
        String[] childrenName = NodeHelpers.getChildrenNames((String)ancestorNode.getPath(), (String)target);
        Node precedant = ancestorNode;
        int i = 0;
        while (i < childrenName.length - 1) {
            Node child = OMADMSimulatorFactory.eINSTANCE.createNode();
            child.setData("");
            child.setFormat(NodeFormat.NODE);
            child.setName(childrenName[i]);
            child.setType("");
            DMCommandHelper.defaultManagement(child);
            compoundCommand.append((Command)new AddCommand(editingDomain, (EObject)precedant, (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__CHILDREN, (Object)child));
            precedant = child;
            ++i;
        }
        Node child = OMADMSimulatorFactory.eINSTANCE.createNode();
        child.setData(data);
        child.setFormat(NodeFormat.get((String)format));
        child.setName(childrenName[childrenName.length - 1]);
        child.setType(type);
        DMCommandHelper.defaultManagement(child);
        compoundCommand.append((Command)new AddCommand(editingDomain, (EObject)precedant, (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__CHILDREN, (Object)child));
        editingDomain.getCommandStack().execute((Command)compoundCommand);
        return StatusCode.OK;
    }

    public static Status copy(Node tree, EditingDomain editingDomain, String target, String source, boolean mustWork) {
        Node sourceNode = NodeHelpers.getNode((Node)tree, (String)source);
        if (sourceNode != null) {
            return DMCommandHelper.add(tree, editingDomain, target, sourceNode.getFormat().getLiteral(), sourceNode.getType(), sourceNode.getData(), mustWork);
        }
        return DMCommandHelper.add(tree, editingDomain, target, NodeFormat.NODE.getLiteral(), "", "", mustWork);
    }

    public static Status delete(Node tree, EditingDomain editingDomain, String target, boolean mustWork) {
        Node node = NodeHelpers.getNode((Node)tree, (String)target);
        if (node != null) {
            if (!node.isRoot()) {
                editingDomain.getCommandStack().execute((Command)new DeleteCommand(editingDomain, Arrays.asList(node)));
                return StatusCode.OK;
            }
            if (mustWork) {
                return StatusCode.OK;
            }
            return StatusCode.COMMAND_NOT_ALLOWED;
        }
        if (mustWork) {
            return StatusCode.OK;
        }
        return StatusCode.NOT_FOUND;
    }

    public static Status get(Node tree, EditingDomain editingDomain, String target, boolean mustWork) {
        Node node = NodeHelpers.getNode((Node)tree, (String)target);
        if (node != null) {
            if (node.isLeaf()) {
                return new Result(StatusCode.OK, new DMNode(target, node.getFormat().getLiteral(), node.getType(), node.getData()));
            }
            StringBuffer dataResults = new StringBuffer();
            if (node.getChildren().size() >= 1) {
                Iterator it = node.getChildren().iterator();
                dataResults.append(((Node)it.next()).getName());
                while (it.hasNext()) {
                    dataResults.append("/").append(((Node)it.next()).getName());
                }
            } else {
                dataResults.append("");
            }
            return new Result(StatusCode.OK, new DMNode(target, "node", "text/plain", dataResults.toString()));
        }
        if (mustWork) {
            DMCommandHelper.add(tree, editingDomain, target, NodeFormat.NODE.getLiteral(), "", "", true);
            return DMCommandHelper.get(tree, editingDomain, target, true);
        }
        return StatusCode.NOT_FOUND;
    }

    public static Status replace(Node tree, EditingDomain editingDomain, String target, String format, String type, String data, boolean mustWork) {
        Node node = NodeHelpers.getNode((Node)tree, (String)target);
        if (node != null) {
            if (!node.isRoot()) {
                CompoundCommand compoundCommand = new CompoundCommand();
                if (node.isInterior()) {
                    if (mustWork && NodeFormat.get((String)format) != NodeFormat.NODE) {
                        compoundCommand.append((Command)new DeleteCommand(editingDomain, (Collection)node.getChildren()));
                    } else if (!mustWork) {
                        return StatusCode.COMMAND_NOT_ALLOWED;
                    }
                }
                compoundCommand.append((Command)new SetCommand(editingDomain, (EObject)node, (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__FORMAT, (Object)NodeFormat.get((String)format)));
                compoundCommand.append((Command)new SetCommand(editingDomain, (EObject)node, (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__TYPE, (Object)type));
                compoundCommand.append((Command)new SetCommand(editingDomain, (EObject)node, (EStructuralFeature)OMADMSimulatorPackage.Literals.NODE__DATA, (Object)data));
                editingDomain.getCommandStack().execute((Command)compoundCommand);
                return StatusCode.OK;
            }
            if (mustWork) {
                return StatusCode.OK;
            }
            return StatusCode.COMMAND_NOT_ALLOWED;
        }
        if (mustWork) {
            return DMCommandHelper.add(tree, editingDomain, target, format, type, data, true);
        }
        return StatusCode.NOT_FOUND;
    }

    private static void defaultManagement(Node node) {
        node.setGetManagement(CommandManagement.INHERITED);
        node.setGetCode(StatusCode.OK.getCode());
        node.setAddManagement(CommandManagement.INHERITED);
        node.setAddCode(StatusCode.OK.getCode());
        node.setDeleteManagement(CommandManagement.INHERITED);
        node.setDeleteCode(StatusCode.OK.getCode());
        node.setCopyManagement(CommandManagement.INHERITED);
        node.setCopyCode(StatusCode.OK.getCode());
        node.setReplaceManagement(CommandManagement.INHERITED);
        node.setReplaceCode(StatusCode.OK.getCode());
        node.setExecManagement(CommandManagement.INHERITED);
        node.setExecCode(StatusCode.OPTIONAL_FEATURE_NOT_SUPPORTED.getCode());
    }
}

