/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.internal;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.koneki.protocols.omadm.CommandHandler;
import org.eclipse.koneki.protocols.omadm.DMGenericAlert;
import org.eclipse.koneki.protocols.omadm.ProtocolListener;
import org.eclipse.koneki.protocols.omadm.client.DMClient;
import org.eclipse.koneki.simulators.omadm.DMSimulator;
import org.eclipse.koneki.simulators.omadm.basic.DMBasicSimulator;
import org.eclipse.koneki.simulators.omadm.basic.DMExecHandler;
import org.eclipse.koneki.simulators.omadm.model.Node;
import org.osgi.service.component.ComponentContext;

public class DMBasicSimulatorComponent
implements DMSimulator {
    private DMBasicSimulator simulator;
    private final Set<DMExecHandler> execHandlers = new HashSet<DMExecHandler>();

    protected void activate(ComponentContext ctxt) {
        this.simulator = new DMBasicSimulator((DMClient)ctxt.locateService("DMClient"));
        for (DMExecHandler execHandler : this.execHandlers) {
            this.simulator.addExecHandler(execHandler);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        for (DMExecHandler execHandler : this.execHandlers) {
            this.simulator.removeExecHandler(execHandler);
        }
        this.simulator = null;
    }

    protected void bind(DMExecHandler execHandler) {
        this.execHandlers.add(execHandler);
        if (this.simulator != null) {
            this.simulator.addExecHandler(execHandler);
        }
    }

    protected void unbind(DMExecHandler execHandler) {
        this.execHandlers.remove(execHandler);
        if (this.simulator != null) {
            this.simulator.removeExecHandler(execHandler);
        }
    }

    @Override
    public void simulate(URI server, Node tree, EditingDomain editingDomain, CommandHandler commandHandler) {
        this.simulator.simulate(server, tree, editingDomain, commandHandler);
    }

    @Override
    public void simulate(URI server, Node tree, EditingDomain editingDomain, CommandHandler commandHandler, ProtocolListener[] protocolLinsteners) {
        this.simulator.simulate(server, tree, editingDomain, commandHandler, protocolLinsteners);
    }

    @Override
    public void simulate(URI server, Node tree, EditingDomain editingDomain, CommandHandler commandHandler, DMGenericAlert[] genericAlerts) {
        this.simulator.simulate(server, tree, editingDomain, commandHandler, genericAlerts);
    }

    @Override
    public void simulate(URI server, Node tree, EditingDomain editingDomain, CommandHandler commandHandler, ProtocolListener[] protocolListeners, DMGenericAlert[] genericAlerts) {
        this.simulator.simulate(server, tree, editingDomain, commandHandler, protocolListeners, genericAlerts);
    }
}

