/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.emfforms.internal.validation;

import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.databinding.swt.ISWTObservable;
import org.eclipse.pde.emfforms.editor.ValidatingService;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IMessageManager;

public class ValidatingService35
implements ValidatingService {
    public void analyzeDiagnostic(DataBindingContext dataBindingContext, Diagnostic diagnostic, IMessageManager messageManager) {
        boolean atLeastOneErroneousBinding = false;
        for (Object o : dataBindingContext.getBindings()) {
            Binding binding = (Binding)o;
            IObserving emfObservable = null;
            ISWTObservable swtObservable = null;
            if (binding.getModel() instanceof IObserving && binding.getTarget() instanceof ISWTObservable) {
                emfObservable = (IObserving)binding.getModel();
                swtObservable = (ISWTObservable)binding.getTarget();
            } else if (binding.getTarget() instanceof IObserving && binding.getModel() instanceof ISWTObservable) {
                swtObservable = (ISWTObservable)binding.getModel();
                emfObservable = (IObserving)binding.getTarget();
            }
            if (emfObservable == null || swtObservable == null || !this.checkBinding(emfObservable, swtObservable, diagnostic, messageManager)) continue;
            atLeastOneErroneousBinding = true;
        }
        if (!atLeastOneErroneousBinding) {
            messageManager.addMessage((Object)diagnostic, diagnostic.getMessage(), null, keyMap.getMessageProviderKey(diagnostic.getSeverity()));
        }
    }

    private boolean checkBinding(IObserving emfObservable, ISWTObservable swtObservable, Diagnostic diagnostic, IMessageManager messageManager) {
        List diagnosticData = diagnostic.getData();
        if (diagnosticData.size() >= 2 && diagnosticData.get(0) == emfObservable.getObserved() && (emfObservable instanceof IObservableValue && diagnosticData.get(1) == ((IObservableValue)emfObservable).getValueType() || emfObservable instanceof IObservableList && diagnosticData.get(1) == ((IObservableList)emfObservable).getElementType()) && swtObservable.getWidget() instanceof Control) {
            Control control = (Control)swtObservable.getWidget();
            messageManager.addMessage((Object)swtObservable, diagnostic.getMessage(), null, keyMap.getMessageProviderKey(diagnostic.getSeverity()), control);
            return true;
        }
        return false;
    }
}

