/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.emfforms.builder;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelFileDeltaVisitor
implements IResourceDeltaVisitor {
    private Map<Resource, IResource> modifiedResources = new HashMap<Resource, IResource>();
    private String _contentType;

    public ModelFileDeltaVisitor(String contentType) {
        this._contentType = contentType;
    }

    public Map<Resource, IResource> getModifiedResources() {
        return this.modifiedResources;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        switch (delta.getKind()) {
            case 1: 
            case 2: {
                break;
            }
            case 4: {
                if (resource instanceof IContainer) {
                    return true;
                }
                if (this._contentType != null && !this._contentType.equals(((IFile)resource).getContentDescription().getContentType().getId())) {
                    return false;
                }
                URI resourceURI = URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
                Resource modelResource = new AdapterFactoryEditingDomain((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), (CommandStack)new BasicCommandStack()).getResourceSet().getResource(resourceURI, true);
                if (modelResource == null || !modelResource.isLoaded() || this.modifiedResources.containsKey(modelResource)) break;
                this.modifiedResources.put(modelResource, resource);
            }
        }
        return true;
    }
}

