/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.emfforms.editor;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.emfforms.editor.AbstractEmfFormPage;
import org.eclipse.pde.emfforms.editor.DefaultEmfFormEditorConfig;
import org.eclipse.pde.emfforms.editor.IEmfFormEditorConfig;
import org.eclipse.pde.emfforms.editor.IEmfFormPage;
import org.eclipse.pde.emfforms.editor.PDEFormToolkit;
import org.eclipse.pde.emfforms.internal.Activator;
import org.eclipse.pde.emfforms.internal.editor.EmfContentOutlinePage;
import org.eclipse.pde.emfforms.internal.editor.Messages;
import org.eclipse.pde.emfforms.internal.editor.ResourceDeltaVisitor;
import org.eclipse.pde.emfforms.internal.editor.SharedClipboardAdapterFactoryEditingDomain;
import org.eclipse.pde.emfforms.internal.editor.SimpleSourcePage;
import org.eclipse.pde.emfforms.internal.editor.XmlSourcePage;
import org.eclipse.pde.emfforms.internal.validation.ValidatingEContentAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EmfFormEditor<O extends EObject>
extends FormEditor
implements IEditingDomainProvider,
ISelectionProvider,
IViewerProvider,
IResourceChangeListener,
IGotoMarker {
    private EditingDomain _editingDomain;
    private IEmfFormEditorConfig<EmfFormEditor<O>, O> _editorConfig;
    private ComposedAdapterFactory _adapterFactory;
    private final IObservableValue _observableValue = new WritableValue();
    private O _currentEObject;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    private CommandStackListener _commandStackListener = new CommandStackListener(){

        public void commandStackChanged(final EventObject event) {
            EmfFormEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    EmfFormEditor.this.handleCommandStackChanged(event);
                }
            });
        }
    };
    private PropertySheetPage propertySheetPage;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    private DataBindingContext _bindingContext;
    private ValidatingEContentAdapter _validator;
    private boolean isSaving = false;
    private EmfContentOutlinePage contentOutlinePage;
    private ResourceDeltaVisitor<O> _visitor;

    public EmfFormEditor() {
        this._editorConfig = this.getFormEditorConfig();
        this.init();
    }

    protected IEmfFormEditorConfig<EmfFormEditor<O>, O> getFormEditorConfig() {
        return new DefaultEmfFormEditorConfig(this);
    }

    private void init() {
        this._editingDomain = this.createEditingDomain();
        this._bindingContext = new EMFDataBindingContext();
        this._validator = new ValidatingEContentAdapter(this);
        this.getEditingDomain().getCommandStack().addCommandStackListener(this._commandStackListener);
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
    }

    public void dispose() {
        this.getEditingDomain().getCommandStack().removeCommandStackListener(this._commandStackListener);
        if (this._adapterFactory != null) {
            this._adapterFactory.dispose();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    protected EditingDomain createEditingDomain() {
        this._adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this._adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this._adapterFactory.addAdapterFactory(this.getSpecificAdapterFactory());
        this._adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        if (this.getEditorConfig().isUsingSharedClipboard()) {
            return new SharedClipboardAdapterFactoryEditingDomain((AdapterFactory)this._adapterFactory, (CommandStack)commandStack, new HashMap<Resource, Boolean>());
        }
        return new AdapterFactoryEditingDomain((AdapterFactory)this._adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    protected abstract AdapterFactory getSpecificAdapterFactory();

    protected void addPages() {
        this.createModel();
        try {
            for (IEmfFormPage page : this.getPagesToAdd()) {
                this.addPage(page);
            }
            this.addSourcePage();
            int i = 0;
            for (Image img : this.getPagesImages()) {
                this.setPageImage(i++, img);
            }
        }
        catch (PartInitException e) {
            Activator.logException(e, Messages.EmfFormEditor_InitError);
        }
    }

    private void addSourcePage() throws PartInitException {
        if (!this.getEditorConfig().isShowSourcePage()) {
            return;
        }
        boolean isXmlUiBundlePresent = false;
        BundleContext bc = Activator.getDefault().getBundle().getBundleContext();
        Bundle[] bundleArray = bc.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if ("org.eclipse.wst.xml.ui".equals(b.getSymbolicName())) {
                isXmlUiBundlePresent = true;
                break;
            }
            ++n2;
        }
        if (isXmlUiBundlePresent) {
            this.addPage(new XmlSourcePage(this));
        } else {
            this.addPage(new SimpleSourcePage(this));
        }
    }

    protected abstract List<? extends IEmfFormPage> getPagesToAdd() throws PartInitException;

    protected abstract List<Image> getPagesImages();

    public void doSave(IProgressMonitor monitor) {
        try {
            try {
                this.isSaving = true;
                this.internalDoValidate(monitor);
                WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                    public void execute(IProgressMonitor monitor) throws CoreException {
                        try {
                            EmfFormEditor.this.internalDoSave(monitor);
                        }
                        catch (IOException ioe) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.emfforms", 0, Messages.EmfFormEditor_SaveError, (Throwable)ioe));
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
                    if (this.getEditingDomain().getCommandStack() instanceof BasicCommandStack) {
                        ((BasicCommandStack)this.getEditingDomain().getCommandStack()).saveIsDone();
                    } else {
                        this.getEditingDomain().getCommandStack().flush();
                    }
                    this.firePropertyChange(257);
                }
                catch (Exception exception) {
                    MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.EmfFormEditor_SaveError_Title, (String)Messages.EmfFormEditor_SaveError_Msg);
                    Activator.logException(exception, Messages.EmfFormEditor_SaveError_Exception);
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                this.isSaving = false;
            }
        }
        finally {
            this.isSaving = false;
        }
    }

    protected void internalDoSave(IProgressMonitor monitor) throws IOException {
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        boolean first = true;
        for (Resource resource : this.getEditingDomain().getResourceSet().getResources()) {
            if (!first && resource.getContents().isEmpty() && !this.isPersisted(resource) || this.getEditingDomain().isReadOnly(resource)) continue;
            resource.save(saveOptions);
            first = false;
        }
    }

    protected void internalDoValidate(IProgressMonitor monitor) {
        IEmfFormEditorConfig.VALIDATE_ON_SAVE validateOnSave = this.getEditorConfig().getValidateOnSave();
        Diagnostic diagnostic = Diagnostic.OK_INSTANCE;
        if (validateOnSave != IEmfFormEditorConfig.VALIDATE_ON_SAVE.NO_VALIDATION) {
            diagnostic = this._validator.validate((EObject)this.getCurrentEObject());
        }
        if (diagnostic.getSeverity() != 0) {
            switch (validateOnSave) {
                case VALIDATE_AND_WARN: {
                    int dialogResult = new DiagnosticDialog(this.getSite().getShell(), Messages.EmfFormEditor_DiaDialog_InvalidModel_Title, null, diagnostic, 6){

                        protected Control createMessageArea(Composite composite) {
                            this.message = Messages.EmfFormEditor_ValidationWarn_Msg;
                            return super.createMessageArea(composite);
                        }

                        protected void createButtonsForButtonBar(Composite parent) {
                            this.createButton(parent, 0, IDialogConstants.YES_LABEL, true);
                            this.createButton(parent, 1, IDialogConstants.NO_LABEL, true);
                            this.createDetailsButton(parent);
                        }
                    }.open();
                    if (dialogResult == 0) break;
                    if (monitor != null) {
                        monitor.setCanceled(true);
                    }
                    throw new OperationCanceledException();
                }
                case VALIDATE_AND_ABORT: {
                    new DiagnosticDialog(this.getSite().getShell(), Messages.EmfFormEditor_DiaDialog_InvalidModel_Title, null, diagnostic, 6){

                        protected Control createMessageArea(Composite composite) {
                            this.message = Messages.EmfFormEditor_ValidationError_Msg;
                            return super.createMessageArea(composite);
                        }
                    }.open();
                    monitor.setCanceled(true);
                    throw new OperationCanceledException();
                }
            }
        }
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.getEditingDomain().getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.getEditingDomain().getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.getEditingDomain().getCommandStack()).isSaveNeeded();
    }

    public final boolean isSaveAsAllowed() {
        return this.getEditorConfig().isSaveAsAllowed();
    }

    protected PDEFormToolkit createToolkit(Display display) {
        return this.getEditorConfig().createPDEFormToolkit(display);
    }

    public void createModel() {
        Resource resource;
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        try {
            resource = this.getEditingDomain().getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception exception) {
            resource = this.getEditingDomain().getResourceSet().getResource(resourceURI, false);
        }
        this.setMainResource(resource);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void setMainResource(Resource resource) {
        if (this._currentEObject != null) {
            this._currentEObject.eAdapters().remove((Object)this._validator);
        }
        this._currentEObject = (EObject)resource.getContents().get(0);
        this._observableValue.setValue(this._currentEObject);
        this._currentEObject.eAdapters().add((Object)this._validator);
        this.validate();
    }

    public EditingDomain getEditingDomain() {
        return this._editingDomain;
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public O getCurrentEObject() {
        return this._currentEObject;
    }

    public IObservableValue getInputObservable() {
        return this._observableValue;
    }

    public void addViewerToListenTo(StructuredViewer viewer) {
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                EmfFormEditor.this.setSelection(selectionChangedEvent.getSelection());
            }
        });
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public boolean isSaving() {
        return this.isSaving;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
    }

    public Viewer getViewer() {
        AbstractEmfFormPage page = (AbstractEmfFormPage)this.pages.get(this.getActivePage());
        return page.getViewer();
    }

    protected void handleCommandStackChanged(EventObject event) {
        Collection objects;
        Command mostRecentCommand;
        this.firePropertyChange(257);
        this.firePropertyChange(1);
        IFormPage activePage = this.getActivePageInstance();
        if (activePage != null && ((AbstractEmfFormPage)activePage).getViewer() != null && (mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand()) != null && mostRecentCommand instanceof CreateChildCommand && (objects = mostRecentCommand.getAffectedObjects()) != null && !objects.isEmpty()) {
            ((AbstractEmfFormPage)activePage).getViewer().setSelection((ISelection)new StructuredSelection(objects.toArray()[objects.size() - 1]), true);
        }
    }

    private IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            this.contentOutlinePage = new EmfContentOutlinePage(this);
            this.contentOutlinePage.setViewerInput(this.getEditorConfig().getOutlineInput(this.getCurrentEObject()));
            this.contentOutlinePage.setViewerComparator(this.getOutlineComparator());
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    EmfFormEditor.this.handleContentOutlineSelection(event.getSelection(), EmfFormEditor.this.getViewer());
                }
            });
            this.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    EmfFormEditor.this.handleContentOutlineSelection(event.getSelection(), (Viewer)EmfFormEditor.this.contentOutlinePage.getViewer());
                }
            });
        }
        return this.contentOutlinePage;
    }

    protected ViewerComparator getOutlineComparator() {
        return null;
    }

    public void handleContentOutlineSelection(ISelection selection, Viewer viewerToSnych) {
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && viewerToSnych != null && ((IStructuredSelection)selection).getFirstElement() != ((IStructuredSelection)viewerToSnych.getSelection()).getFirstElement()) {
            viewerToSnych.setSelection((ISelection)new StructuredSelection(((IStructuredSelection)selection).getFirstElement()));
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        try {
            this._visitor = new ResourceDeltaVisitor(this);
            delta.accept(this._visitor);
        }
        catch (CoreException ce) {
            Activator.log(ce);
        }
    }

    public ComposedAdapterFactory getAdapterFactory() {
        return this._adapterFactory;
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.getFormEditorConfig().isShowOutlinePage() ? this.getContentOutlinePage() : null;
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new ExtendedPropertySheetPage((AdapterFactoryEditingDomain)this._editingDomain){

                public void setSelectionToViewer(List<?> selection) {
                    EmfFormEditor.this.setFocus();
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    if (EmfFormEditor.this.getActionBarContributor() != null) {
                        EmfFormEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                    }
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this._adapterFactory));
        }
        return this.propertySheetPage;
    }

    public void gotoMarker(IMarker marker) {
        if (this.getViewer() == null) {
            return;
        }
        try {
            String uriAttribute;
            if (marker.getType().equals("org.eclipse.emf.ecore.diagnostic") && (uriAttribute = marker.getAttribute("uri", null)) != null) {
                URI uri = URI.createURI((String)uriAttribute);
                EObject eObject = this.getEditingDomain().getResourceSet().getEObject(uri, true);
                if (eObject != null && this.getEditingDomain() instanceof AdapterFactoryEditingDomain) {
                    AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)this.getEditingDomain();
                    if (this.getViewer() != null) {
                        this.getViewer().setSelection((ISelection)new StructuredSelection(Collections.singleton(editingDomain.getWrapper((Object)eObject)).toArray()));
                    }
                }
            }
        }
        catch (CoreException exception) {
            Activator.log(exception);
        }
    }

    public DataBindingContext getDataBindingContext() {
        return this._bindingContext;
    }

    public void setFocus() {
        super.setFocus();
        if (this.getActivePageInstance() != null) {
            this.getActivePageInstance().setFocus();
        }
    }

    public abstract String getID();

    public IEmfFormEditorConfig<EmfFormEditor<O>, O> getEditorConfig() {
        return this._editorConfig;
    }

    void validate() {
        this._validator.validate();
    }
}

