/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.emfforms.editor;

import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDEFormToolkit
extends FormToolkit {
    private static final String KEEP_CONTROL_FOREGROUND = "KEEPFOREGROUND";
    private static final String KEEP_CONTROL_BACKGROUND = "KEEPBACKGROUND";

    public PDEFormToolkit(Display display) {
        super(display);
    }

    private void super$adapt(Composite composite) {
        composite.setBackground(this.getColors().getBackground());
        composite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ((Control)e.widget).setFocus();
            }
        });
    }

    public void adapt(Composite composite) {
        if (composite == null) {
            return;
        }
        this.super$adapt(composite);
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Composite) {
                this.adapt((Composite)children[i]);
            } else if (!(composite instanceof Section)) {
                Boolean keepForeground = (Boolean)children[i].getData(KEEP_CONTROL_FOREGROUND);
                Boolean keepBackground = (Boolean)children[i].getData(KEEP_CONTROL_BACKGROUND);
                Color c = null;
                if (keepForeground != null && keepForeground.booleanValue()) {
                    c = children[i].getForeground();
                }
                Color c2 = null;
                if (keepBackground != null && keepBackground.booleanValue()) {
                    c2 = children[i].getBackground();
                }
                super.adapt(children[i], true, true);
                if (c != null) {
                    children[i].setForeground(c);
                }
                if (c2 != null) {
                    children[i].setBackground(c2);
                }
            }
            ++i;
        }
    }

    public Combo createCombo(Composite parent, int style) {
        Combo combo = new Combo(parent, style | 0x800000);
        this.adapt((Control)combo, false, false);
        return combo;
    }

    public List createList(Composite parent, int style) {
        List list = new List(parent, style | 0x800000);
        this.adapt((Control)list, false, false);
        return list;
    }

    public ManagedForm createManagedForm(FormToolkit toolkit, ScrolledForm sForm) {
        return new ManagedForm(toolkit, sForm);
    }

    public ManagedForm createManagedForm(Composite parent) {
        return new ManagedForm(parent);
    }

    public StyledText createStyledText(Composite parent, int style) {
        StyledText styledText = new StyledText(parent, style);
        this.adapt((Control)styledText, false, false);
        return styledText;
    }

    public Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setText(text);
        this.adapt((Control)group, false, false);
        return group;
    }

    public ComboViewer createComboViewer(Composite parent, int style) {
        ComboViewer cviewer = new ComboViewer(parent, style);
        this.adapt((Control)cviewer.getCombo(), false, false);
        return cviewer;
    }

    public TableViewer createTableViewer(Composite parent, int style) {
        TableViewer tviewer = new TableViewer(parent, style);
        this.adapt((Control)tviewer.getTable(), false, false);
        return tviewer;
    }

    public DateTime createDateTime(Composite parent, int style) {
        DateTime dateTime = new DateTime(parent, style);
        this.adapt((Control)dateTime, false, false);
        return dateTime;
    }

    public static Pair<Text, Button> createLabelAndBrowseText(String label, Composite composite) {
        GridLayoutFactory.fillDefaults().margins(0, 5).numColumns(2).applyTo(composite);
        Label labelName = new Label(composite, 0);
        labelName.setText(label);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)labelName);
        labelName.setAlignment(16384);
        Composite browseComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(browseComposite);
        Text text = new Text(browseComposite, 2056);
        text.setEditable(false);
        text.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)text);
        Button browseButton = new Button(browseComposite, 0x800008);
        browseButton.setText("...");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)browseComposite);
        return new Pair<Text, Button>(text, browseButton);
    }

    public static Pair<ListViewer, Pair<Button, Button>> createLabelAndListAddRemove(String label, Composite composite) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Label labelName = new Label(composite, 0);
        labelName.setText(label);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)labelName);
        labelName.setAlignment(16384);
        Composite browseComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(browseComposite);
        ListViewer listViewer = new ListViewer(browseComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 2).hint(-1, 80).applyTo((Control)listViewer.getList());
        Button addButton = new Button(browseComposite, 0x800008);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)addButton);
        addButton.setText("+");
        Button removeButton = new Button(browseComposite, 0x800008);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)removeButton);
        removeButton.setText("-");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)browseComposite);
        return new Pair<ListViewer, Pair<Button, Button>>(listViewer, new Pair<Button, Button>(addButton, removeButton));
    }

    public static ListViewer createLabelAndList(String label, Composite composite) {
        return PDEFormToolkit.createLabelAndList(label, composite, -1);
    }

    public static ListViewer createLabelAndList(String label, Composite composite, int labelHorizontalWidthHint) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Label labelName = new Label(composite, 0);
        labelName.setText(label);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 1).hint(labelHorizontalWidthHint, -1).applyTo((Control)labelName);
        labelName.setAlignment(16384);
        ListViewer listViewer = new ListViewer(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).hint(-1, 80).applyTo((Control)listViewer.getList());
        return listViewer;
    }

    public static Text createLabelAndText(String label, Composite composite, int labelHorizontalWidthHint) {
        GridLayoutFactory.fillDefaults().margins(0, 5).numColumns(2).applyTo(composite);
        Label labelName = new Label(composite, 0);
        labelName.setText(label);
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(labelHorizontalWidthHint, -1).applyTo((Control)labelName);
        labelName.redraw();
        labelName.setAlignment(16384);
        Text text = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)text);
        return text;
    }

    public static Text createLabelAndText(String label, Composite composite) {
        return PDEFormToolkit.createLabelAndText(label, composite, -1);
    }

    public static Text createLabelAndTextArea(String label, Composite composite) {
        return PDEFormToolkit.createLabelAndTextArea(label, composite, false);
    }

    public static Text createLabelAndTextArea(String label, Composite composite, int labelHorizontalWidthHint) {
        return PDEFormToolkit.createLabelAndTextArea(label, composite, false, labelHorizontalWidthHint);
    }

    public static Text createLabelAndTextArea(String label, Composite composite, boolean scrollable) {
        return PDEFormToolkit.createLabelAndTextArea(label, composite, scrollable, -1);
    }

    public static Text createLabelAndTextArea(String label, Composite composite, boolean scrollable, int labelHorizontalWidthHint) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Label labelName = new Label(composite, 0);
        labelName.setText(label);
        GridDataFactory.fillDefaults().align(4, 128).hint(labelHorizontalWidthHint, -1).applyTo((Control)labelName);
        labelName.setAlignment(16384);
        int sytle = 2050;
        if (scrollable) {
            sytle = sytle | 0x40 | 0x200;
        }
        Text text = new Text(composite, sytle);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 120).applyTo((Control)text);
        return text;
    }

    public static ComboViewer createLabelAndComboViewer(String label, Composite composite) {
        return PDEFormToolkit.createLabelAndComboViewer(label, composite, -1);
    }

    public static ComboViewer createLabelAndComboViewer(String label, Composite composite, int labelHorizontalWidthHint) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Label labelName = new Label(composite, 0);
        labelName.setText(label);
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(labelHorizontalWidthHint, -1).applyTo((Control)labelName);
        labelName.setAlignment(16384);
        ComboViewer comboViewer = new ComboViewer(composite, 8);
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        comboViewer.setSorter(new ViewerSorter());
        GridDataFactory.fillDefaults().grab(true, false).applyTo(comboViewer.getControl());
        return comboViewer;
    }

    public static ComboViewer createLabelAndNonReadOnlyComboViewer(String label, Composite composite) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Label labelName = new Label(composite, 0);
        labelName.setText(label);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)labelName);
        labelName.setAlignment(16384);
        ComboViewer comboViewer = new ComboViewer(composite, 2048);
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        comboViewer.setSorter(new ViewerSorter());
        GridDataFactory.fillDefaults().grab(true, false).applyTo(comboViewer.getControl());
        return comboViewer;
    }

    public static DateTime createLabelAndCalendar(String label, Composite composite) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Label labelName = new Label(composite, 0);
        labelName.setText(label);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)labelName);
        labelName.setAlignment(16384);
        DateTime dateTime = new DateTime(composite, 1024);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)dateTime);
        return dateTime;
    }

    public static Button createLabelAndCheckBox(String label, Composite composite) {
        return PDEFormToolkit.createLabelAndButton(label, composite, 32, -1);
    }

    public static Button createLabelAndCheckBox(String label, Composite composite, int labelHorizontalWidthHint) {
        return PDEFormToolkit.createLabelAndButton(label, composite, 32, labelHorizontalWidthHint);
    }

    public static Button createCheckBoxAndLabel(String label, Composite composite) {
        return PDEFormToolkit.createButtonAndLabel(label, composite, 32);
    }

    public static Button createRadioAndLabel(String label, Composite composite) {
        return PDEFormToolkit.createButtonAndLabel(label, composite, 16);
    }

    private static Button createButtonAndLabel(String label, Composite composite, int type) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Button button = new Button(composite, type | 0x800000);
        button.setText(label);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).span(2, 1).applyTo((Control)button);
        return button;
    }

    private static Button createLabelAndButton(String label, Composite parent, int type, int labelHorizontalWidthHint) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        Label labelName = new Label(parent, 0);
        labelName.setText(label);
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(labelHorizontalWidthHint, -1).applyTo((Control)labelName);
        labelName.setAlignment(16384);
        Button button = new Button(parent, type | 0x800000);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)button);
        return button;
    }

    public static Spinner createLabelAndSpinner(String label, Composite parent) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        Label labelName = new Label(parent, 0);
        labelName.setText(label);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)labelName);
        labelName.setAlignment(16384);
        Spinner spinner = new Spinner(parent, 64);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)spinner);
        return spinner;
    }

    public static Label createLabelAndLabel(String label, Composite parent) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        Label labelName = new Label(parent, 0);
        labelName.setText(label);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)labelName);
        labelName.setAlignment(16384);
        Label labelValue = new Label(parent, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)labelValue);
        return labelValue;
    }

    public static ToolBarManager createSectionToolBarManager(Composite section) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl(section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (handCursor != null && !handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        return toolBarManager;
    }

    public static Link createLink(String label, Composite composite) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Link link = new Link(composite, 0);
        link.setText(label);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)link);
        return link;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pair<U, V> {
        public U left;
        public V right;

        public Pair(U u, V v) {
            this.left = u;
            this.right = v;
        }
    }
}

