/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.emfforms.internal.validation;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichTooltipHyperlinkAdapter
extends HyperlinkAdapter {
    private static final String INFO = "info";
    private static final String WARNING = "warning";
    private static final String ERROR = "error";
    private static final String OTHER_ERRORS = "Other errors";
    private IManagedForm _form;
    private Shell _shell;

    public RichTooltipHyperlinkAdapter(IManagedForm form) {
        this._form = form;
    }

    public void linkActivated(HyperlinkEvent e) {
        if (this._shell != null) {
            this._shell.dispose();
            this._shell = null;
            return;
        }
        String title = e.getLabel();
        Object href = e.getHref();
        Point hl = ((Control)e.widget).toDisplay(0, 0);
        hl.x += 10;
        hl.y += 20;
        this._shell = new Shell(this._form.getForm().getShell(), 16388);
        this._shell.setImage(this.getImage(this._form.getForm().getMessageType()));
        this._shell.setText(title);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo((Composite)this._shell);
        FormText text = this._form.getToolkit().createFormText((Composite)this._shell, true);
        Label l = new Label((Composite)text, 258);
        text.setControl("sep", (Control)l);
        GridDataFactory.fillDefaults().applyTo((Control)text);
        if (href instanceof IMessage[]) {
            Map<String, List<IMessage>> messagesMap = this.mapMessages((IMessage[])href, text);
            this.configureFormText(this._form.getForm().getForm(), text);
            text.setText(this.createFormTextContent(messagesMap), true, false);
        }
        this._shell.setLocation(hl);
        this._form.getToolkit().adapt((Composite)this._shell);
        this._shell.pack();
        this._shell.open();
    }

    private void configureFormText(final Form form, FormText text) {
        text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String is = (String)e.getHref();
                try {
                    int hashCode = Integer.parseInt(is);
                    IMessage[] messages = form.getChildrenMessages();
                    IMessage message = null;
                    IMessage[] iMessageArray = messages;
                    int n = messages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMessage m = iMessageArray[n2];
                        if (hashCode == m.hashCode()) {
                            message = m;
                            break;
                        }
                        ++n2;
                    }
                    RichTooltipHyperlinkAdapter.this._shell.dispose();
                    RichTooltipHyperlinkAdapter.this._shell = null;
                    Control c = message.getControl();
                    if (c != null) {
                        CTabItem item = RichTooltipHyperlinkAdapter.findCTabItem(c);
                        item.getParent().setSelection(item);
                        c.setFocus();
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        text.setImage(ERROR, this.getImage(3));
        text.setImage(WARNING, this.getImage(2));
        text.setImage(INFO, this.getImage(1));
    }

    private String createFormTextContent(Map<String, List<IMessage>> messagesMap) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<form>");
        for (Map.Entry<String, List<IMessage>> entry : messagesMap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            if (OTHER_ERRORS.equals(entry.getKey())) {
                pw.println("<p><control href=\"sep\" fill=\"true\"/></p>");
            }
            pw.println("<li style=\"image\" value=\"" + entry.getKey() + "\"><b>" + entry.getKey() + "</b></li>");
            for (IMessage message : entry.getValue()) {
                pw.print("<li vspace=\"false\" style=\"image\" bindent=\"10\" indent=\"28\" value=\"");
                switch (message.getMessageType()) {
                    case 3: {
                        pw.print(ERROR);
                        break;
                    }
                    case 2: {
                        pw.print(WARNING);
                        break;
                    }
                    case 1: {
                        pw.print(INFO);
                    }
                }
                pw.print("\"> <a href=\"");
                pw.print(String.valueOf(message.hashCode()));
                pw.print("\">");
                if (message.getPrefix() != null) {
                    pw.print(StringEscapeUtils.escapeHtml((String)message.getPrefix()));
                }
                pw.print(StringEscapeUtils.escapeHtml((String)message.getMessage()));
                pw.println("</a></li>");
            }
        }
        pw.println("</form>");
        pw.flush();
        return sw.toString();
    }

    private Map<String, List<IMessage>> mapMessages(IMessage[] messages, FormText text) {
        ArrayList<String> pagesNames = new ArrayList<String>();
        IMessage[] iMessageArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            IMessage msg = iMessageArray[n2];
            if (msg.getControl() != null) {
                CTabItem item = RichTooltipHyperlinkAdapter.findCTabItem(msg.getControl());
                CTabItem[] cTabItemArray = item.getParent().getItems();
                int n3 = cTabItemArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    CTabItem it = cTabItemArray[n4];
                    pagesNames.add(it.getText());
                    if (it.getImage() != null) {
                        text.setImage(it.getText(), it.getImage());
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        LinkedHashMap<String, List<IMessage>> res = new LinkedHashMap<String, List<IMessage>>();
        for (String s : pagesNames) {
            res.put(s, new ArrayList());
        }
        res.put(OTHER_ERRORS, new ArrayList());
        IMessage[] iMessageArray2 = messages;
        int n5 = messages.length;
        int n6 = 0;
        while (n6 < n5) {
            IMessage msg = iMessageArray2[n6];
            Form container = RichTooltipHyperlinkAdapter.findFormContainer(msg.getControl());
            String key = OTHER_ERRORS;
            if (container != null) {
                key = container.getText();
            }
            ((List)res.get(key)).add(msg);
            ++n6;
        }
        return res;
    }

    private Image getImage(int type) {
        switch (type) {
            case 3: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
            case 2: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }
            case 1: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
            }
        }
        return null;
    }

    private static Form findFormContainer(Control control) {
        if (control == null) {
            return null;
        }
        if (control instanceof Form) {
            return (Form)control;
        }
        return RichTooltipHyperlinkAdapter.findFormContainer((Control)control.getParent());
    }

    private static CTabItem findCTabItem(Control c) {
        Form container = RichTooltipHyperlinkAdapter.findFormContainer(c);
        Composite c1 = container.getParent();
        CTabFolder c2 = (CTabFolder)c1.getParent();
        CTabItem[] cTabItemArray = c2.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (item.getControl() == c1) {
                return item;
            }
            ++n2;
        }
        return null;
    }
}

