/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.emfforms.internal.validation;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.pde.emfforms.editor.EmfFormEditor;
import org.eclipse.pde.emfforms.editor.ValidatingService;
import org.eclipse.pde.emfforms.internal.Activator;
import org.eclipse.pde.emfforms.internal.validation.ValidatingService34;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.IFormPage;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatingEContentAdapter
extends EContentAdapter {
    private EmfFormEditor<?> _formEditor;
    private DataBindingContext _dataBindingContext;
    private Diagnostician _diagnostician;
    private ValidatingService validatingService;

    public ValidatingEContentAdapter(EmfFormEditor<?> formEditor) {
        this._formEditor = formEditor;
        this._dataBindingContext = formEditor.getDataBindingContext();
        this.forceValidatingService34Registration();
        this._diagnostician = new Diagnostician(){

            public String getObjectLabel(EObject eObject) {
                IItemLabelProvider itemLabelProvider;
                if (!eObject.eIsProxy() && (itemLabelProvider = (IItemLabelProvider)ValidatingEContentAdapter.this._formEditor.getAdapterFactory().adapt((Notifier)eObject, IItemLabelProvider.class)) != null) {
                    return itemLabelProvider.getText((Object)eObject);
                }
                return super.getObjectLabel(eObject);
            }

            protected boolean doValidateContents(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                Resource eContainerResource = eObject.eResource();
                EList eContents = eObject.eContents();
                if (!eContents.isEmpty()) {
                    boolean result = true;
                    Iterator i = eContents.iterator();
                    while (i.hasNext() && (result || diagnostics != null)) {
                        EObject child = (EObject)i.next();
                        Resource eChildResource = child.eResource();
                        if (eContainerResource == null || eChildResource != eContainerResource) continue;
                        result &= this.validate(child, diagnostics, context);
                    }
                    return result;
                }
                return true;
            }
        };
    }

    private void forceValidatingService34Registration() {
        if (this.getValidatorService() == null) {
            BundleContext context = Activator.getDefault().getBundle().getBundleContext();
            Hashtable<String, Integer> serviceProperties = new Hashtable<String, Integer>();
            ((Dictionary)serviceProperties).put("service.ranking", 10);
            context.registerService(ValidatingService.class.getName(), (Object)new ValidatingService34(), serviceProperties);
        }
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (!NotificationFilter.READ.matches(notification)) {
            this.validate();
        }
    }

    public void validate() {
        IFormPage activePageInstance = this._formEditor.getActivePageInstance();
        if (activePageInstance == null || activePageInstance.getManagedForm() == null) {
            return;
        }
        final IMessageManager messageManager = activePageInstance.getManagedForm().getMessageManager();
        messageManager.removeAllMessages();
        messageManager.setAutoUpdate(false);
        Diagnostic diagnostics = this.validate((EObject)this._formEditor.getCurrentEObject());
        for (Diagnostic diagnostic : diagnostics.getChildren()) {
            this.getValidatorService().analyzeDiagnostic(this._dataBindingContext, diagnostic, messageManager);
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                messageManager.update();
            }
        });
    }

    public Diagnostic validate(EObject obj) {
        return this._diagnostician.validate(obj);
    }

    private ValidatingService getValidatorService() {
        ServiceReference validatingServiceRef;
        BundleContext context = Activator.getDefault().getBundle().getBundleContext();
        if (this.validatingService == null && (validatingServiceRef = context.getServiceReference(ValidatingService.class.getName())) != null) {
            this.validatingService = (ValidatingService)context.getService(validatingServiceRef);
        }
        return this.validatingService;
    }
}

