/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.editor.internal.dashboard;

import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.koneki.commons.ui.ANWRTToolkit;
import org.eclipse.koneki.protocols.omadm.CommandHandler;
import org.eclipse.koneki.protocols.omadm.DMNode;
import org.eclipse.koneki.protocols.omadm.Result;
import org.eclipse.koneki.protocols.omadm.Status;
import org.eclipse.koneki.protocols.omadm.StatusCode;
import org.eclipse.koneki.simulators.omadm.basic.DMCommandHelper;
import org.eclipse.koneki.simulators.omadm.editor.OMADMSimulatorEditor;
import org.eclipse.koneki.simulators.omadm.editor.internal.Activator;
import org.eclipse.koneki.simulators.omadm.editor.internal.dashboard.DashboardPage;
import org.eclipse.koneki.simulators.omadm.model.Node;
import org.eclipse.koneki.simulators.omadm.model.NodeFormat;
import org.eclipse.koneki.simulators.omadm.model.util.NodeHelpers;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

final class ConnectCommandHandler
implements CommandHandler {
    private final DashboardPage page;
    private Status status;

    public ConnectCommandHandler(DashboardPage page) {
        this.page = page;
    }

    public Status get(final String target) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                final OMADMSimulatorEditor editor = ConnectCommandHandler.this.page.getEditor();
                CommandHandlerDialog dialog = new CommandHandlerDialog(editor.getSite().getShell(), editor.getANWRTToolkit());
                dialog.setText("Manual get");
                dialog.setImage(Activator.getDefault().getImage("icons/obj16/get_command.png"));
                dialog.setCommandText("Get " + target);
                dialog.setWithResult(true);
                dialog.setCodes(StatusCode.GET_CODES);
                Node tree = editor.getOMADMSimulation().getDevice().getTree();
                Status st = DMCommandHelper.get((Node)tree, (EditingDomain)editor.getEditingDomain(), (String)target, (boolean)false);
                if (st.getCode() == StatusCode.OK.getCode()) {
                    dialog.setDefaultFormat(NodeFormat.get((String)st.getResult().getFormat()));
                    dialog.setDefaultType(st.getResult().getType());
                    dialog.setDefaultResults(st.getResult().getData());
                } else {
                    dialog.setDefaultFormat(NodeFormat.CHR);
                    dialog.setDefaultType("text/plain");
                    dialog.setDefaultResults("");
                }
                dialog.setSelectionListener(new CommandHandlerDialog.OKSelectionListener(){

                    @Override
                    public void selected(StatusCode statusCode, String format, String type, String results) {
                        switch (statusCode) {
                            case OK: {
                                Node tree = editor.getOMADMSimulation().getDevice().getTree();
                                Node node = NodeHelpers.getNode((Node)tree, (String)target);
                                if (node != null) {
                                    DMCommandHelper.replace((Node)tree, (EditingDomain)editor.getEditingDomain(), (String)target, (String)format, (String)(format.equals(NodeFormat.NODE.getLiteral()) ? node.getType() : type), (String)(format.equals(NodeFormat.NODE.getLiteral()) ? "" : results), (boolean)true);
                                } else {
                                    DMCommandHelper.replace((Node)tree, (EditingDomain)editor.getEditingDomain(), (String)target, (String)format, (String)(format.equals(NodeFormat.NODE.getLiteral()) ? "" : type), (String)(format.equals(NodeFormat.NODE.getLiteral()) ? "" : results), (boolean)true);
                                }
                                ConnectCommandHandler.this.setStatus((Status)new Result(statusCode, new DMNode(target, format, type, results)));
                                break;
                            }
                            default: {
                                ConnectCommandHandler.this.setStatus((Status)statusCode);
                            }
                        }
                    }
                });
                dialog.open();
            }
        });
        return this.getStatus();
    }

    public Status add(final String target, final String format, final String type, final String data) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                final OMADMSimulatorEditor editor = ConnectCommandHandler.this.page.getEditor();
                CommandHandlerDialog dialog = new CommandHandlerDialog(editor.getSite().getShell(), editor.getANWRTToolkit());
                dialog.setText("Manual add");
                dialog.setImage(Activator.getDefault().getImage("icons/obj16/add_command.png"));
                dialog.setCommandText("Add " + target + " " + data);
                dialog.setWithResult(false);
                dialog.setCodes(StatusCode.ADD_CODES);
                dialog.setSelectionListener(new CommandHandlerDialog.OKSelectionListener(){

                    @Override
                    public void selected(StatusCode statusCode, String formatSelected, String typeSelected, String resultsSelected) {
                        if (statusCode == StatusCode.OK) {
                            Node tree = editor.getOMADMSimulation().getDevice().getTree();
                            DMCommandHelper.add((Node)tree, (EditingDomain)editor.getEditingDomain(), (String)target, (String)format, (String)type, (String)data, (boolean)true);
                        }
                        ConnectCommandHandler.this.setStatus((Status)statusCode);
                    }
                });
                dialog.open();
            }
        });
        return this.getStatus();
    }

    public Status copy(final String target, final String source) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                final OMADMSimulatorEditor editor = ConnectCommandHandler.this.page.getEditor();
                CommandHandlerDialog dialog = new CommandHandlerDialog(editor.getSite().getShell(), editor.getANWRTToolkit());
                dialog.setText("Manual copy");
                dialog.setImage(Activator.getDefault().getImage("icons/obj16/copy_command.png"));
                dialog.setCommandText("Copy " + target + " " + source);
                dialog.setWithResult(false);
                dialog.setCodes(StatusCode.COPY_CODES);
                dialog.setSelectionListener(new CommandHandlerDialog.OKSelectionListener(){

                    @Override
                    public void selected(StatusCode statusCode, String formatSelected, String typeSelected, String resultsSelected) {
                        if (statusCode == StatusCode.OK) {
                            Node tree = editor.getOMADMSimulation().getDevice().getTree();
                            DMCommandHelper.copy((Node)tree, (EditingDomain)editor.getEditingDomain(), (String)target, (String)source, (boolean)true);
                        }
                        ConnectCommandHandler.this.setStatus((Status)statusCode);
                    }
                });
                dialog.open();
            }
        });
        return this.getStatus();
    }

    public Status delete(final String target) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                final OMADMSimulatorEditor editor = ConnectCommandHandler.this.page.getEditor();
                CommandHandlerDialog dialog = new CommandHandlerDialog(editor.getSite().getShell(), editor.getANWRTToolkit());
                dialog.setText("Manual delete");
                dialog.setImage(Activator.getDefault().getImage("icons/obj16/delete_command.png"));
                dialog.setCommandText("Delete " + target);
                dialog.setWithResult(false);
                dialog.setCodes(StatusCode.DELETE_CODES);
                dialog.setSelectionListener(new CommandHandlerDialog.OKSelectionListener(){

                    @Override
                    public void selected(StatusCode statusCode, String format, String type, String results) {
                        if (statusCode == StatusCode.OK) {
                            Node tree = editor.getOMADMSimulation().getDevice().getTree();
                            DMCommandHelper.delete((Node)tree, (EditingDomain)editor.getEditingDomain(), (String)target, (boolean)true);
                        }
                        ConnectCommandHandler.this.setStatus((Status)statusCode);
                    }
                });
                dialog.open();
            }
        });
        return this.getStatus();
    }

    public Status exec(String target, String correlator, String format, String type, String data) {
        return StatusCode.OPTIONAL_FEATURE_NOT_SUPPORTED;
    }

    public Status replace(final String target, final String format, final String type, final String data) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                final OMADMSimulatorEditor editor = ConnectCommandHandler.this.page.getEditor();
                CommandHandlerDialog dialog = new CommandHandlerDialog(editor.getSite().getShell(), editor.getANWRTToolkit());
                dialog.setText("Manual replace");
                dialog.setImage(Activator.getDefault().getImage("icons/obj16/replace_command.png"));
                dialog.setCommandText("Replace " + target + " " + data);
                dialog.setWithResult(false);
                dialog.setCodes(StatusCode.REPLACE_CODES);
                dialog.setSelectionListener(new CommandHandlerDialog.OKSelectionListener(){

                    @Override
                    public void selected(StatusCode statusCode, String formatSelected, String typeSelected, String results) {
                        if (statusCode == StatusCode.OK) {
                            Node tree = editor.getOMADMSimulation().getDevice().getTree();
                            DMCommandHelper.replace((Node)tree, (EditingDomain)editor.getEditingDomain(), (String)target, (String)format, (String)type, (String)data, (boolean)true);
                        }
                        ConnectCommandHandler.this.setStatus((Status)statusCode);
                    }
                });
                dialog.open();
            }
        });
        return this.getStatus();
    }

    private Status getStatus() {
        return this.status;
    }

    private void setStatus(Status status) {
        this.status = status;
    }

    private static final class CommandHandlerDialog
    extends Dialog {
        private final ANWRTToolkit toolkit;
        private String commandText;
        private Image image;
        private boolean withResult;
        private StatusCode[] codes;
        private NodeFormat defaultFormat;
        private String defaultType;
        private String defaultResults;
        private OKSelectionListener selectionListener;

        public CommandHandlerDialog(Shell parent, ANWRTToolkit toolkit) {
            super(parent, 67616);
            this.toolkit = toolkit;
        }

        public String getCommandText() {
            return this.commandText;
        }

        public void setCommandText(String commandText) {
            this.commandText = commandText;
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        public boolean isWithResult() {
            return this.withResult;
        }

        public void setWithResult(boolean withResult) {
            this.withResult = withResult;
        }

        public StatusCode[] getCodes() {
            return this.codes;
        }

        public void setCodes(StatusCode[] codes) {
            this.codes = codes;
        }

        public OKSelectionListener getSelectionListener() {
            return this.selectionListener;
        }

        public void setSelectionListener(OKSelectionListener selectionListener) {
            this.selectionListener = selectionListener;
        }

        public void open() {
            Shell dialog = new Shell(this.getParent(), this.getStyle());
            dialog.setText(this.getText());
            dialog.setImage(this.getImage());
            this.createContents(dialog);
            dialog.pack();
            dialog.open();
            Display display = this.getParent().getDisplay();
            while (!dialog.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }

        private void createContents(final Shell parent) {
            SelectionAdapter okListener;
            GridLayoutFactory.fillDefaults().numColumns(2).margins(20, 10).applyTo((Composite)parent);
            Label commandLabel = this.toolkit.createLabel((Composite)parent, this.getCommandText());
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)commandLabel);
            this.toolkit.createLabel((Composite)parent, "Status code:");
            final ComboViewer statusCodeCombo = this.toolkit.createComboViewer((Composite)parent, 8);
            statusCodeCombo.setInput((Object)this.getCodes());
            statusCodeCombo.getCombo().select(0);
            GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)statusCodeCombo.getCombo());
            if (this.isWithResult()) {
                this.toolkit.createLabel((Composite)parent, "Format:");
                final ComboViewer formatCombo = this.toolkit.createComboViewer((Composite)parent, 8);
                formatCombo.setInput((Object)NodeFormat.VALUES);
                formatCombo.getCombo().select(formatCombo.getCombo().indexOf(this.defaultFormat.toString()));
                GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)formatCombo.getCombo());
                this.toolkit.createLabel((Composite)parent, "Type:");
                final Text typeText = this.toolkit.createText((Composite)parent, this.defaultType, 2048);
                GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)typeText);
                this.toolkit.createLabel((Composite)parent, "Result:");
                final Text resultsText = this.toolkit.createText((Composite)parent, this.defaultResults, 2048);
                GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)resultsText);
                statusCodeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        switch ((StatusCode)((StructuredSelection)event.getSelection()).getFirstElement()) {
                            case OK: {
                                formatCombo.getCombo().setEnabled(true);
                                typeText.setEnabled(true);
                                resultsText.setEnabled(true);
                                break;
                            }
                            default: {
                                formatCombo.getCombo().setEnabled(false);
                                typeText.setEnabled(false);
                                resultsText.setEnabled(false);
                            }
                        }
                    }
                });
                okListener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        StatusCode statusCode = (StatusCode)((StructuredSelection)statusCodeCombo.getSelection()).getFirstElement();
                        String format = ((NodeFormat)((StructuredSelection)formatCombo.getSelection()).getFirstElement()).getLiteral();
                        String type = typeText.getText();
                        String results = resultsText.getText();
                        CommandHandlerDialog.this.getSelectionListener().selected(statusCode, format, type, results);
                        parent.close();
                    }
                };
            } else {
                okListener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        StatusCode statusCode = (StatusCode)((StructuredSelection)statusCodeCombo.getSelection()).getFirstElement();
                        CommandHandlerDialog.this.getSelectionListener().selected(statusCode, null, null, null);
                        parent.close();
                    }
                };
            }
            Button okButton = this.toolkit.createButton((Composite)parent, "OK", 8);
            okButton.addSelectionListener((SelectionListener)okListener);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(0x1000000, 4).applyTo((Control)okButton);
        }

        public void setDefaultFormat(NodeFormat defaultFormat) {
            this.defaultFormat = defaultFormat;
        }

        public void setDefaultType(String defaultType) {
            this.defaultType = defaultType;
        }

        public void setDefaultResults(String defaultResults) {
            this.defaultResults = defaultResults;
        }

        public static interface OKSelectionListener {
            public void selected(StatusCode var1, String var2, String var3, String var4);
        }
    }
}

