/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CommandManagement implements Enumerator
{
    INHERITED(0, "INHERITED", "inherited"),
    AUTOMATIC(1, "AUTOMATIC", "automatic"),
    MANUAL(2, "MANUAL", "manual"),
    CONSTANT(3, "CONSTANT", "constant");

    public static final int INHERITED_VALUE = 0;
    public static final int AUTOMATIC_VALUE = 1;
    public static final int MANUAL_VALUE = 2;
    public static final int CONSTANT_VALUE = 3;
    private static final CommandManagement[] VALUES_ARRAY;
    public static final List<CommandManagement> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CommandManagement[]{INHERITED, AUTOMATIC, MANUAL, CONSTANT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CommandManagement get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CommandManagement result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CommandManagement getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CommandManagement result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CommandManagement get(int value) {
        switch (value) {
            case 0: {
                return INHERITED;
            }
            case 1: {
                return AUTOMATIC;
            }
            case 2: {
                return MANUAL;
            }
            case 3: {
                return CONSTANT;
            }
        }
        return null;
    }

    private CommandManagement(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

