/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.model.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.koneki.simulators.omadm.model.Device;
import org.eclipse.koneki.simulators.omadm.model.Node;

public class DeviceHelpers {
    public static final String[] getDeviceIdTypeAndValue(String deviceId) {
        String deviceIdType = null;
        String deviceIdValue = "";
        if (deviceId != null) {
            if (deviceId.contains(":")) {
                String[] stringArray = deviceId.split(":");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (deviceIdType == null) {
                        deviceIdType = s;
                    } else {
                        deviceIdValue = String.valueOf(deviceIdValue) + s;
                    }
                    ++n2;
                }
            } else {
                deviceIdValue = deviceId;
            }
        }
        String[] ret = new String[]{deviceIdType, deviceIdValue};
        return ret;
    }

    public static final boolean isValidServerURL(Device device) {
        if (device != null) {
            String serverURL = device.getServerUrl();
            if (serverURL != null) {
                try {
                    new URL(serverURL);
                    return true;
                }
                catch (MalformedURLException malformedURLException) {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public static final boolean isValidDeviceId(Device device) {
        if (device != null) {
            String deviceId = device.getDeviceId();
            if (deviceId != null) {
                switch (device.getDeviceIdType()) {
                    case IMEI: {
                        return deviceId.matches("^[0-9]{15}$") || deviceId.matches("^IMEI:[0-9]{15}$");
                    }
                    case MAC_ADDRESS: {
                        return deviceId.matches("^[a-fA-F0-9]{12}$") || deviceId.matches("^MAC_ADDRESS:[a-fA-F0-9]{12}$");
                    }
                }
                return deviceId.matches("^\\S+(\\s+\\S+)*$");
            }
            return false;
        }
        return false;
    }

    public static final boolean isValidRootNodeType(Device device) {
        if (device != null) {
            Node root = device.getTree();
            return root != null && root.isRoot();
        }
        return false;
    }
}

