/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.emfforms.builder;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.pde.emfforms.builder.MarkerHelper;
import org.eclipse.pde.emfforms.builder.ModelFileDeltaVisitor;
import org.eclipse.pde.emfforms.internal.Activator;

public abstract class IncrementalModelBuilder
extends IncrementalProjectBuilder {
    private String _contentType;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        switch (kind) {
            case 6: {
                this.fullBuild(monitor);
                break;
            }
            case 15: {
                this.clean(monitor);
                break;
            }
            default: {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.fullBuild(monitor);
                    break;
                }
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ModelFileDeltaVisitor visitor = new ModelFileDeltaVisitor(this.getContentType());
        delta.accept((IResourceDeltaVisitor)visitor);
        Map<Resource, IResource> modifiedResources = visitor.getModifiedResources();
        monitor.beginTask("Incremental Build", modifiedResources.size());
        for (Resource modelResource : modifiedResources.keySet()) {
            this.build((EObject)modelResource.getContents().get(0), modifiedResources.get(modelResource), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        monitor.done();
    }

    protected String getContentType() {
        return this._contentType;
    }

    protected abstract void fullBuild(IProgressMonitor var1) throws CoreException;

    protected void build(EObject modelObject, IResource resource, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Model Validation", 4);
        monitor.subTask("Validation");
        Diagnostic diagnostic = this.validate(modelObject);
        monitor.worked(3);
        if (resource instanceof IContainer) {
            MarkerHelper.cleanMarkers((IContainer)resource);
        } else if (resource instanceof IFile) {
            MarkerHelper.cleanMarkers((IFile)resource);
        }
        MarkerHelper.createMarkers(diagnostic, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.done();
    }

    protected Diagnostic validate(final EObject modelObject) {
        TransactionalEditingDomain domain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        final AdapterFactory adapterFactory = domain instanceof AdapterFactoryEditingDomain ? ((AdapterFactoryEditingDomain)domain).getAdapterFactory() : null;
        try {
            return (Diagnostic)domain.runExclusive((Runnable)new RunnableWithResult.Impl<Diagnostic>(){

                public void run() {
                    Diagnostic diagnostic = new Diagnostician(){

                        public String getObjectLabel(EObject eObject) {
                            IItemLabelProvider itemLabelProvider;
                            if (adapterFactory != null && !eObject.eIsProxy() && (itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class)) != null) {
                                return itemLabelProvider.getText((Object)eObject);
                            }
                            return super.getObjectLabel(eObject);
                        }
                    }.validate(modelObject);
                    this.setResult(diagnostic);
                }
            });
        }
        catch (InterruptedException ie) {
            Activator.log(ie);
            return new BasicDiagnostic(4, "ModelChecker", 0, ie.getMessage(), new Object[]{modelObject});
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data != null && data instanceof Hashtable) {
            Hashtable map = (Hashtable)data;
            this._contentType = (String)map.get("content-type");
        }
    }
}

