/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.emfforms.editor;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.emfforms.editor.EmfActionBarContributor;
import org.eclipse.pde.emfforms.editor.EmfFormEditor;
import org.eclipse.pde.emfforms.editor.EmfMasterDetailBlock;
import org.eclipse.pde.emfforms.editor.IEmfFormPage;
import org.eclipse.pde.emfforms.editor.PDEFormToolkit;
import org.eclipse.pde.emfforms.internal.validation.RichTooltipHyperlinkAdapter;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.internal.forms.widgets.FormHeading;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEmfFormPage
extends FormPage
implements IEmfFormPage {
    private int numColumns = 1;
    private boolean isMasterDetail = false;

    public AbstractEmfFormPage(EmfFormEditor<?> editor) {
        super(editor, "", "");
        this.setPartName(this.getPartName());
    }

    public AbstractEmfFormPage(EmfFormEditor<?> editor, int numColumns) {
        this(editor, numColumns, "");
        this.setPartName(this.getPartName());
    }

    public AbstractEmfFormPage(EmfFormEditor<?> editor, int numColumns, String pageName) {
        this(editor);
        this.numColumns = numColumns;
        this.setPartName(pageName);
    }

    public AbstractEmfFormPage(EmfFormEditor<?> editor, int numColumns, boolean isMasterDetail) {
        this(editor, numColumns, isMasterDetail, "");
        this.setPartName(this.getPartName());
    }

    public AbstractEmfFormPage(EmfFormEditor<?> editor, int numColumns, boolean isMasterDetail, String pageName) {
        this(editor);
        this.numColumns = numColumns;
        this.isMasterDetail = isMasterDetail;
        this.setPartName(pageName);
    }

    protected void createFormContent(IManagedForm managedForm) {
        TreeViewer treeViewer;
        super.createFormContent(managedForm);
        Composite body = managedForm.getForm().getBody();
        GridLayout gl = new GridLayout(this.getNumColumns(), true);
        gl.verticalSpacing = 20;
        this.createHeader();
        Composite actualContent = null;
        if (!this.isMasterDetail()) {
            actualContent = this.getEditor().getToolkit().createComposite(body, 0);
            GridDataFactory.swtDefaults().span(this.getNumColumns(), 1).align(4, 4).grab(true, true).applyTo((Control)actualContent);
            actualContent.setLayout((Layout)gl);
        }
        this.createContents(actualContent);
        body.setLayout((Layout)gl);
        this.getFormToolkit().adapt(actualContent);
        DataBindingContext bindingContext = this.getEditor().getDataBindingContext();
        this.bind(bindingContext);
        this.getEditor().validate();
        if (this.getViewer() != null && this.getViewer() instanceof TreeViewer && (treeViewer = (TreeViewer)this.getViewer()).getTree().getItemCount() > 0) {
            treeViewer.getTree().setSelection(treeViewer.getTree().getItem(0));
            treeViewer.getTree().setFocus();
        }
        if (this.getEditor().getEditorConfig().isUseRichFormsTooltips()) {
            managedForm.getForm().getForm().addMessageHyperlinkListener((IHyperlinkListener)new RichTooltipHyperlinkAdapter(managedForm));
            ((FormHeading)managedForm.getForm().getForm().getHead()).setMessageToolTipManager(null);
        }
    }

    protected EmfMasterDetailBlock getMainMasterDetailBlock() {
        return null;
    }

    private void createHeader() {
        Form f = this.getManagedForm().getForm().getForm();
        f.setText(this.getPartName());
        this.getEditor().getToolkit().decorateFormHeading(f);
    }

    protected PDEFormToolkit getFormToolkit() {
        return (PDEFormToolkit)this.getEditor().getToolkit();
    }

    public EmfFormEditor<?> getEditor() {
        return (EmfFormEditor)super.getEditor();
    }

    public abstract String getId();

    @Override
    public int getNumColumns() {
        return this.numColumns;
    }

    public boolean isMasterDetail() {
        return this.isMasterDetail || this.getMainMasterDetailBlock() != null;
    }

    @Override
    public Viewer getViewer() {
        if (this.getMainMasterDetailBlock() != null) {
            return this.getMainMasterDetailBlock().getTreeViewer();
        }
        return null;
    }

    public void setActive(boolean active) {
        if (active) {
            this.getEditor().validate();
            if (this.getViewer() != null) {
                IEditorActionBarContributor actionBarContributor = this.getEditor().getEditorSite().getActionBarContributor();
                if (actionBarContributor != null && actionBarContributor instanceof EmfActionBarContributor && this.getMainMasterDetailBlock() != null) {
                    ((EmfActionBarContributor)actionBarContributor).setCreateChildMenuFilter(this.getMainMasterDetailBlock().getCreateChildContextMenuFilter());
                    ((EmfActionBarContributor)actionBarContributor).setCreateSiblingMenuFilter(this.getMainMasterDetailBlock().getCreateSiblingContextMenuFilter());
                }
                IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
                this.getViewer().setSelection((ISelection)selection);
                this.getViewer().refresh();
            }
        }
    }

    @Override
    public abstract void bind(DataBindingContext var1);

    @Override
    public abstract void createContents(Composite var1);
}

