/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.emfforms.editor.actions;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.emfforms.editor.EmfActionBarContributor;
import org.eclipse.pde.emfforms.editor.EmfMasterDetailBlock;
import org.eclipse.pde.emfforms.internal.Activator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateElementDropDownAction
extends Action
implements IMenuCreator {
    private EmfMasterDetailBlock masterDetailBlock;
    private Menu fMenu;
    private Collection<IAction> createChildActions;
    protected Collection<IAction> createSiblingActions;

    public CreateElementDropDownAction(EmfMasterDetailBlock masterDetailBlck) {
        this.masterDetailBlock = masterDetailBlck;
        this.fMenu = null;
        this.setToolTipText("Create a new child/sibling element");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/obj16/add.png")));
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        this.updateActions();
        Action titleCreateChildAction = new Action(this.createChildActions.isEmpty() ? "(no new child)" : "-- New Child --"){};
        titleCreateChildAction.setEnabled(false);
        new ActionContributionItem((IAction)titleCreateChildAction).fill(this.fMenu, -1);
        for (IAction createChildAction : this.createChildActions) {
            this.addActionToMenu(this.fMenu, createChildAction);
        }
        new MenuItem(this.fMenu, 2);
        Action titleCreateSiblingAction = new Action(this.createSiblingActions.isEmpty() ? "(no new sibling)" : "-- New Sibling --"){};
        titleCreateSiblingAction.setEnabled(false);
        new ActionContributionItem((IAction)titleCreateSiblingAction).fill(this.fMenu, -1);
        for (IAction createSiblingAction : this.createSiblingActions) {
            this.addActionToMenu(this.fMenu, createSiblingAction);
        }
        return this.fMenu;
    }

    private void addActionToMenu(Menu parent, IAction action) {
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(parent, -1);
    }

    private void updateActions() {
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        ISelection selection = this.getCurrentSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = this.masterDetailBlock.getEditor().getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
            newSiblingDescriptors = domain.getNewChildDescriptors(null, object);
            this.createChildActions = ((EmfActionBarContributor)this.masterDetailBlock.getEditor().getActionBarContributor()).generateCreateChildActions(newChildDescriptors, selection);
            this.createSiblingActions = ((EmfActionBarContributor)this.masterDetailBlock.getEditor().getActionBarContributor()).generateCreateSiblingActions(newSiblingDescriptors, selection);
        }
    }

    protected ISelection getCurrentSelection() {
        Object selection = this.masterDetailBlock.getTreeViewer().getSelection();
        if (selection.isEmpty()) {
            selection = this.masterDetailBlock.getTreeViewer().getInput() != null ? new StructuredSelection(this.masterDetailBlock.getTreeViewer().getInput()) : this.getRootElement();
        }
        return selection;
    }

    protected IStructuredSelection getRootElement() {
        return new StructuredSelection(this.masterDetailBlock.getEditor().getCurrentEObject());
    }

    public void runWithEvent(Event event) {
        ToolItem toolItem = (ToolItem)event.widget;
        this.getMenu((Control)toolItem.getParent());
        Collection<IAction> allEnabledActions = this.getAllEnabledActions();
        if (allEnabledActions.isEmpty()) {
            return;
        }
        if (allEnabledActions.size() == 1) {
            allEnabledActions.iterator().next().run();
            return;
        }
        Point point = toolItem.getParent().toDisplay(new Point(event.x, event.y));
        this.fMenu.setLocation(point.x, point.y + 20);
        this.fMenu.setVisible(true);
    }

    private Collection<IAction> getAllEnabledActions() {
        ArrayList<IAction> allEnabledActions = new ArrayList<IAction>();
        for (IAction createChildAction : this.createChildActions) {
            if (!createChildAction.isEnabled()) continue;
            allEnabledActions.add(createChildAction);
        }
        for (IAction createSiblingAction : this.createSiblingActions) {
            if (!createSiblingAction.isEnabled()) continue;
            allEnabledActions.add(createSiblingAction);
        }
        return allEnabledActions;
    }
}

