/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.emfforms.internal.editor;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.emfforms.editor.EmfFormEditor;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmfContentOutlinePage
extends ContentOutlinePage {
    private EmfFormEditor<? extends EObject> editor;
    protected TreeViewer contentOutlineViewer;
    protected IStatusLineManager contentOutlineStatusLineManager;
    private Object viewerInput;
    private ViewerComparator viewerComparator;

    public EmfContentOutlinePage(EmfFormEditor<? extends EObject> editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.contentOutlineViewer = this.getTreeViewer();
        this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.editor.getAdapterFactory()));
        this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.editor.getAdapterFactory()), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.contentOutlineViewer.setInput(this.viewerInput);
        this.contentOutlineViewer.setComparator(this.viewerComparator);
        this.contentOutlineViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(AdapterFactoryEditingDomain.unwrap((Object)element) instanceof String);
            }
        });
        this.createContextMenuFor((StructuredViewer)this.contentOutlineViewer);
        if (!this.editor.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(this.editor.getEditingDomain().getResourceSet().getResources().get(0)), true);
        }
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
        this.contentOutlineStatusLineManager = statusLineManager;
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        if (this.editor.getActionBarContributor() != null) {
            this.editor.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
        }
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.editor.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter(this.editor.getEditingDomain(), (Viewer)viewer));
    }

    public void setViewerInput(Object viewerInput) {
        this.viewerInput = viewerInput;
    }

    public void setViewerComparator(ViewerComparator comparator) {
        this.viewerComparator = comparator;
    }

    public TreeViewer getViewer() {
        return this.contentOutlineViewer;
    }
}

