/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.emfforms.internal.editor;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.pde.emfforms.editor.EmfFormEditor;
import org.eclipse.pde.emfforms.internal.Activator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDeltaVisitor<O extends EObject>
implements IResourceDeltaVisitor {
    private final EmfFormEditor<O> _emfFormEditor;

    public ResourceDeltaVisitor(EmfFormEditor<O> emfFormEditor) {
        this._emfFormEditor = emfFormEditor;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta.getResource().getType() == 1) {
            if (delta.getKind() == 2) {
                String fullPath = delta.getFullPath().toString();
                URI changedURI = URI.createPlatformResourceURI((String)fullPath, (boolean)false);
                Resource currentResource = this._emfFormEditor.getCurrentEObject().eResource();
                if (currentResource.getURI().equals((Object)changedURI)) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            ResourceDeltaVisitor.this._emfFormEditor.getSite().getPage().closeEditor((IEditorPart)ResourceDeltaVisitor.this._emfFormEditor, false);
                        }
                    });
                }
            } else if (delta.getKind() == 4) {
                if ((delta.getFlags() & 0x20000) == 131072) {
                    return false;
                }
                String fullPath = delta.getFullPath().toString();
                final URI changedURI = URI.createPlatformResourceURI((String)fullPath, (boolean)false);
                SWTObservables.getRealm((Display)Display.getDefault()).asyncExec(new Runnable(){

                    public void run() {
                        Resource currentResource = ResourceDeltaVisitor.this._emfFormEditor.getCurrentEObject().eResource();
                        boolean isMainResource = currentResource.getURI().equals((Object)changedURI);
                        Resource changedResource = currentResource.getResourceSet().getResource(changedURI, false);
                        if (changedResource != null && changedResource.isLoaded() && !ResourceDeltaVisitor.this._emfFormEditor.isSaving()) {
                            if (isMainResource && ResourceDeltaVisitor.this._emfFormEditor.isDirty()) {
                                ResourceDeltaVisitor.this._emfFormEditor.getEditingDomain().getCommandStack().flush();
                            }
                            try {
                                changedResource.unload();
                                changedResource.load(Collections.EMPTY_MAP);
                                if (isMainResource) {
                                    ResourceDeltaVisitor.this._emfFormEditor.setMainResource(changedResource);
                                }
                            }
                            catch (IOException ioe) {
                                Activator.log(ioe);
                            }
                        }
                    }
                });
            }
        }
        return true;
    }
}

