/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.commons.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class ColorRegistry {
    public static final Color COLOR_ERROR = ColorRegistry.getInstance().get("255,128,128");
    public static final Color COLOR_WARNING = ColorRegistry.getInstance().get("249,240,163");
    public static final Color COLOR_INFO = ColorRegistry.getInstance().get("128,128,255");
    public static final Color COLOR_BLACK = ColorRegistry.getInstance().get("0,0,0");
    public static final Color COLOR_WHITE = ColorRegistry.getInstance().get("255,255,255");
    public static final Color COLOR_RED = ColorRegistry.getInstance().get("255,0,0");
    public static final Color COLOR_GREEN = ColorRegistry.getInstance().get("0,255,0");
    public static final Color COLOR_BLUE = ColorRegistry.getInstance().get("0,0,255");
    public static final Color COLOR_GREY = ColorRegistry.getInstance().get("219,211,203");
    public static final Color COLOR_LIGHT_GREY = ColorRegistry.getInstance().get("240,240,240");
    public static final Color INFO_TIP_BORDER = ColorRegistry.getInstance().get("255,255,255");
    public static final Color INFO_TIP_BACKGROUND = ColorRegistry.getInstance().get("245,245,245");
    public static final Color INFO_TIP_TEXT = ColorRegistry.getInstance().get("38,50,72");
    public static final Color INFO_DECORATOR_BORDER = ColorRegistry.getInstance().get("110,130,210");
    public static final Color VALID_DECORATOR_BORDER = ColorRegistry.getInstance().get("125,210,130");
    public static final Color WARNING_DECORATOR_BORDER = ColorRegistry.getInstance().get("235,225,95");
    public static final Color ERROR_DECORATOR_BORDER = ColorRegistry.getInstance().get("210,130,145");
    private static ColorRegistry instance;
    private Display _display;
    private final Map<String, Color> _stringToColor = new HashMap<String, Color>(7);
    private Runnable _displayRunnable = new Runnable(){

        @Override
        public void run() {
            ColorRegistry.this.clearCaches();
        }
    };

    private ColorRegistry() {
        this(Display.getCurrent());
    }

    private ColorRegistry(Display display) {
        Assert.isNotNull((Object)display);
        this._display = display;
        this.hookDisplayDispose();
    }

    public static ColorRegistry getInstance() {
        if (instance == null) {
            instance = new ColorRegistry();
        }
        return instance;
    }

    private void hookDisplayDispose() {
        this._display.disposeExec(this._displayRunnable);
    }

    private void clearCaches() {
        for (Color color : this._stringToColor.values()) {
            color.dispose();
        }
        this._stringToColor.clear();
    }

    public Color get(String symbolicName) {
        Assert.isNotNull((Object)symbolicName);
        if ("".equals(symbolicName)) {
            return new Color((Device)this._display, new RGB(0, 0, 0));
        }
        return this.get(StringConverter.asRGB((String)symbolicName));
    }

    public Color get(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        String symbolicName = StringConverter.asString((RGB)rgb);
        Color result = this._stringToColor.get(symbolicName);
        if (result != null) {
            return result;
        }
        Color color = new Color((Device)this._display, rgb);
        this._stringToColor.put(symbolicName, color);
        return color;
    }
}

