/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.commons.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.koneki.commons.ui.Activator;
import org.eclipse.koneki.commons.ui.FontsRegistry;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class CButton
extends Canvas
implements PaintListener {
    private String text;
    private List<SelectionListener> listeners;
    private Image image;
    private int statesWidth;
    private int height;
    private boolean isDown;
    private boolean isMouseIn;
    private boolean flashing;
    private Job flashingJob;

    public CButton(Composite parent, String text, Image image) {
        super(parent, 0);
        Assert.isNotNull((Object)image);
        this.text = text;
        this.image = image;
        this.statesWidth = image.getImageData().width / 3;
        this.height = image.getImageData().height;
        this.listeners = new ArrayList<SelectionListener>();
        this.addPaintListener(this);
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                CButton.this.setMouseIn(false);
            }

            public void mouseEnter(MouseEvent e) {
                CButton.this.setMouseIn(true);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 0 || e.button == 1) {
                    CButton.this.setDown(true);
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 0 || e.button == 1) {
                    CButton.this.setDown(false);
                    Event event = new Event();
                    event.widget = e.widget;
                    for (SelectionListener l : CButton.this.listeners) {
                        l.widgetSelected(new SelectionEvent(event));
                    }
                }
            }
        });
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.redraw();
    }

    public boolean isHoverState() {
        return this.isMouseIn;
    }

    public void setMouseIn(boolean state) {
        this.isMouseIn = state;
        this.redraw();
    }

    public boolean isPushedState() {
        return this.isDown;
    }

    public void setDown(boolean state) {
        this.isDown = state;
        this.redraw();
    }

    public void paintControl(PaintEvent e) {
        Rectangle titleRect = this.getClientArea();
        GC gc = e.gc;
        int srcX = 0;
        if (!this.isEnabled() || this.isPushedState()) {
            srcX = this.statesWidth * 2;
        } else if (this.isHoverState()) {
            srcX = this.statesWidth;
        }
        gc.drawImage(this.image, srcX, 0, this.statesWidth, this.height, 0, 0, this.statesWidth, this.height);
        gc.setForeground(e.display.getSystemColor(1));
        Font font2 = FontsRegistry.getInstance().get(9, 0);
        gc.setFont(font2);
        Point extent = gc.textExtent(this.text, 9);
        int textX = titleRect.x + (titleRect.width - extent.x) / 2;
        int textY = titleRect.y + (titleRect.height - extent.y) / 2;
        gc.drawText(this.text, textX, textY, 11);
        gc.drawText(this.text, textX, textY, 11);
    }

    public Point computeSize(int wHint, int hHint) {
        return new Point(this.statesWidth, this.height);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return this.computeSize(wHint, hHint);
    }

    public void addSelectionListener(SelectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.redraw();
    }

    public void setFlashing(boolean flashing) {
        this.flashing = flashing;
        if (flashing) {
            this.setEnabled(true);
            this.startFlashingJob();
        } else if (this.flashingJob != null) {
            this.flashingJob.cancel();
        }
    }

    public boolean isFlashing() {
        return this.flashing;
    }

    private void startFlashingJob() {
        this.flashingJob = new Job("button flashing"){
            private int state;
            {
                this.state = 0;
            }

            protected IStatus run(IProgressMonitor monitor) {
                while (CButton.this.flashing && !CButton.this.isDisposed() && !monitor.isCanceled()) {
                    try {
                        Thread.sleep(500L);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                state = state == 0 ? 1 : 0;
                                if (!CButton.this.isDisposed()) {
                                    CButton.this.setMouseIn(state == 1);
                                }
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        Activator.log(e);
                    }
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CButton.this.setMouseIn(false);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.flashingJob.schedule();
    }

    public void push() throws InterruptedException {
        Job pushingJob = new Job("button pushed"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CButton.this.setDown(true);
                        }
                    });
                    Thread.sleep(200L);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CButton.this.setDown(false);
                        }
                    });
                }
                catch (InterruptedException e) {
                    Activator.log(e);
                }
                return Status.OK_STATUS;
            }
        };
        pushingJob.schedule();
    }
}

