/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.commons.ui.widgets;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.koneki.commons.ui.widgets.TextVerifier;

public class PatternTextVerifier
extends TextVerifier {
    public static final String NUMERICS_PATTERN = "[\\d]*";
    public static final String UPPER_OCCURENCE_PATTERN = "[\\*]|[1-9][\\d]*";
    public static final String ABS_NUMERICS_PATTERN = "^[-\\d][\\d]*";
    public static final String DECIMAL_NUMERIC_PATTERN = "^[-\\d][\\d]*[\\.]?[\\d]*";
    public static final String POSITIVE_DECIMAL_NUMERIC_PATTERN = "^[\\d]*[\\.]?[\\d]*";
    public static final String POSITIVE_NUMERIC_PATTERN = "^[\\d]*";
    public static final String EXP_NUMERIC_PATTERN = "^[-\\d][\\d]*\\.?[\\d]*(E?-?[\\d]*)";
    public static final String PHONE_NUMBERS_PATTERN = "^[+\\d][\\d]*";
    public static final String WORD_PATTERN_PLUS = "[\\w-]*";
    public static final String WORD_PATTERN = "[\\w]*";
    public static final String WORD_LIST_PATTERN = "^[\\w][\\w,]*";
    public static final String WORD_DOTTED_LIST_PATTERN = "^[\\w][\\w.]*";
    public static final String HOST_PATTERN = "([\\w]*[\\d]*[\\.]*[-]*)*";
    public static final String URL_PATTERN = "^[\\w][\\w\\.\\-:/]*";
    public static final String USERNAME_PATTERN = "[\\w][\\w@.]*";
    public static final String JAVA_COMPLIANT_PATTERN = "^[a-zA-Z][\\w ]*";
    public static final String JAVA_COMPLIANT_PATTERN_PLUS_SPACE_AND_ACCENT = "^[a-zA-Z][a-zA-Z\\s\\d_\u00e9\u00e8\u00e0\u00f9\u00ea\u00e2\u00fb\u00ee\u00f4]*";
    public static final String JAVA_COMPLIANT_LIST_PATTERN = "^[a-zA-Z][\\w]*(,([a-zA-Z][\\w]*)?)*";
    public static final String MAIL_PATTERN = "[\\w\\.-]*@[a-zA-Z0-9][\\w\\.-]*[a-zA-Z0-9]\\.[a-zA-Z][a-zA-Z\\.]*[a-zA-Z]$";
    public static final String SIMPLE_MAIL_PATTERN = "[\\w][\\w@.-]*";
    public static final String PAGE_NAME_PATTERN = "^[\\w][\\w\\.\\-]*";
    public static final String IP_ADDRESS_PATTERN = "\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}";
    public static final String IP_ADDRESS_BASIC_PATTERN = "[\\d.]*";
    public static final String WORD_DEFAULT_OR_DECIMAL = "d|D|de|DE|def|DEF|defa|DEFA|defau|DEFAU|defaul|DEFAUL|default|DEFAULT|^[-\\d][\\d]*[\\.]?[\\d]*";
    public static final String HEXADECIMAL_PATTERN = "[a-fA-F0-9]?[a-fA-F0-9]";
    public static final String HEXADECIMALS_PATTERN = "[0-9a-f]+";
    public static final String DECIMAL_NOT_STARTING_WITH_ZERO_PATTERN = "[1-9][\\d]*";
    private Map<String, Pattern> _patterns = new HashMap<String, Pattern>();

    public PatternTextVerifier() {
    }

    public PatternTextVerifier(String pattern) {
        this(new String[]{pattern});
    }

    public PatternTextVerifier(String[] patterns) {
        this();
        this.addPatterns(patterns);
    }

    public PatternTextVerifier(Pattern pattern) {
        this(new Pattern[]{pattern});
    }

    public PatternTextVerifier(Pattern[] patterns) {
        this();
        this.addPatterns(patterns);
    }

    public void addPattern(String pattern) {
        if (pattern == null) {
            return;
        }
        if (this._patterns.get(pattern) == null) {
            this._patterns.put(pattern, Pattern.compile(pattern));
        }
    }

    public void addPatterns(String[] patterns) {
        if (patterns == null) {
            return;
        }
        int i = 0;
        while (i < patterns.length) {
            this.addPattern(patterns[i]);
            ++i;
        }
    }

    public void addPattern(Pattern pattern) {
        if (pattern == null) {
            return;
        }
        if (this._patterns.get(pattern.pattern()) == null) {
            this._patterns.put(pattern.pattern(), pattern);
        }
    }

    public void addPatterns(Pattern[] patterns) {
        if (patterns == null) {
            return;
        }
        int i = 0;
        while (i < patterns.length) {
            this.addPattern(patterns[i]);
            ++i;
        }
    }

    public void removePattern(String pattern) {
        if (pattern == null) {
            return;
        }
        this._patterns.remove(pattern);
    }

    public void removePatterns(String[] patterns) {
        if (patterns == null) {
            return;
        }
        int i = 0;
        while (i < patterns.length) {
            this.removePattern(patterns[i]);
            ++i;
        }
    }

    public void removePattern(Pattern pattern) {
        if (pattern == null) {
            return;
        }
        this._patterns.remove(pattern.pattern());
    }

    public void removePatterns(Pattern[] patterns) {
        if (patterns == null) {
            return;
        }
        int i = 0;
        while (i < patterns.length) {
            this.removePattern(patterns[i]);
            ++i;
        }
    }

    @Override
    public boolean verify(String value) {
        boolean result = true;
        for (Pattern pattern : this._patterns.values()) {
            boolean bl = result = result && pattern.matcher(value).matches();
        }
        return result;
    }

    protected Collection<Pattern> getPatterns() {
        return this._patterns.values();
    }

    public static PatternTextVerifier numericsVerifier() {
        return new PatternTextVerifier(NUMERICS_PATTERN);
    }

    public static PatternTextVerifier phoneNumbersVerifier() {
        return new PatternTextVerifier(PHONE_NUMBERS_PATTERN);
    }

    public static PatternTextVerifier stringLenghtVerifier() {
        return new PatternTextVerifier(DECIMAL_NOT_STARTING_WITH_ZERO_PATTERN);
    }

    public static PatternTextVerifier wordVerifier() {
        return new PatternTextVerifier(WORD_PATTERN);
    }

    public static PatternTextVerifier wordPlusVerifier() {
        return new PatternTextVerifier(WORD_PATTERN_PLUS);
    }

    public static PatternTextVerifier wordListVerifier() {
        return new PatternTextVerifier(WORD_LIST_PATTERN);
    }

    public static PatternTextVerifier absNumericsVerifier() {
        return new PatternTextVerifier(ABS_NUMERICS_PATTERN);
    }

    public static PatternTextVerifier decimalNumericVerifier() {
        return new PatternTextVerifier(DECIMAL_NUMERIC_PATTERN);
    }

    public static PatternTextVerifier positiveDecimalNumericVerifier() {
        return new PatternTextVerifier(POSITIVE_DECIMAL_NUMERIC_PATTERN);
    }

    public static PatternTextVerifier positiveNumericVerifier() {
        return new PatternTextVerifier(POSITIVE_NUMERIC_PATTERN);
    }

    public static PatternTextVerifier expNumericVerifier() {
        return new PatternTextVerifier(EXP_NUMERIC_PATTERN);
    }

    public static PatternTextVerifier hostVerifier() {
        return new PatternTextVerifier(HOST_PATTERN);
    }

    public static PatternTextVerifier urlVerifier() {
        return new PatternTextVerifier(URL_PATTERN);
    }

    public static PatternTextVerifier usernameVerifier() {
        return new PatternTextVerifier(USERNAME_PATTERN);
    }

    public static PatternTextVerifier javaCompliantVerifier() {
        return new PatternTextVerifier(JAVA_COMPLIANT_PATTERN);
    }

    public static PatternTextVerifier javaCompliantVerifierPlusSpaceAndAccent() {
        return new PatternTextVerifier(JAVA_COMPLIANT_PATTERN_PLUS_SPACE_AND_ACCENT);
    }

    public static PatternTextVerifier javaCompliantListVerifier() {
        return new PatternTextVerifier(JAVA_COMPLIANT_LIST_PATTERN);
    }

    public static PatternTextVerifier mailVerifier() {
        return new PatternTextVerifier(MAIL_PATTERN);
    }

    public static PatternTextVerifier simpleMailVerifier() {
        return new PatternTextVerifier(SIMPLE_MAIL_PATTERN);
    }

    public static PatternTextVerifier pageNameVerifier() {
        return new PatternTextVerifier(PAGE_NAME_PATTERN);
    }

    public static PatternTextVerifier ipAddressVerifier() {
        return new PatternTextVerifier(IP_ADDRESS_PATTERN);
    }

    public static PatternTextVerifier ipAddressBasicVerifier() {
        return new PatternTextVerifier(IP_ADDRESS_BASIC_PATTERN);
    }

    public static PatternTextVerifier defaultOrDecimalVerifier() {
        return new PatternTextVerifier(WORD_DEFAULT_OR_DECIMAL);
    }

    public static PatternTextVerifier hexadecimalVerifier() {
        return new PatternTextVerifier(HEXADECIMAL_PATTERN);
    }

    public static PatternTextVerifier upperOccurenceVerifier() {
        return new PatternTextVerifier(UPPER_OCCURENCE_PATTERN);
    }
}

