/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.commons.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.koneki.commons.ui.wizards.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class NewProjectWizard
extends BasicNewResourceWizard
implements IExecutableExtension {
    private IConfigurationElement configElement;

    protected abstract IProjectDescription createProjectDescription();

    protected IProject createNewProject(IProjectDescription projectDescription, IWorkspace workspace, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(Messages.NewProjectWizard_subtasklabel, 2);
            IProject project = workspace.getRoot().getProject(projectDescription.getName());
            project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IProject iProject = project;
            return iProject;
        }
        finally {
            monitor.done();
        }
    }

    protected void configureProject(IProject newProject, IProgressMonitor monitor) throws CoreException {
    }

    protected IWorkingSet[] getSelectedWorkingSets() {
        return null;
    }

    public boolean performFinish() {
        IProject newProject = this.createNewProjectInWizardContext();
        if (newProject == null) {
            return false;
        }
        IWorkingSet[] workingSets = this.getSelectedWorkingSets();
        if (workingSets != null && workingSets.length > 0) {
            this.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)newProject, workingSets);
        }
        this.updatePerspective();
        this.selectAndReveal((IResource)newProject);
        return true;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    protected void updatePerspective() {
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
    }

    protected IProject createNewProjectInWizardContext() {
        final IProjectDescription description = this.createProjectDescription();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                final IWorkspace workspace = ResourcesPlugin.getWorkspace();
                try {
                    workspace.run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            try {
                                monitor.beginTask(Messages.NewProjectWizard_maintasklabel, 2);
                                if (monitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                                IProject newProject = NewProjectWizard.this.createNewProject(description, workspace, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                if (monitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                                NewProjectWizard.this.configureProject(newProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    }, (ISchedulingRule)workspace.getRoot(), 1, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException t) {
            if (t.getTargetException() instanceof CoreException) {
                CoreException cause = (CoreException)t.getTargetException();
                StatusAdapter status = cause.getStatus().getCode() == 275 ? new StatusAdapter((IStatus)new Status(2, "org.eclipse.koneki.commons.ui", NLS.bind((String)Messages.NewProjectWizard_caseVariantExistsError, (Object)description.getName()), (Throwable)cause)) : new StatusAdapter((IStatus)new Status(cause.getStatus().getSeverity(), "org.eclipse.koneki.commons.ui", Messages.NewProjectWizard_errorMessage, (Throwable)cause));
                status.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.NewProjectWizard_errorMessage);
                StatusManager.getManager().handle(status, 4);
            }
            StatusAdapter status = new StatusAdapter((IStatus)new Status(2, "org.eclipse.koneki.commons.ui", 0, NLS.bind((String)Messages.NewProjectWizard_internalError, (Object)t.getMessage()), (Throwable)t));
            status.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.NewProjectWizard_errorMessage);
            StatusManager.getManager().handle(status, 5);
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
        if (project.exists()) {
            return project;
        }
        return null;
    }
}

