/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DeviceIdType implements Enumerator
{
    FREE(0, "FREE", "free"),
    IMEI(1, "IMEI", "IMEI"),
    MAC_ADDRESS(2, "MAC_ADDRESS", "MAC Address");

    public static final int FREE_VALUE = 0;
    public static final int IMEI_VALUE = 1;
    public static final int MAC_ADDRESS_VALUE = 2;
    private static final DeviceIdType[] VALUES_ARRAY;
    public static final List<DeviceIdType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DeviceIdType[]{FREE, IMEI, MAC_ADDRESS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DeviceIdType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DeviceIdType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DeviceIdType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DeviceIdType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DeviceIdType get(int value) {
        switch (value) {
            case 0: {
                return FREE;
            }
            case 1: {
                return IMEI;
            }
            case 2: {
                return MAC_ADDRESS;
            }
        }
        return null;
    }

    private DeviceIdType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

