/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.model.impl;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.koneki.simulators.omadm.model.Device;
import org.eclipse.koneki.simulators.omadm.model.DeviceIdType;
import org.eclipse.koneki.simulators.omadm.model.Node;
import org.eclipse.koneki.simulators.omadm.model.OMADMSimulatorPackage;
import org.eclipse.koneki.simulators.omadm.model.util.DeviceHelpers;
import org.eclipse.koneki.simulators.omadm.model.util.NodeHelpers;

public class DeviceImpl
extends EObjectImpl
implements Device {
    protected static final DeviceIdType DEVICE_ID_TYPE_EDEFAULT = DeviceIdType.FREE;
    protected DeviceIdType deviceIdType = DEVICE_ID_TYPE_EDEFAULT;
    protected Node tree;
    protected static final String DEVICE_ID_EDEFAULT = null;
    protected String deviceId = DEVICE_ID_EDEFAULT;
    protected static final String LOGIN_EDEFAULT = null;
    protected String login = LOGIN_EDEFAULT;
    protected static final String PASSWORD_EDEFAULT = null;
    protected String password = PASSWORD_EDEFAULT;
    protected static final String SERVER_URL_EDEFAULT = null;
    protected String serverUrl = SERVER_URL_EDEFAULT;

    protected DeviceImpl() {
        this.setTree(NodeHelpers.initTree());
    }

    protected EClass eStaticClass() {
        return OMADMSimulatorPackage.Literals.DEVICE;
    }

    @Override
    public DeviceIdType getDeviceIdType() {
        return this.deviceIdType;
    }

    @Override
    public void setDeviceIdType(DeviceIdType newDeviceIdType) {
        if (this.deviceIdType != newDeviceIdType) {
            DeviceIdType oldDeviceIdType = this.deviceIdType;
            this.deviceIdType = newDeviceIdType == null ? DEVICE_ID_TYPE_EDEFAULT : newDeviceIdType;
            String newDeviceId = DeviceHelpers.getDeviceIdTypeAndValue(this.deviceId)[1];
            if (newDeviceIdType != DEVICE_ID_TYPE_EDEFAULT) {
                if (newDeviceId != null) {
                    this.setDeviceId(String.valueOf(this.deviceIdType.getName()) + ":" + DeviceHelpers.getDeviceIdTypeAndValue(this.deviceId)[1]);
                } else {
                    this.setDeviceId(String.valueOf(this.deviceIdType.getName()) + ":" + this.deviceId);
                }
            }
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldDeviceIdType, (Object)this.deviceIdType));
            }
        }
    }

    @Override
    public Node getTree() {
        return this.tree;
    }

    public NotificationChain basicSetTree(Node newTree, NotificationChain msgs) {
        Node oldTree = this.tree;
        this.tree = newTree;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldTree, (Object)newTree);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setTree(Node newTree) {
        if (newTree != this.tree) {
            NotificationChain msgs = null;
            if (this.tree != null) {
                msgs = ((InternalEObject)this.tree).eInverseRemove((InternalEObject)this, -2, null, msgs);
            }
            if (newTree != null) {
                msgs = ((InternalEObject)newTree).eInverseAdd((InternalEObject)this, -2, null, msgs);
            }
            if ((msgs = this.basicSetTree(newTree, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newTree, (Object)newTree));
        }
    }

    @Override
    public String getDeviceId() {
        Node devIdNode = NodeHelpers.findFirstNode(NodeHelpers.getNode(this.getTree(), "./DevInfo"), "DevId");
        if (devIdNode != null) {
            this.deviceId = devIdNode.getData();
            return this.deviceId;
        }
        return this.deviceId;
    }

    @Override
    public void setDeviceId(String newDeviceId) {
        String oldDeviceId = this.deviceId;
        Node root = this.getTree();
        Node devIdNode = NodeHelpers.findFirstNode(NodeHelpers.getNode(root, "./DevInfo"), "DevId");
        if (devIdNode != null && newDeviceId != null) {
            if (newDeviceId != null && !newDeviceId.equals(oldDeviceId)) {
                devIdNode.setData(newDeviceId);
            }
            this.deviceId = newDeviceId;
            String deviceIdType = DeviceHelpers.getDeviceIdTypeAndValue(this.deviceId)[0];
            if (deviceIdType != null) {
                DeviceIdType newDeviceIdType = DeviceIdType.getByName(deviceIdType);
                if (newDeviceIdType != null) {
                    this.setDeviceIdType(newDeviceIdType);
                } else {
                    this.setDeviceIdType(DeviceIdType.FREE);
                }
            } else if (this.deviceId != null) {
                if (this.deviceId.matches("^[0-9]{15}$")) {
                    this.setDeviceIdType(DeviceIdType.IMEI);
                } else if (this.deviceId.matches("^[a-fA-F0-9]{12}$")) {
                    this.setDeviceIdType(DeviceIdType.MAC_ADDRESS);
                } else {
                    this.setDeviceIdType(DeviceIdType.FREE);
                }
            }
        }
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldDeviceId, (Object)newDeviceId));
        }
    }

    @Override
    public String getLogin() {
        Node loginNode = NodeHelpers.findFirstNode(NodeHelpers.getNode(this.getTree(), "./DMAcc/AppAuth"), "AuthName");
        if (loginNode != null) {
            this.login = loginNode.getData();
            return this.login;
        }
        return null;
    }

    @Override
    public void setLogin(String newLogin) {
        String oldLogin = this.login;
        Node loginNode = NodeHelpers.findFirstNode(NodeHelpers.getNode(this.getTree(), "./DMAcc/AppAuth"), "AuthName");
        if (loginNode != null) {
            if (!newLogin.equals(oldLogin)) {
                loginNode.setData(newLogin);
            }
            this.login = newLogin;
        }
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldLogin, (Object)newLogin));
        }
    }

    @Override
    public String getPassword() {
        Node passwordNode = NodeHelpers.findFirstNode(NodeHelpers.getNode(this.getTree(), "./DMAcc/AppAuth"), "AuthSecret");
        if (passwordNode != null) {
            this.password = passwordNode.getData();
            return this.password;
        }
        return null;
    }

    @Override
    public void setPassword(String newPassword) {
        String oldPassword = this.password;
        Node passwordNode = NodeHelpers.findFirstNode(NodeHelpers.getNode(this.getTree(), "./DMAcc/AppAuth"), "AuthSecret");
        if (passwordNode != null) {
            if (!newPassword.equals(oldPassword)) {
                passwordNode.setData(newPassword);
            }
            this.password = newPassword;
        }
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldPassword, (Object)newPassword));
        }
    }

    @Override
    public String getServerUrl() {
        Node serverIDNode = NodeHelpers.findFirstNode(NodeHelpers.getNode(this.getTree(), "./DMAcc/AppAddr"), "Addr");
        if (serverIDNode != null) {
            this.serverUrl = serverIDNode.getData();
            return this.serverUrl;
        }
        return null;
    }

    @Override
    public void setServerUrl(String newServerUrl) {
        String oldServerURL = this.serverUrl;
        this.serverUrl = newServerUrl;
        Node addrNode = NodeHelpers.findFirstNode(NodeHelpers.getNode(this.getTree(), "./DMAcc/AppAddr"), "Addr");
        Node addrTypeNode = NodeHelpers.findFirstNode(NodeHelpers.getNode(this.getTree(), "./DMAcc/AppAddr"), "AddrType");
        Node portNumberNode = NodeHelpers.findFirstNode(NodeHelpers.findFirstNode(NodeHelpers.getNode(this.getTree(), "./DMAcc/AppAddr"), "Port"), "PortNbr");
        try {
            URL newUrl = new URL(newServerUrl);
            int newPortNumber = newUrl.getPort();
            if (newPortNumber == -1) {
                newPortNumber = 80;
            }
            String newServerName = newUrl.getHost();
            String newSubDirectories = newUrl.getPath();
            String newProtocol = newUrl.getProtocol();
            if (!newServerUrl.equals(oldServerURL)) {
                if (addrNode != null) {
                    addrNode.setData(newServerUrl);
                }
                if (addrTypeNode != null) {
                    addrTypeNode.setData(String.valueOf(newProtocol) + "://" + newServerName + newSubDirectories);
                }
                if (portNumberNode != null) {
                    portNumberNode.setData(String.valueOf(newPortNumber));
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            addrNode.setData("");
            addrTypeNode.setData("");
            portNumberNode.setData("80");
        }
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldServerURL, (Object)newServerUrl));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return this.basicSetTree(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getDeviceIdType();
            }
            case 1: {
                return this.getTree();
            }
            case 2: {
                return this.getDeviceId();
            }
            case 3: {
                return this.getLogin();
            }
            case 4: {
                return this.getPassword();
            }
            case 5: {
                return this.getServerUrl();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setDeviceIdType((DeviceIdType)((Object)newValue));
                return;
            }
            case 1: {
                this.setTree((Node)newValue);
                return;
            }
            case 2: {
                this.setDeviceId((String)newValue);
                return;
            }
            case 3: {
                this.setLogin((String)newValue);
                return;
            }
            case 4: {
                this.setPassword((String)newValue);
                return;
            }
            case 5: {
                this.setServerUrl((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setDeviceIdType(DEVICE_ID_TYPE_EDEFAULT);
                return;
            }
            case 1: {
                this.setTree(null);
                return;
            }
            case 2: {
                this.setDeviceId(DEVICE_ID_EDEFAULT);
                return;
            }
            case 3: {
                this.setLogin(LOGIN_EDEFAULT);
                return;
            }
            case 4: {
                this.setPassword(PASSWORD_EDEFAULT);
                return;
            }
            case 5: {
                this.setServerUrl(SERVER_URL_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.deviceIdType != DEVICE_ID_TYPE_EDEFAULT;
            }
            case 1: {
                return this.tree != null;
            }
            case 2: {
                return DEVICE_ID_EDEFAULT == null ? this.deviceId != null : !DEVICE_ID_EDEFAULT.equals(this.deviceId);
            }
            case 3: {
                return LOGIN_EDEFAULT == null ? this.login != null : !LOGIN_EDEFAULT.equals(this.login);
            }
            case 4: {
                return PASSWORD_EDEFAULT == null ? this.password != null : !PASSWORD_EDEFAULT.equals(this.password);
            }
            case 5: {
                return SERVER_URL_EDEFAULT == null ? this.serverUrl != null : !SERVER_URL_EDEFAULT.equals(this.serverUrl);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (deviceIdType: ");
        result.append((Object)this.deviceIdType);
        result.append(", deviceId: ");
        result.append(this.deviceId);
        result.append(", login: ");
        result.append(this.login);
        result.append(", password: ");
        result.append(this.password);
        result.append(", serverUrl: ");
        result.append(this.serverUrl);
        result.append(')');
        return result.toString();
    }
}

