/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.model.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.koneki.protocols.omadm.StatusCode;
import org.eclipse.koneki.simulators.omadm.model.CommandManagement;
import org.eclipse.koneki.simulators.omadm.model.Node;
import org.eclipse.koneki.simulators.omadm.model.NodeFormat;
import org.eclipse.koneki.simulators.omadm.model.OMADMSimulatorFactory;

public class NodeHelpers {
    public static boolean isValidNodeName(Node node) {
        if (node != null) {
            if (node.isRoot()) {
                return NodeHelpers.isValidRootNodeName(node.getName());
            }
            if (node.isInterior()) {
                return NodeHelpers.isValidInteriorNodeName(node.getName());
            }
            if (node.isLeaf()) {
                return NodeHelpers.isValidLeafNodeName(node.getName());
            }
            return true;
        }
        return false;
    }

    private static boolean isValidRootNodeName(String nodeName) {
        return nodeName != null && nodeName.matches("^.$");
    }

    private static boolean isValidInteriorNodeName(String nodeName) {
        return nodeName != null && nodeName.matches("^[a-zA-Z0-9\\-_]+$");
    }

    private static boolean isValidLeafNodeName(String nodeName) {
        return NodeHelpers.isValidInteriorNodeName(nodeName);
    }

    public static boolean isValidNodeFormat(Node node) {
        if (node != null) {
            if (node.isRoot() || node.isInterior()) {
                return node.getFormat() == NodeFormat.NODE;
            }
            if (node.isLeaf()) {
                return node.getFormat() != NodeFormat.NODE;
            }
            return true;
        }
        return false;
    }

    public static boolean isValidNodeType(Node node) {
        if (node != null) {
            if (node.isRoot()) {
                return NodeHelpers.isValidRootNodeType(node.getType());
            }
            if (node.isInterior()) {
                return NodeHelpers.isValidInteriorNodeType(node.getType());
            }
            if (node.isLeaf()) {
                return NodeHelpers.isValidLeafNodeType(node.getType());
            }
            return true;
        }
        return false;
    }

    private static boolean isValidRootNodeType(String nodeType) {
        return nodeType != null && nodeType.matches("^(urn:[a-zA-Z0-9][a-zA-Z0-9\\-]{0,31}:([a-zA-Z0-9()+,-.:=@;$_!*'%/?#]|%[0-9a-fA-F]{2})+|[^.]+(\\.[^.]+)*/[1-9][0-9]*\\.(0|[1-9][0-9]*)(/[a-zA-Z0-9]+)+)?$") && !nodeType.startsWith("urn:urn:");
    }

    private static boolean isValidInteriorNodeType(String nodeType) {
        return NodeHelpers.isValidRootNodeType(nodeType);
    }

    private static boolean isValidLeafNodeType(String nodeType) {
        return nodeType != null && nodeType.matches("^[\\p{ASCII}&&[^\\p{Space}\\p{Cntrl}()<>@,;:\\\\\"/\\[\\]?=]]+/[\\p{ASCII}&&[^\\p{Space}\\p{Cntrl}()<>@,;:\\\\\"/\\[\\]?=]]+(\\s*;\\s*[\\p{ASCII}&&[^\\p{Space}\\p{Cntrl}()<>@,;:\\\\\"/\\[\\]?=]]+=([\\p{ASCII}&&[^\\p{Space}\\p{Cntrl}()<>@,;:\\\\\"/\\[\\]?=]]+|\"([\\p{ASCII}&&[^\"\\r\\n\\\\]]|\\\\\\p{ASCII})*\"))*$");
    }

    public static boolean isValidNodeData(Node node) {
        if (node != null) {
            switch (node.getFormat()) {
                case BIN: {
                    return NodeHelpers.isValidBinNodeData(node.getData());
                }
                case BOOL: {
                    return NodeHelpers.isValidBoolNodeData(node.getData());
                }
                case B64: {
                    return NodeHelpers.isValidB64NodeData(node.getData());
                }
                case CHR: {
                    return NodeHelpers.isValidChrNodeData(node.getData());
                }
                case INT: {
                    return NodeHelpers.isValidIntNodeData(node.getData());
                }
                case NODE: {
                    return NodeHelpers.isValidNodeNodeData(node.getData());
                }
                case NULL: {
                    return NodeHelpers.isValidNullNodeData(node.getData());
                }
                case XML: {
                    return NodeHelpers.isValidXmlNodeData(node.getData());
                }
                case DATE: {
                    return NodeHelpers.isValidDateNodeData(node.getData());
                }
                case TIME: {
                    return NodeHelpers.isValidTimeNodeData(node.getData());
                }
                case FLOAT: {
                    return NodeHelpers.isValidFloatNodeData(node.getData());
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isValidBinNodeData(String nodeData) {
        return nodeData != null;
    }

    private static boolean isValidBoolNodeData(String nodeData) {
        return nodeData != null && nodeData.matches("true|false");
    }

    private static boolean isValidB64NodeData(String nodeData) {
        return nodeData != null;
    }

    private static boolean isValidChrNodeData(String nodeData) {
        return nodeData != null;
    }

    private static boolean isValidIntNodeData(String nodeData) {
        return nodeData != null && nodeData.matches("[+-]?([1-9][0-9]*|0)");
    }

    private static boolean isValidNodeNodeData(String nodeData) {
        return nodeData != null && nodeData.equals("");
    }

    private static boolean isValidNullNodeData(String nodeData) {
        return nodeData != null && nodeData.equals("");
    }

    private static boolean isValidXmlNodeData(String nodeData) {
        return nodeData != null;
    }

    private static boolean isValidDateNodeData(String nodeData) {
        return nodeData != null;
    }

    private static boolean isValidTimeNodeData(String nodeData) {
        return nodeData != null;
    }

    private static boolean isValidFloatNodeData(String nodeData) {
        return nodeData != null;
    }

    public static boolean isValidNodeManagement(Node node) {
        if (node != null) {
            if (node.isRoot()) {
                return node.getGetManagement() != CommandManagement.INHERITED && node.getAddManagement() != CommandManagement.INHERITED && node.getDeleteManagement() != CommandManagement.INHERITED && node.getCopyManagement() != CommandManagement.INHERITED && node.getReplaceManagement() != CommandManagement.INHERITED && node.getExecManagement() != CommandManagement.INHERITED;
            }
            return true;
        }
        return false;
    }

    public static boolean isRespectAuthorizationChildren(Node node) {
        if (node != null) {
            assert (node.getChildren() != null);
            return node.isRoot() || node.isInterior() || node.getChildren().size() == 0;
        }
        return false;
    }

    public static boolean isValidChildrenType(Node node) {
        if (node != null) {
            assert (node.getChildren() != null);
            if (!node.isLeaf()) {
                for (Node child : node.getChildren()) {
                    if (!child.isRoot()) continue;
                    return false;
                }
                return true;
            }
            return node.getChildren().size() == 0;
        }
        return false;
    }

    public static boolean isUniqueChildrenName(Node node) {
        if (node != null) {
            assert (node.getChildren() != null);
            if (!node.isLeaf()) {
                EList<Node> children = node.getChildren();
                int nbChilds = children.size();
                int i = 0;
                int iMax = nbChilds - 1;
                while (i < iMax) {
                    String nodeNameI = ((Node)children.get(i)).getName();
                    if (nodeNameI != null) {
                        int j = i + 1;
                        int jMax = nbChilds;
                        while (j < jMax) {
                            String nodeNameJ = ((Node)children.get(j)).getName();
                            if (nodeNameJ != null && nodeNameI.equals(nodeNameJ)) {
                                return false;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                return true;
            }
            return node.getChildren().size() == 0;
        }
        return false;
    }

    public static boolean canAddChildren(Node node) {
        if (node != null) {
            return node.getFormat() == NodeFormat.NODE;
        }
        return false;
    }

    public static boolean canDeleteNode(Node node) {
        String[] notAllowedNode = new String[]{".", "DevInfo", "DevId", "DwV", "Man", "Mod", "Lang", "DevDetail", "FwV", "SwV", "lrgObj", "DMAcc", "AppAuth", "ServerID", "AppID", "AuthType", "AuthData", "AuthName", "AuthSecret"};
        if (node == null) {
            return false;
        }
        if (node.getRoot() == node) {
            return false;
        }
        String[] stringArray = notAllowedNode;
        int n = notAllowedNode.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals(node.getName())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static String getHead(String path) {
        int slashIndex = path.indexOf(47);
        return slashIndex != -1 ? path.substring(0, slashIndex) : path;
    }

    private static String getQueue(String path) {
        int slashIndex = path.indexOf(47);
        return slashIndex != -1 ? path.substring(slashIndex + 1, path.length()) : null;
    }

    private static Node initInheritedNode(Node node) {
        node.setGetManagement(CommandManagement.INHERITED);
        node.setGetCode(StatusCode.OK.getCode());
        node.setAddManagement(CommandManagement.INHERITED);
        node.setAddCode(StatusCode.OK.getCode());
        node.setDeleteManagement(CommandManagement.INHERITED);
        node.setDeleteCode(StatusCode.OK.getCode());
        node.setCopyManagement(CommandManagement.INHERITED);
        node.setCopyCode(StatusCode.OK.getCode());
        node.setReplaceManagement(CommandManagement.INHERITED);
        node.setReplaceCode(StatusCode.OK.getCode());
        node.setExecManagement(CommandManagement.INHERITED);
        node.setExecCode(StatusCode.OPTIONAL_FEATURE_NOT_SUPPORTED.getCode());
        return node;
    }

    public static Node initLeaf(String name, String type, String data, NodeFormat format, Node parentNode) {
        Node newLeaf = OMADMSimulatorFactory.eINSTANCE.createNode();
        newLeaf.setName(name);
        newLeaf.setType(type);
        newLeaf.setData(data);
        newLeaf.setFormat(format);
        newLeaf.setParent(parentNode);
        NodeHelpers.initInheritedNode(newLeaf);
        return newLeaf;
    }

    public static Node initTree() {
        Node root = NodeHelpers.initRoot();
        Node devInfoNode = NodeHelpers.initNode("DevInfo", root);
        NodeHelpers.initLeaf("DevId", "text/plain", "", NodeFormat.CHR, devInfoNode);
        NodeHelpers.initLeaf("DwV", "text/plain", "", NodeFormat.CHR, devInfoNode);
        NodeHelpers.initLeaf("Man", "text/plain", "", NodeFormat.CHR, devInfoNode);
        NodeHelpers.initLeaf("Mod", "text/plain", "", NodeFormat.CHR, devInfoNode);
        NodeHelpers.initLeaf("Lang", "text/plain", "", NodeFormat.CHR, devInfoNode);
        Node devDetailNode = NodeHelpers.initNode("DevDetail", root);
        NodeHelpers.initLeaf("FwV", "text/plain", "", NodeFormat.CHR, devDetailNode);
        NodeHelpers.initLeaf("SwV", "text/plain", "", NodeFormat.CHR, devDetailNode);
        NodeHelpers.initLeaf("HwV", "text/plain", "", NodeFormat.CHR, devDetailNode);
        NodeHelpers.initLeaf("OEM", "text/plain", "", NodeFormat.CHR, devDetailNode);
        NodeHelpers.initLeaf("lrgObj", "text/plain", "false", NodeFormat.BOOL, devDetailNode);
        NodeHelpers.initLeaf("DevTyp", "text/plain", "", NodeFormat.CHR, devDetailNode);
        Node URINode = NodeHelpers.initNode("URI", devDetailNode);
        NodeHelpers.initLeaf("MaxTotLen", "text/plain", "", NodeFormat.CHR, URINode);
        NodeHelpers.initLeaf("MaxSegLen", "text/plain", "false", NodeFormat.BOOL, URINode);
        NodeHelpers.initLeaf("MaxDepth", "text/plain", "", NodeFormat.CHR, URINode);
        Node DMAccNode = NodeHelpers.initNode("DMAcc", root);
        NodeHelpers.initLeaf("ServerID", "text/plain", "", NodeFormat.CHR, DMAccNode);
        NodeHelpers.initLeaf("AppID", "text/plain", "", NodeFormat.CHR, DMAccNode);
        Node AppAuthNode = NodeHelpers.initNode("AppAuth", DMAccNode);
        Node DefaultAuthNode = NodeHelpers.initNode("Default", AppAuthNode);
        NodeHelpers.initLeaf("AuthType", "text/plain", "", NodeFormat.CHR, DefaultAuthNode);
        NodeHelpers.initLeaf("AuthData", "text/plain", "", NodeFormat.CHR, DefaultAuthNode);
        NodeHelpers.initLeaf("AuthName", "text/plain", "", NodeFormat.CHR, DefaultAuthNode);
        NodeHelpers.initLeaf("AuthSecret", "text/plain", "", NodeFormat.CHR, DefaultAuthNode);
        Node AppAddrNode = NodeHelpers.initNode("AppAddr", DMAccNode);
        Node DefaultAddrNode = NodeHelpers.initNode("Default", AppAddrNode);
        NodeHelpers.initLeaf("AddrType", "text/plain", "", NodeFormat.CHR, DefaultAddrNode);
        NodeHelpers.initLeaf("Addr", "text/plain", "", NodeFormat.CHR, DefaultAddrNode);
        Node PortNode = NodeHelpers.initNode("Port", DefaultAddrNode);
        Node DefaultPortNode = NodeHelpers.initNode("Default", PortNode);
        NodeHelpers.initLeaf("PortNbr", "text/plain", "80", NodeFormat.INT, DefaultPortNode);
        return root;
    }

    public static Node initRoot() {
        Node root = OMADMSimulatorFactory.eINSTANCE.createNode();
        root.setParent(null);
        root.setName(".");
        root.setFormat(NodeFormat.NODE);
        root.setType("");
        root.setData("");
        root.setReplaceManagement(CommandManagement.AUTOMATIC);
        root.setReplaceCode(StatusCode.OK.getCode());
        root.setAddManagement(CommandManagement.AUTOMATIC);
        root.setAddCode(StatusCode.OK.getCode());
        root.setExecManagement(CommandManagement.AUTOMATIC);
        root.setExecCode(StatusCode.OPTIONAL_FEATURE_NOT_SUPPORTED.getCode());
        root.setCopyManagement(CommandManagement.AUTOMATIC);
        root.setCopyCode(StatusCode.OK.getCode());
        root.setGetManagement(CommandManagement.AUTOMATIC);
        root.setGetCode(StatusCode.OK.getCode());
        root.setDeleteManagement(CommandManagement.AUTOMATIC);
        root.setDeleteCode(StatusCode.OK.getCode());
        return root;
    }

    public static Node initNode(String name, Node parentNode) {
        Node newNode = OMADMSimulatorFactory.eINSTANCE.createNode();
        newNode.setName(name);
        newNode.setFormat(NodeFormat.NODE);
        newNode.setParent(parentNode);
        newNode.setData("");
        newNode.setType("");
        NodeHelpers.initInheritedNode(newNode);
        return newNode;
    }

    public static Node findFirstNode(Node node, String nodeName) {
        if (node != null) {
            if (!nodeName.equals(node.getName())) {
                for (Node n : node.getChildren()) {
                    Node search = NodeHelpers.findFirstNode(n, nodeName);
                    if (search == null) continue;
                    return search;
                }
                return null;
            }
            return node;
        }
        return null;
    }

    public static Node getNode(Node tree, String path) {
        String queue = NodeHelpers.getQueue(path);
        if (queue != null) {
            String head = NodeHelpers.getHead(queue);
            for (Node child : tree.getChildren()) {
                if (!child.getName().equals(head)) continue;
                return NodeHelpers.getNode(child, queue);
            }
            return null;
        }
        return tree;
    }

    public static Node getExistAncestorNode(Node tree, String path) {
        String queue = NodeHelpers.getQueue(path);
        if (queue != null) {
            String head = NodeHelpers.getHead(queue);
            for (Node child : tree.getChildren()) {
                if (!child.getName().equals(head)) continue;
                return NodeHelpers.getExistAncestorNode(child, queue);
            }
            return tree;
        }
        return tree;
    }

    public static String[] getChildrenNames(String parentPath, String path) {
        return path.substring(parentPath.length() + 1, path.length()).split("/");
    }

    public static final void iterate(Node tree, NodeIterator nodeIterator) {
        assert (tree != null);
        nodeIterator.currentNode(tree);
        for (Node child : tree.getChildren()) {
            NodeHelpers.iterate(child, nodeIterator);
        }
    }

    public static interface NodeIterator {
        public void currentNode(Node var1);
    }
}

