/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.basic;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.koneki.protocols.omadm.CommandHandler;
import org.eclipse.koneki.protocols.omadm.DMGenericAlert;
import org.eclipse.koneki.protocols.omadm.DMNode;
import org.eclipse.koneki.protocols.omadm.ProtocolListener;
import org.eclipse.koneki.protocols.omadm.Status;
import org.eclipse.koneki.protocols.omadm.StatusCode;
import org.eclipse.koneki.simulators.omadm.DMSimulatorException;
import org.eclipse.koneki.simulators.omadm.basic.DMBasicSimulator;
import org.eclipse.koneki.simulators.omadm.basic.DMCommandHelper;
import org.eclipse.koneki.simulators.omadm.internal.Activator;
import org.eclipse.koneki.simulators.omadm.model.Node;
import org.eclipse.koneki.simulators.omadm.model.NodeFormat;
import org.eclipse.koneki.simulators.omadm.model.util.NodeHelpers;

final class DMBasicSimulation
implements Runnable,
CommandHandler {
    private static final String AUTH_SECRET = "AuthSecret";
    private static final String AUTH_NAME = "AuthName";
    private static final String APP_AUTH = "./DMAcc/AppAuth";
    private final DMBasicSimulator dmSimulator;
    private final URI server;
    private final Node tree;
    private final EditingDomain editingDomain;
    private final CommandHandler commandHandler;
    private final ProtocolListener[] protocolListeners;
    private final DMGenericAlert[] genericAlerts;

    public DMBasicSimulation(DMBasicSimulator dmSimulator, URI server, Node tree, EditingDomain editingDomain, CommandHandler commandHandler, ProtocolListener[] protocolListeners, DMGenericAlert[] genericAlerts) {
        this.dmSimulator = dmSimulator;
        this.server = server;
        this.tree = tree;
        this.editingDomain = editingDomain;
        this.commandHandler = commandHandler;
        this.protocolListeners = protocolListeners;
        this.genericAlerts = genericAlerts;
    }

    @Override
    public void run() {
        try {
            URI client;
            Node devInfo = NodeHelpers.getNode((Node)this.tree, (String)"./DevInfo");
            if (devInfo == null) {
                throw new DMSimulatorException("The ./DevInfo node does not exist");
            }
            Node devId = NodeHelpers.getNode((Node)devInfo, (String)"DevInfo/DevId");
            if (devId == null) {
                throw new DMSimulatorException("The ./DevInfo/DevId node does not exist");
            }
            try {
                client = new URI(devId.getData());
            }
            catch (URISyntaxException e) {
                throw new DMSimulatorException(e);
            }
            final LinkedList devInfoNodes = new LinkedList();
            NodeHelpers.iterate((Node)devInfo, (NodeHelpers.NodeIterator)new NodeHelpers.NodeIterator(){

                public void currentNode(Node node) {
                    if (node.isLeaf()) {
                        devInfoNodes.add(new DMNode(node.getPath(), node.getFormat().getLiteral(), node.getType(), node.getData()));
                    }
                }
            });
            String userName = NodeHelpers.findFirstNode((Node)NodeHelpers.getNode((Node)this.tree, (String)APP_AUTH), (String)AUTH_NAME).getData();
            String userPassword = NodeHelpers.findFirstNode((Node)NodeHelpers.getNode((Node)this.tree, (String)APP_AUTH), (String)AUTH_SECRET).getData();
            String userAuth = String.valueOf(userName) + ":" + userPassword;
            byte[] encoded = Base64.encodeBase64((byte[])userAuth.getBytes());
            this.dmSimulator.getDMClient().initiateManagementSession(this.server, new String(encoded), client, devInfoNodes.toArray(new DMNode[0]), (CommandHandler)this, this.protocolListeners, this.genericAlerts);
        }
        catch (DMSimulatorException e) {
            Activator.logError("Problem while initializing management session", e);
        }
    }

    public Status add(String target, String format, String type, String data) {
        Node ancestorNode = NodeHelpers.getExistAncestorNode((Node)this.tree, (String)target);
        switch (ancestorNode.getRealAddManagement()) {
            case AUTOMATIC: {
                return DMCommandHelper.add(this.tree, this.editingDomain, target, format, type, data, false);
            }
            case CONSTANT: {
                int code = ancestorNode.getRealAddCode();
                if (code == StatusCode.OK.getCode()) {
                    return DMCommandHelper.add(this.tree, this.editingDomain, target, format, type, data, true);
                }
                return StatusCode.fromInt((int)code);
            }
        }
        return this.commandHandler.add(target, format, type, data);
    }

    public Status copy(String target, String source) {
        Node ancestorNode = NodeHelpers.getExistAncestorNode((Node)this.tree, (String)target);
        switch (ancestorNode.getRealCopyManagement()) {
            case AUTOMATIC: {
                return DMCommandHelper.copy(this.tree, this.editingDomain, target, source, false);
            }
            case CONSTANT: {
                int code = ancestorNode.getRealCopyCode();
                if (code == StatusCode.OK.getCode()) {
                    return DMCommandHelper.copy(this.tree, this.editingDomain, target, source, true);
                }
                return StatusCode.fromInt((int)code);
            }
        }
        return this.commandHandler.copy(target, source);
    }

    public Status delete(String target) {
        Node ancestorNode = NodeHelpers.getExistAncestorNode((Node)this.tree, (String)target);
        switch (ancestorNode.getRealDeleteManagement()) {
            case AUTOMATIC: {
                return DMCommandHelper.delete(this.tree, this.editingDomain, target, false);
            }
            case CONSTANT: {
                int code = ancestorNode.getRealDeleteCode();
                if (code == StatusCode.OK.getCode()) {
                    return DMCommandHelper.delete(this.tree, this.editingDomain, target, true);
                }
                return StatusCode.fromInt((int)code);
            }
        }
        return this.commandHandler.delete(target);
    }

    public Status get(String target) {
        Node ancestorNode = NodeHelpers.getExistAncestorNode((Node)this.tree, (String)target);
        switch (ancestorNode.getRealGetManagement()) {
            case AUTOMATIC: {
                return DMCommandHelper.get(this.tree, this.editingDomain, target, false);
            }
            case CONSTANT: {
                int code = ancestorNode.getRealGetCode();
                if (code == StatusCode.OK.getCode()) {
                    return DMCommandHelper.get(this.tree, this.editingDomain, target, true);
                }
                return StatusCode.fromInt((int)code);
            }
        }
        return this.commandHandler.get(target);
    }

    public Status exec(String target, String correlator, String format, String type, String data) {
        Node node = NodeHelpers.getNode((Node)this.tree, (String)target);
        if (node != null) {
            switch (node.getRealExecManagement()) {
                case AUTOMATIC: {
                    return this.dmSimulator.exec(node, this.editingDomain, correlator, format, type, data, false);
                }
                case CONSTANT: {
                    return StatusCode.fromInt((int)node.getRealExecCode());
                }
            }
            return this.dmSimulator.exec(node, this.editingDomain, correlator, format, type, data, true);
        }
        Node ancestorNode = NodeHelpers.getExistAncestorNode((Node)this.tree, (String)target);
        switch (ancestorNode.getRealExecManagement()) {
            case AUTOMATIC: {
                return StatusCode.NOT_FOUND;
            }
            case CONSTANT: {
                return StatusCode.fromInt((int)ancestorNode.getRealExecCode());
            }
        }
        DMCommandHelper.add(this.tree, this.editingDomain, target, NodeFormat.NODE.getLiteral(), "", "", true);
        return this.dmSimulator.exec(node, this.editingDomain, correlator, format, type, data, true);
    }

    public Status replace(String target, String format, String type, String data) {
        Node ancestorNode = NodeHelpers.getExistAncestorNode((Node)this.tree, (String)target);
        switch (ancestorNode.getRealReplaceManagement()) {
            case AUTOMATIC: {
                return DMCommandHelper.replace(this.tree, this.editingDomain, target, format, type, data, false);
            }
            case CONSTANT: {
                int code = ancestorNode.getRealReplaceCode();
                if (code == StatusCode.OK.getCode()) {
                    return DMCommandHelper.replace(this.tree, this.editingDomain, target, format, type, data, true);
                }
                return StatusCode.fromInt((int)code);
            }
        }
        return this.commandHandler.replace(target, format, type, data);
    }
}

