/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.basic;

import java.net.URI;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.koneki.protocols.omadm.CommandHandler;
import org.eclipse.koneki.protocols.omadm.DMGenericAlert;
import org.eclipse.koneki.protocols.omadm.ProtocolListener;
import org.eclipse.koneki.protocols.omadm.Status;
import org.eclipse.koneki.protocols.omadm.StatusCode;
import org.eclipse.koneki.protocols.omadm.client.DMClient;
import org.eclipse.koneki.simulators.omadm.DMSimulator;
import org.eclipse.koneki.simulators.omadm.basic.DMBasicSimulation;
import org.eclipse.koneki.simulators.omadm.basic.DMExecHandler;
import org.eclipse.koneki.simulators.omadm.model.Node;

public class DMBasicSimulator
implements DMSimulator {
    private final DMClient dmClient;
    private final ExecutorService executorService;
    private final Map<MOIPathKey, PriorityQueue<DMExecHandler>> moiPathKeyToExecHandler;
    private final Map<String, PriorityQueue<DMExecHandler>> pathKeyToExecHandler;

    public DMBasicSimulator(DMClient dmClient) {
        if (dmClient == null) {
            throw new NullPointerException();
        }
        this.dmClient = dmClient;
        this.executorService = Executors.newSingleThreadExecutor();
        this.moiPathKeyToExecHandler = new HashMap<MOIPathKey, PriorityQueue<DMExecHandler>>();
        this.pathKeyToExecHandler = new HashMap<String, PriorityQueue<DMExecHandler>>();
    }

    public synchronized void addExecHandler(DMExecHandler execHandler) {
        String[] stringArray = execHandler.getNodePathsSupported();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            PriorityQueue<DMExecHandler> execHandlers;
            String nodePath = stringArray[n2];
            MOIPathKey key = new MOIPathKey(execHandler.getManagementObjectIdentifierSupported(), nodePath);
            if (this.moiPathKeyToExecHandler.containsKey(key)) {
                this.moiPathKeyToExecHandler.get(key).add(execHandler);
            } else {
                execHandlers = new PriorityQueue<DMExecHandler>(1, new Comparator<DMExecHandler>(){

                    @Override
                    public int compare(DMExecHandler lhs, DMExecHandler rhs) {
                        if (lhs.requireUserInteraction()) {
                            return rhs.requireUserInteraction() ? 0 : 1;
                        }
                        return rhs.requireUserInteraction() ? -1 : 0;
                    }
                });
                execHandlers.add(execHandler);
                this.moiPathKeyToExecHandler.put(key, execHandlers);
            }
            if (this.pathKeyToExecHandler.containsKey(nodePath)) {
                this.pathKeyToExecHandler.get(nodePath).add(execHandler);
            } else {
                execHandlers = new PriorityQueue<DMExecHandler>(1, new Comparator<DMExecHandler>(){

                    @Override
                    public int compare(DMExecHandler lhs, DMExecHandler rhs) {
                        if (lhs.requireUserInteraction()) {
                            return rhs.requireUserInteraction() ? 0 : 1;
                        }
                        return rhs.requireUserInteraction() ? -1 : 0;
                    }
                });
                execHandlers.add(execHandler);
                this.pathKeyToExecHandler.put(nodePath, execHandlers);
            }
            ++n2;
        }
    }

    public synchronized void removeExecHandler(DMExecHandler execHandler) {
        String[] stringArray = execHandler.getNodePathsSupported();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            PriorityQueue<DMExecHandler> exechandlers;
            String nodePath = stringArray[n2];
            MOIPathKey key = new MOIPathKey(execHandler.getManagementObjectIdentifierSupported(), nodePath);
            PriorityQueue<DMExecHandler> exechandlers2 = this.moiPathKeyToExecHandler.get(key);
            if (exechandlers2.remove(execHandler) && exechandlers2.isEmpty()) {
                this.moiPathKeyToExecHandler.remove(key);
            }
            if ((exechandlers = this.pathKeyToExecHandler.get(nodePath)).remove(execHandler) && exechandlers.isEmpty()) {
                this.moiPathKeyToExecHandler.remove(nodePath);
            }
            ++n2;
        }
    }

    final synchronized Status exec(Node nodeToExec, EditingDomain editingDomain, String correlator, String format, String type, String data, boolean mustRequireUserInteration) {
        Status status;
        PriorityQueue<DMExecHandler> execHandlers;
        String nodePath;
        StringBuffer sb = new StringBuffer();
        Node it = nodeToExec;
        while (it != null) {
            if (!it.getType().isEmpty()) {
                nodePath = "." + sb.toString();
                execHandlers = this.moiPathKeyToExecHandler.get(new MOIPathKey(it.getType(), nodePath));
                if (execHandlers != null) {
                    for (DMExecHandler execHandler : execHandlers) {
                        if (mustRequireUserInteration && !execHandler.requireUserInteraction() || (status = execHandler.exec(nodeToExec, editingDomain, correlator, format, type, data)) == null) continue;
                        return status;
                    }
                }
            }
            sb.insert(0, "/" + it.getName());
            it = it.getParent();
        }
        sb.setLength(0);
        it = nodeToExec;
        while (it != null) {
            nodePath = "." + sb.toString();
            execHandlers = this.pathKeyToExecHandler.get(nodePath);
            if (execHandlers != null) {
                for (DMExecHandler execHandler : execHandlers) {
                    if (mustRequireUserInteration && !execHandler.requireUserInteraction() || (status = execHandler.exec(nodeToExec, editingDomain, correlator, format, type, data)) == null) continue;
                    return status;
                }
            }
            sb.insert(0, "/" + it.getName());
            it = it.getParent();
        }
        return StatusCode.OPTIONAL_FEATURE_NOT_SUPPORTED;
    }

    @Override
    public void simulate(URI server, Node tree, EditingDomain editingDomain, CommandHandler commandHandler) {
        this.simulate(server, tree, editingDomain, commandHandler, new ProtocolListener[0], new DMGenericAlert[0]);
    }

    @Override
    public void simulate(URI server, Node tree, EditingDomain editingDomain, CommandHandler commandHandler, ProtocolListener[] protocolListeners) {
        this.simulate(server, tree, editingDomain, commandHandler, protocolListeners, new DMGenericAlert[0]);
    }

    @Override
    public void simulate(URI server, Node tree, EditingDomain editingDomain, CommandHandler commandHandler, DMGenericAlert[] genericAlerts) {
        this.simulate(server, tree, editingDomain, commandHandler, new ProtocolListener[0], genericAlerts);
    }

    @Override
    public void simulate(URI server, Node tree, EditingDomain editingDomain, CommandHandler commandHandler, ProtocolListener[] protocolListeners, DMGenericAlert[] genericAlerts) {
        if (server == null || tree == null || editingDomain == null || commandHandler == null || protocolListeners == null || genericAlerts == null) {
            throw new NullPointerException();
        }
        this.executorService.execute(new DMBasicSimulation(this, server, tree, editingDomain, commandHandler, protocolListeners, genericAlerts));
    }

    final DMClient getDMClient() {
        return this.dmClient;
    }

    private static final class MOIPathKey {
        private final String managementObjectIdentifier;
        private final String nodePath;

        public MOIPathKey(String managementObjectIdentifier, String nodePath) {
            this.managementObjectIdentifier = managementObjectIdentifier;
            this.nodePath = nodePath;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.managementObjectIdentifier.hashCode();
            result = 31 * result + this.nodePath.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && obj instanceof MOIPathKey) {
                MOIPathKey other = (MOIPathKey)obj;
                return this.managementObjectIdentifier.equals(other.managementObjectIdentifier) && this.nodePath.equals(other.nodePath);
            }
            return false;
        }
    }
}

