/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.internal.ui.Search;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchResultView;
import org.eclipse.search.internal.ui.SearchResultViewEntry;
import org.eclipse.search.internal.ui.SearchResultViewer;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class SearchManager
implements IResourceChangeListener {
    static SearchManager fgDefault;
    Search fCurrentSearch = null;
    private HashSet fListeners = new HashSet();
    private LinkedList fPreviousSearches = new LinkedList();
    private boolean fIsRemoveAll = false;

    private SearchManager() {
        SearchPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public static synchronized SearchManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new SearchManager();
        }
        return fgDefault;
    }

    public void dispose() {
        SearchPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    LinkedList getPreviousSearches() {
        return this.fPreviousSearches;
    }

    ArrayList getCurrentResults() {
        if (this.fCurrentSearch == null) {
            return new ArrayList(0);
        }
        return (ArrayList)this.fCurrentSearch.getResults();
    }

    public Search getCurrentSearch() {
        return this.fCurrentSearch;
    }

    void removeAllSearches() {
        block8: {
            SearchPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    monitor.beginTask(SearchMessages.SearchManager_updating, 100);
                    SearchPlugin.getWorkspace().getRoot().deleteMarkers("org.eclipse.search.searchmarker", true, 2);
                    monitor.worked(100);
                    monitor.done();
                }
            };
            boolean isAutoBuilding = SearchPlugin.setAutoBuilding(false);
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
                dialog.run(true, true, (IRunnableWithProgress)op);
            }
            catch (InvocationTargetException ex) {
                ExceptionHandler.handle(ex, SearchMessages.Search_Error_deleteMarkers_title, SearchMessages.Search_Error_deleteMarkers_message);
                SearchPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
                SearchPlugin.setAutoBuilding(isAutoBuilding);
                break block8;
            }
            catch (InterruptedException interruptedException) {
                try {
                    break block8;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    SearchPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
                    SearchPlugin.setAutoBuilding(isAutoBuilding);
                }
            }
            SearchPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            SearchPlugin.setAutoBuilding(isAutoBuilding);
        }
        this.fPreviousSearches = new LinkedList();
        this.fCurrentSearch = null;
        Iterator iter = this.fListeners.iterator();
        while (iter.hasNext()) {
            SearchResultViewer viewer = (SearchResultViewer)((Object)iter.next());
            this.handleAllSearchesRemoved(viewer);
        }
    }

    private void handleAllSearchesRemoved(SearchResultViewer viewer) {
        viewer.handleAllSearchesRemoved();
    }

    void setCurrentSearch(final Search search) {
        block8: {
            if (this.fCurrentSearch == search) {
                return;
            }
            SearchPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    SearchManager.this.internalSetCurrentSearch(search, monitor);
                }
            };
            boolean isAutoBuilding = SearchPlugin.setAutoBuilding(false);
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
                dialog.run(true, true, (IRunnableWithProgress)op);
            }
            catch (InvocationTargetException ex) {
                ExceptionHandler.handle(ex, SearchMessages.Search_Error_switchSearch_title, SearchMessages.Search_Error_switchSearch_message);
                SearchPlugin.setAutoBuilding(isAutoBuilding);
                break block8;
            }
            catch (InterruptedException interruptedException) {
                try {
                    break block8;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    SearchPlugin.setAutoBuilding(isAutoBuilding);
                }
            }
            SearchPlugin.setAutoBuilding(isAutoBuilding);
        }
        this.getPreviousSearches().remove(search);
        this.getPreviousSearches().addFirst(search);
    }

    /*
     * Unable to fully structure code
     */
    void internalSetCurrentSearch(Search search, IProgressMonitor monitor) {
        if (this.fCurrentSearch != null) {
            this.fCurrentSearch.backupMarkers();
        }
        previousSearch = this.fCurrentSearch;
        this.fCurrentSearch = search;
        monitor.beginTask(SearchMessages.SearchManager_updating, this.getCurrentResults().size() + 20);
        try {
            SearchPlugin.getWorkspace().getRoot().deleteMarkers("org.eclipse.search.searchmarker", true, 2);
        }
        catch (CoreException ex) {
            ExceptionHandler.handle(ex, SearchMessages.Search_Error_deleteMarkers_title, SearchMessages.Search_Error_deleteMarkers_message);
        }
        monitor.worked(10);
        iter = this.getCurrentResults().iterator();
        emptyEntries = new ArrayList<SearchResultViewEntry>(10);
        filesChanged = false;
        filesDeleted = false;
        groupByKeyComputer = this.getCurrentSearch().getGroupByKeyComputer();
        while (iter.hasNext()) {
            monitor.worked(1);
            entry = (SearchResultViewEntry)iter.next();
            attrPerMarkerIter = entry.getAttributesPerMarker().iterator();
            entry.clearMarkerList();
            if (entry.getResource() != null && entry.getResource().exists()) ** GOTO lbl44
            emptyEntries.add(entry);
            filesDeleted = true;
            continue;
lbl-1000:
            // 1 sources

            {
                newMarker = null;
                try {
                    newMarker = entry.getResource().createMarker(entry.getMarkerType());
                }
                catch (CoreException ex) {
                    ExceptionHandler.handle(ex, SearchMessages.Search_Error_createMarker_title, SearchMessages.Search_Error_createMarker_message);
                    continue;
                }
                try {
                    newMarker.setAttributes((Map)attrPerMarkerIter.next());
                    if (groupByKeyComputer != null && groupByKeyComputer.computeGroupByKey(newMarker) == null) {
                        filesDeleted = true;
                        newMarker.delete();
                        continue;
                    }
                }
                catch (CoreException ex) {
                    ExceptionHandler.handle(ex, SearchMessages.Search_Error_markerAttributeAccess_title, SearchMessages.Search_Error_markerAttributeAccess_message);
                }
                entry.add(newMarker);
lbl44:
                // 4 sources

                ** while (attrPerMarkerIter.hasNext())
            }
lbl45:
            // 1 sources

            if (entry.getMatchCount() == 0) {
                emptyEntries.add(entry);
                continue;
            }
            if (filesChanged || entry.getResource().getModificationStamp() == entry.getModificationStamp()) continue;
            filesChanged = true;
        }
        this.getCurrentResults().removeAll(emptyEntries);
        monitor.worked(10);
        warningMessage = null;
        display = this.getDisplay();
        if (filesChanged) {
            warningMessage = SearchMessages.SearchManager_resourceChanged;
        }
        if (filesDeleted) {
            warningMessage = warningMessage == null ? "" : String.valueOf(warningMessage) + "\n";
            warningMessage = String.valueOf(warningMessage) + SearchMessages.SearchManager_resourceDeleted;
        }
        if (warningMessage != null && display != null && !display.isDisposed()) {
            warningTitle = SearchMessages.SearchManager_resourceChangedWarning;
            warningMsg = warningMessage;
            display.syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openWarning((Shell)SearchManager.this.getShell(), (String)warningTitle, (String)warningMsg);
                }
            });
        }
        iter = this.fListeners.iterator();
        if (display != null && !display.isDisposed()) {
            visibleViewer = ((SearchResultView)SearchUI.getSearchResultView()).getViewer();
            while (iter.hasNext()) {
                viewer = (SearchResultViewer)iter.next();
                display.syncExec(new Runnable((Viewer)visibleViewer, search){
                    private final /* synthetic */ Viewer val$visibleViewer;
                    private final /* synthetic */ Search val$search;
                    {
                        this.val$visibleViewer = viewer2;
                        this.val$search = search2;
                    }

                    public void run() {
                        if (previousSearch != null && viewer == this.val$visibleViewer) {
                            previousSearch.setSelection(viewer.getSelection());
                        }
                        viewer.setInput(null);
                        viewer.setPageId(this.val$search.getPageId());
                        viewer.setGotoMarkerAction(this.val$search.getGotoMarkerAction());
                        viewer.setContextMenuTarget(this.val$search.getContextMenuContributor());
                        viewer.setActionGroupFactory(null);
                        viewer.setInput(SearchManager.this.getCurrentResults());
                        viewer.setActionGroupFactory(this.val$search.getActionGroupFactory());
                        viewer.setSelection(SearchManager.this.fCurrentSearch.getSelection(), true);
                    }
                });
            }
        }
        monitor.done();
    }

    int getCurrentItemCount() {
        if (this.fCurrentSearch != null) {
            return this.fCurrentSearch.getItemCount();
        }
        return 0;
    }

    void removeAllResults() {
        this.fIsRemoveAll = true;
        try {
            SearchPlugin.getWorkspace().getRoot().deleteMarkers("org.eclipse.search.searchmarker", true, 2);
        }
        catch (CoreException ex) {
            ExceptionHandler.handle(ex, SearchMessages.Search_Error_deleteMarkers_title, SearchMessages.Search_Error_deleteMarkers_message);
            this.fIsRemoveAll = false;
        }
    }

    void addNewSearch(Search newSearch) {
        SearchPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        Iterator iter = this.fListeners.iterator();
        Display display = this.getDisplay();
        if (display != null && !display.isDisposed()) {
            SearchResultViewer visibleViewer = ((SearchResultView)SearchUI.getSearchResultView()).getViewer();
            while (iter.hasNext()) {
                final SearchResultViewer viewer = (SearchResultViewer)((Object)iter.next());
                display.syncExec(new Runnable((Viewer)visibleViewer, newSearch){
                    private final /* synthetic */ Viewer val$visibleViewer;
                    private final /* synthetic */ Search val$newSearch;
                    {
                        this.val$visibleViewer = viewer2;
                        this.val$newSearch = search;
                    }

                    public void run() {
                        if (SearchManager.this.fCurrentSearch != null && viewer == this.val$visibleViewer) {
                            SearchManager.this.fCurrentSearch.setSelection(viewer.getSelection());
                        }
                        SearchManager.this.setNewSearch(viewer, this.val$newSearch);
                    }
                });
            }
        }
        if (this.fCurrentSearch != null) {
            if (this.fCurrentSearch.isSameSearch(newSearch)) {
                this.getPreviousSearches().remove(this.fCurrentSearch);
            } else {
                this.fCurrentSearch.backupMarkers();
            }
        }
        this.fCurrentSearch = newSearch;
        this.getPreviousSearches().addFirst(this.fCurrentSearch);
        try {
            SearchPlugin.getWorkspace().getRoot().deleteMarkers("org.eclipse.search.searchmarker", true, 2);
        }
        catch (CoreException ex) {
            ExceptionHandler.handle(ex, SearchMessages.Search_Error_deleteMarkers_title, SearchMessages.Search_Error_deleteMarkers_message);
        }
    }

    void searchFinished(ArrayList results) {
        Assert.isNotNull((Object)results);
        this.getCurrentSearch().setResults(results);
        Display display = this.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        if (Thread.currentThread() == display.getThread()) {
            this.handleNewSearchResult();
        } else {
            display.syncExec(new Runnable(){

                public void run() {
                    SearchManager.this.handleNewSearchResult();
                }
            });
        }
        SearchPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    void addSearchChangeListener(SearchResultViewer viewer) {
        this.fListeners.add(viewer);
    }

    void removeSearchChangeListener(SearchResultViewer viewer) {
        Assert.isNotNull((Object)((Object)viewer));
        this.fListeners.remove((Object)viewer);
    }

    private final void handleSearchMarkersChanged(IMarkerDelta[] markerDeltas) {
        if (this.fIsRemoveAll) {
            this.handleRemoveAll();
            this.fIsRemoveAll = false;
            return;
        }
        Iterator iter = this.fListeners.iterator();
        while (iter.hasNext()) {
            ((SearchResultViewer)((Object)iter.next())).getControl().setRedraw(false);
        }
        int i = 0;
        while (i < markerDeltas.length) {
            this.handleSearchMarkerChanged(markerDeltas[i]);
            ++i;
        }
        iter = this.fListeners.iterator();
        while (iter.hasNext()) {
            ((SearchResultViewer)((Object)iter.next())).getControl().setRedraw(true);
        }
    }

    private void handleSearchMarkerChanged(IMarkerDelta markerDelta) {
        int kind = markerDelta.getKind();
        if ((kind & 2) != 0) {
            this.handleRemoveMatch(markerDelta.getMarker());
        } else if ((kind & 4) != 0) {
            this.handleUpdateMatch(markerDelta.getMarker());
        }
    }

    private void handleRemoveAll() {
        if (this.fCurrentSearch != null) {
            this.fCurrentSearch.removeResults();
        }
        Iterator iter = this.fListeners.iterator();
        while (iter.hasNext()) {
            ((SearchResultViewer)((Object)iter.next())).handleRemoveAll();
        }
    }

    private void handleNewSearchResult() {
        Iterator iter = this.fListeners.iterator();
        while (iter.hasNext()) {
            SearchResultViewer viewer = (SearchResultViewer)((Object)iter.next());
            viewer.setInput(this.getCurrentResults());
        }
    }

    private void setNewSearch(SearchResultViewer viewer, Search search) {
        viewer.setInput(null);
        viewer.clearTitle();
        viewer.setPageId(search.getPageId());
        viewer.setGotoMarkerAction(search.getGotoMarkerAction());
        viewer.setContextMenuTarget(search.getContextMenuContributor());
        viewer.setActionGroupFactory(search.getActionGroupFactory());
    }

    private void handleRemoveMatch(IMarker marker) {
        block4: {
            SearchResultViewEntry entry = this.findEntry(marker);
            if (entry == null) break block4;
            entry.remove(marker);
            if (entry.getMatchCount() == 0) {
                this.getCurrentResults().remove(entry);
                Iterator iter = this.fListeners.iterator();
                while (iter.hasNext()) {
                    ((SearchResultViewer)((Object)iter.next())).handleRemoveMatch(entry);
                }
            } else {
                Iterator iter = this.fListeners.iterator();
                while (iter.hasNext()) {
                    ((SearchResultViewer)((Object)iter.next())).handleUpdateMatch(entry, true);
                }
            }
        }
    }

    private void handleUpdateMatch(IMarker marker) {
        SearchResultViewEntry entry = this.findEntry(marker);
        if (entry != null) {
            Iterator iter = this.fListeners.iterator();
            while (iter.hasNext()) {
                ((SearchResultViewer)((Object)iter.next())).handleUpdateMatch(entry, false);
            }
        }
    }

    private SearchResultViewEntry findEntry(IMarker marker) {
        Iterator entries = this.getCurrentResults().iterator();
        while (entries.hasNext()) {
            SearchResultViewEntry entry = (SearchResultViewEntry)entries.next();
            if (!entry.contains(marker)) continue;
            return entry;
        }
        return null;
    }

    public final void resourceChanged(IResourceChangeEvent event) {
        if (event == null) {
            return;
        }
        final IMarkerDelta[] markerDeltas = event.findMarkerDeltas("org.eclipse.search.searchmarker", true);
        if (markerDeltas == null || markerDeltas.length < 1) {
            return;
        }
        Display display = this.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (SearchManager.this.getCurrentSearch() != null) {
                    SearchManager.this.handleSearchMarkersChanged(markerDeltas);
                    Iterator iter = SearchManager.this.fListeners.iterator();
                    while (iter.hasNext()) {
                        SearchResultViewer viewer = (SearchResultViewer)((Object)iter.next());
                        viewer.enableActions();
                        viewer.updateTitle();
                    }
                }
            }
        };
        display.syncExec(runnable);
    }

    private Display getDisplay() {
        Iterator iter = this.fListeners.iterator();
        while (iter.hasNext()) {
            Display display;
            Control control = ((Viewer)iter.next()).getControl();
            if (control == null || control.isDisposed() || (display = control.getDisplay()) == null || display.isDisposed()) continue;
            return display;
        }
        return null;
    }

    private Shell getShell() {
        return SearchPlugin.getActiveWorkbenchShell();
    }
}

