/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.editor.internal.text;

import org.eclipse.dltk.compiler.task.ITodoTaskPreferences;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.ScriptCommentScanner;
import org.eclipse.dltk.ui.text.ScriptPresentationReconciler;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.SingleTokenScriptScanner;
import org.eclipse.dltk.ui.text.completion.ContentAssistPreference;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.koneki.ldt.editor.completion.LuaCompletionProcessor;
import org.eclipse.koneki.ldt.editor.internal.text.ILuaPartitions;
import org.eclipse.koneki.ldt.editor.internal.text.LuaCodeScanner;
import org.eclipse.koneki.ldt.editor.internal.text.LuaContentAssistPreference;
import org.eclipse.koneki.ldt.editor.internal.text.LuaDoubleClickSelector;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class LuaSourceViewerConfiguration
extends ScriptSourceViewerConfiguration {
    private AbstractScriptScanner fCodeScanner;
    private AbstractScriptScanner fStringScanner;
    private AbstractScriptScanner fSingleQuoteStringScanner;
    private AbstractScriptScanner fCommentScanner;
    private AbstractScriptScanner fMultilineCommentScanner;
    private AbstractScriptScanner fNumberScanner;

    public LuaSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(colorManager, preferenceStore, editor, partitioning);
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new LuaDoubleClickSelector();
    }

    protected void alterContentAssistant(ContentAssistant assistant) {
        LuaCompletionProcessor scriptProcessor = new LuaCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)scriptProcessor, "__dftl_partition_content_type");
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new DefaultIndentLineAutoEditStrategy()};
    }

    protected ContentAssistPreference getContentAssistPreference() {
        return LuaContentAssistPreference.getDefault();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        ScriptPresentationReconciler reconciler = new ScriptPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.fCodeScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fStringScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__lua_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__lua_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fSingleQuoteStringScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__lua_single_quote_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__lua_single_quote_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fMultilineCommentScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__lua_multi_line_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__lua_multi_line_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fCommentScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__lua_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__lua_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fNumberScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__lua_number");
        reconciler.setRepairer((IPresentationRepairer)dr, "__lua_number");
        return reconciler;
    }

    protected void initializeScanners() {
        this.fCodeScanner = new LuaCodeScanner(this.getColorManager(), this.fPreferenceStore);
        this.fStringScanner = new SingleTokenScriptScanner(this.getColorManager(), this.fPreferenceStore, "DLTK_string");
        this.fSingleQuoteStringScanner = new SingleTokenScriptScanner(this.getColorManager(), this.fPreferenceStore, "DLTK_string");
        this.fMultilineCommentScanner = new SingleTokenScriptScanner(this.getColorManager(), this.fPreferenceStore, "DLTK_multi_line_comment");
        this.fCommentScanner = this.createCommentScanner("DLTK_single_line_comment", "DLTK_comment_task_tag");
        this.fNumberScanner = new SingleTokenScriptScanner(this.getColorManager(), this.fPreferenceStore, "DLTK_number");
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
        if (this.fSingleQuoteStringScanner.affectsBehavior(event)) {
            this.fSingleQuoteStringScanner.adaptToPreferenceChange(event);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(event)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fCommentScanner.affectsBehavior(event)) {
            this.fCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fNumberScanner.affectsBehavior(event)) {
            this.fNumberScanner.adaptToPreferenceChange(event);
        }
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event) || this.fStringScanner.affectsBehavior(event) || this.fSingleQuoteStringScanner.affectsBehavior(event) || this.fMultilineCommentScanner.affectsBehavior(event) || this.fCommentScanner.affectsBehavior(event) || this.fNumberScanner.affectsBehavior(event);
    }

    protected String getCommentPrefix() {
        return "--";
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return ILuaPartitions.LUA_PARTITION_TYPES;
    }

    protected AbstractScriptScanner createCommentScanner(String commentColor, String tagColor, ITodoTaskPreferences taskPrefs) {
        return new ScriptCommentScanner(this.getColorManager(), this.fPreferenceStore, commentColor, tagColor, taskPrefs){

            protected int skipCommentChars() {
                if (this.read() == 45) {
                    if (this.read() == 45) {
                        return 2;
                    }
                    this.unread();
                    this.unread();
                    return 0;
                }
                this.unread();
                return 0;
            }
        };
    }
}

