/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.r21.widgets;

import org.eclipse.jface.util.Util;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.presentations.r21.widgets.CTabFolderEvent;
import org.eclipse.ui.internal.presentations.r21.widgets.CTabFolderListener;
import org.eclipse.ui.internal.presentations.r21.widgets.CTabItem;

public class CTabFolder
extends Composite {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public static RGB borderInsideRGB = new RGB(132, 130, 132);
    public static RGB borderMiddleRGB = new RGB(143, 141, 138);
    public static RGB borderOutsideRGB = new RGB(171, 168, 165);
    public int MIN_TAB_WIDTH = 3;
    int xClient;
    int yClient;
    boolean onBottom = false;
    boolean fixedTabHeight;
    int tabHeight;
    private CTabItem[] items = new CTabItem[0];
    private int selectedIndex = -1;
    int topTabIndex = -1;
    private CTabFolderListener[] tabListeners = new CTabFolderListener[0];
    Image backgroundImage;
    Color[] gradientColors;
    int[] gradientPercents;
    Color selectionForeground;
    Color background;
    private static final int DEFAULT_WIDTH = 64;
    private static final int DEFAULT_HEIGHT = 64;
    private ToolBar arrowBar;
    private Image arrowLeftImage;
    private Image arrowRightImage;
    private Control topRight;
    boolean showClose = false;
    private Image closeImage;
    ToolBar closeBar;
    private ToolBar inactiveCloseBar;
    private CTabItem inactiveItem;
    boolean showBorders = false;
    private int borderBottom = 0;
    private int borderLeft = 0;
    private int borderRight = 0;
    private int borderTop = 0;
    private Color borderColor1;
    private Color borderColor2;
    private Color borderColor3;
    private boolean inDispose = false;
    private Point oldSize;
    private Font oldFont;
    int insertionIndex = -2;
    private Shell tip;
    private Label label;
    private boolean showToolTip = false;
    private CTabItem toolTipItem;

    public CTabFolder(Composite parent, int style) {
        super(parent, CTabFolder.checkStyle(style));
        this.onBottom = (this.getStyle() & 0x400) != 0;
        this.borderColor1 = new Color((Device)this.getDisplay(), borderInsideRGB);
        this.borderColor2 = new Color((Device)this.getDisplay(), borderMiddleRGB);
        this.borderColor3 = new Color((Device)this.getDisplay(), borderOutsideRGB);
        this.tip = new Shell(this.getShell(), 16384);
        this.label = new Label((Composite)this.tip, 0x1000000);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        CTabFolder.this.onDispose();
                        break;
                    }
                    case 9: {
                        CTabFolder.this.onPaint(event);
                        break;
                    }
                    case 11: {
                        CTabFolder.this.onResize();
                        break;
                    }
                    case 8: {
                        CTabFolder.this.onMouseDoubleClick(event);
                        break;
                    }
                    case 3: {
                        CTabFolder.this.onMouseDown(event);
                        break;
                    }
                    case 7: {
                        CTabFolder.this.onMouseExit(event);
                        break;
                    }
                    case 32: {
                        CTabFolder.this.onMouseHover(event);
                        break;
                    }
                    case 5: {
                        CTabFolder.this.onMouseMove(event);
                        break;
                    }
                    case 15: {
                        CTabFolder.this.onFocus(event);
                        break;
                    }
                    case 16: {
                        CTabFolder.this.onFocus(event);
                        break;
                    }
                    case 1: {
                        CTabFolder.this.onKeyDown(event);
                        break;
                    }
                    case 31: {
                        CTabFolder.this.onTraverse(event);
                    }
                }
            }
        };
        int[] folderEvents = new int[]{12, 9, 11, 8, 3, 7, 32, 5, 15, 16, 1, 31};
        int i = 0;
        while (i < folderEvents.length) {
            this.addListener(folderEvents[i], listener);
            ++i;
        }
        this.createArrowBar();
        this.createCloseBar();
        this.setBorderVisible((style & 0x800) != 0);
        this.initAccessible();
    }

    private static int checkStyle(int style) {
        int mask = 109053056;
        if (((style &= mask) & 0x80) != 0) {
            style = style & 0xFFFFFB7F | 0x80;
        }
        return style |= 0x100000;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void addCTabFolderListener(CTabFolderListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        CTabFolderListener[] newTabListeners = new CTabFolderListener[this.tabListeners.length + 1];
        System.arraycopy(this.tabListeners, 0, newTabListeners, 0, this.tabListeners.length);
        this.tabListeners = newTabListeners;
        this.tabListeners[this.tabListeners.length - 1] = listener;
        this.showClose = true;
        this.setButtonBounds();
    }

    private void closeNotify(CTabItem item, int time) {
        if (item == null) {
            return;
        }
        CTabFolderEvent event = new CTabFolderEvent((Widget)this);
        event.widget = this;
        event.time = time;
        event.item = item;
        event.doit = true;
        if (this.tabListeners != null) {
            int i = 0;
            while (i < this.tabListeners.length) {
                this.tabListeners[i].itemClosed(event);
                ++i;
            }
        }
        if (event.doit) {
            item.dispose();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int minWidth = 0;
        int minHeight = 0;
        GC gc = new GC((Drawable)this);
        int i = 0;
        while (i < this.items.length) {
            minWidth += this.items[i].preferredWidth(gc);
            ++i;
        }
        gc.dispose();
        i = 0;
        while (i < this.items.length) {
            Control control = this.items[i].getControl();
            if (control != null && !control.isDisposed()) {
                Point size = control.computeSize(wHint, hHint);
                minWidth = Math.max(minWidth, size.x);
                minHeight = Math.max(minHeight, size.y);
            }
            ++i;
        }
        if (minWidth == 0) {
            minWidth = 64;
        }
        if (minHeight == 0) {
            minHeight = 64;
        }
        if (wHint != -1) {
            minWidth = wHint;
        }
        if (hHint != -1) {
            minHeight = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, minWidth, minHeight);
        return new Point(trim.width, trim.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        if (this.items.length == 0) {
            if (!this.showBorders) {
                return new Rectangle(x, y, width, height);
            }
            int trimX = x - this.borderRight - 1;
            int trimY = y - this.borderBottom - 1;
            int trimWidth = width + this.borderRight + 2;
            int trimHeight = height + this.borderBottom + 2;
            return new Rectangle(trimX, trimY, trimWidth, trimHeight);
        }
        int trimX = x - this.marginWidth - this.borderLeft;
        int trimY = y - this.marginHeight - this.tabHeight - this.borderTop - 1;
        if (this.onBottom) {
            trimY = y - this.marginHeight - this.borderTop;
        }
        int trimWidth = width + this.borderLeft + this.borderRight + 2 * this.marginWidth;
        int trimHeight = height + this.borderTop + this.borderBottom + 2 * this.marginHeight + this.tabHeight + 1;
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    void createItem(CTabItem item, int index) {
        if (index < 0 || index > this.getItemCount()) {
            SWT.error((int)6);
        }
        CTabItem[] newItems = new CTabItem[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        newItems[index] = item;
        System.arraycopy(this.items, index, newItems, index + 1, this.items.length - index);
        this.items = newItems;
        item.parent = this;
        if (this.selectedIndex >= index) {
            ++this.selectedIndex;
        }
        if (this.items.length == 1) {
            this.topTabIndex = 0;
            this.resetTabSize(true);
        } else {
            this.setItemBounds();
            this.showItem(item);
        }
        if (this.items.length == 1) {
            this.redraw();
        } else {
            this.redrawTabArea(-1);
        }
    }

    private void createArrowBar() {
        this.arrowBar = new ToolBar((Composite)this, 0x800000);
        this.arrowBar.setVisible(false);
        this.arrowBar.setBackground(this.background);
        ToolItem scrollLeft = new ToolItem(this.arrowBar, 8);
        scrollLeft.setEnabled(false);
        ToolItem scrollRight = new ToolItem(this.arrowBar, 8);
        scrollRight.setEnabled(false);
        scrollLeft.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CTabFolder.this.scroll_scrollLeft();
            }
        });
        scrollRight.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CTabFolder.this.scroll_scrollRight();
            }
        });
    }

    private void createCloseBar() {
        this.closeBar = new ToolBar((Composite)this, 0x800000);
        this.closeBar.setVisible(false);
        if (this.gradientColors != null && this.gradientColors.length > 0) {
            this.closeBar.setBackground(this.gradientColors[this.gradientColors.length - 1]);
        } else {
            this.closeBar.setBackground(this.background);
        }
        ToolItem closeItem = new ToolItem(this.closeBar, 8);
        this.inactiveCloseBar = new ToolBar((Composite)this, 0x800000);
        this.inactiveCloseBar.setVisible(false);
        this.inactiveCloseBar.setBackground(this.background);
        ToolItem inactiveCloseItem = new ToolItem(this.inactiveCloseBar, 8);
        closeItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CTabFolder.this.closeNotify(CTabFolder.this.getSelection(), event.time);
            }
        });
        inactiveCloseItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CTabFolder.this.closeNotify(CTabFolder.this.inactiveItem, event.time);
                CTabFolder.this.inactiveCloseBar.setVisible(false);
                CTabFolder.this.inactiveItem = null;
            }
        });
        this.inactiveCloseBar.addListener(7, new Listener(){

            public void handleEvent(Event event) {
                Rectangle itemBounds;
                if (CTabFolder.this.inactiveItem != null && (itemBounds = CTabFolder.this.inactiveItem.getBounds()).contains(event.x, event.y)) {
                    return;
                }
                CTabFolder.this.inactiveCloseBar.setVisible(false);
                CTabFolder.this.inactiveItem = null;
            }
        });
    }

    void destroyItem(CTabItem item) {
        if (this.inDispose) {
            return;
        }
        int index = this.indexOf(item);
        if (index == -1) {
            return;
        }
        this.insertionIndex = -2;
        if (this.items.length == 1) {
            this.items = new CTabItem[0];
            this.selectedIndex = -1;
            this.topTabIndex = 0;
            Control control = item.getControl();
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
            this.closeBar.setVisible(false);
            if (!this.fixedTabHeight) {
                this.tabHeight = 0;
            }
            this.redraw();
            return;
        }
        CTabItem[] newItems = new CTabItem[this.items.length - 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        System.arraycopy(this.items, index + 1, newItems, index, this.items.length - index - 1);
        this.items = newItems;
        if (this.topTabIndex == this.items.length) {
            --this.topTabIndex;
        }
        if (this.selectedIndex == index) {
            Control control = item.getControl();
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
            this.selectedIndex = -1;
            this.setSelection(Math.max(0, index - 1), true);
        } else if (this.selectedIndex > index) {
            --this.selectedIndex;
        }
        this.setItemBounds();
        this.redrawTabArea(-1);
    }

    private void onKeyDown(Event e) {
        int leadKey;
        if (e.keyCode != 0x1000003 && e.keyCode != 0x1000004) {
            return;
        }
        int n = leadKey = (this.getStyle() & 0x8000000) != 0 ? 0x1000004 : 0x1000003;
        if (e.keyCode == leadKey) {
            if (this.selectedIndex > 0) {
                this.setSelection(this.selectedIndex - 1, true);
            }
        } else if (this.selectedIndex < this.items.length - 1) {
            this.setSelection(this.selectedIndex + 1, true);
        }
    }

    private void onDispose() {
        this.inDispose = true;
        int length = this.items.length;
        int i = 0;
        while (i < length) {
            if (this.items[i] != null) {
                this.items[i].dispose();
            }
            ++i;
        }
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
            this.tip = null;
            this.label = null;
        }
        if (this.arrowLeftImage != null) {
            this.arrowLeftImage.dispose();
        }
        this.arrowLeftImage = null;
        if (this.arrowRightImage != null) {
            this.arrowRightImage.dispose();
        }
        this.arrowRightImage = null;
        if (this.closeImage != null) {
            this.closeImage.dispose();
        }
        this.closeImage = null;
        this.gradientColors = null;
        this.gradientPercents = null;
        this.backgroundImage = null;
        if (this.borderColor1 != null) {
            this.borderColor1.dispose();
        }
        this.borderColor1 = null;
        if (this.borderColor2 != null) {
            this.borderColor2.dispose();
        }
        this.borderColor2 = null;
        if (this.borderColor3 != null) {
            this.borderColor3.dispose();
        }
        this.borderColor3 = null;
    }

    private void onFocus(Event e) {
        this.checkWidget();
        if (this.selectedIndex >= 0) {
            this.redrawTabArea(this.selectedIndex);
        } else {
            this.setSelection(0, true);
        }
    }

    private void drawBorder(GC gc) {
        Rectangle d = super.getClientArea();
        if (this.showBorders) {
            if ((this.getStyle() & 0x800000) != 0) {
                gc.setForeground(this.borderColor1);
                gc.drawRectangle(d.x, d.y, d.x + d.width - 1, d.y + d.height - 1);
            } else {
                gc.setForeground(this.borderColor1);
                gc.drawRectangle(d.x, d.y, d.x + d.width - 3, d.y + d.height - 3);
                gc.setForeground(this.borderColor2);
                gc.drawLine(d.x + 1, d.y + d.height - 2, d.x + d.width - 1, d.y + d.height - 2);
                gc.drawLine(d.x + d.width - 2, d.y + 1, d.x + d.width - 2, d.y + d.height - 1);
                gc.setForeground(this.borderColor3);
                gc.drawLine(d.x + 2, d.y + d.height - 1, d.x + d.width - 2, d.y + d.height - 1);
                gc.drawLine(d.x + d.width - 1, d.y + 2, d.x + d.width - 1, d.y + d.height - 2);
                gc.setForeground(this.getParent().getBackground());
                gc.drawLine(d.x + d.width - 2, d.y, d.x + d.width - 1, d.y);
                gc.drawLine(d.x + d.width - 1, d.y + 1, d.x + d.width - 1, d.y + 1);
                gc.drawLine(d.x, d.y + d.height - 2, d.x, d.y + d.height - 2);
                gc.drawLine(d.x, d.y + d.height - 1, d.x + 1, d.y + d.height - 1);
                gc.drawLine(d.x + d.width - 1, d.y + d.height - 1, d.x + d.width - 1, d.y + d.height - 1);
            }
        }
        if (this.items.length > 0) {
            int lineY = d.y + this.borderTop + this.tabHeight;
            if (this.onBottom) {
                lineY = d.y + d.height - this.borderBottom - this.tabHeight - 1;
            }
            gc.setForeground(this.borderColor1);
            gc.drawLine(d.x + this.borderLeft, lineY, d.x + d.width - this.borderRight, lineY);
        }
        gc.setForeground(this.getForeground());
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Point size = this.getSize();
        if (this.items.length == 0) {
            if (!this.showBorders) {
                return super.getClientArea();
            }
            int width = size.x - this.borderRight - 2;
            int height = size.y - this.borderBottom - 2;
            return new Rectangle(this.borderRight + 1, this.borderBottom + 1, width, height);
        }
        int width = size.x - 2 * this.marginWidth - this.borderLeft - this.borderRight;
        int height = size.y - 2 * this.marginHeight - this.borderTop - this.borderBottom - this.tabHeight - 1;
        return new Rectangle(this.xClient, this.yClient, width, height);
    }

    public int getTabHeight() {
        this.checkWidget();
        return this.tabHeight;
    }

    public CTabItem getItem(int index) {
        if (index < 0 || index >= this.items.length) {
            SWT.error((int)6);
        }
        return this.items[index];
    }

    public CTabItem getItem(Point pt) {
        if (this.items.length == 0) {
            return null;
        }
        int lastItem = this.getLastItem();
        lastItem = Math.min(this.items.length - 1, lastItem + 1);
        int i = this.topTabIndex;
        while (i <= lastItem) {
            Rectangle bounds = this.items[i].getBounds();
            if (bounds.contains(pt)) {
                return this.items[i];
            }
            ++i;
        }
        return null;
    }

    public int getItemCount() {
        return this.items.length;
    }

    public CTabItem[] getItems() {
        CTabItem[] tabItems = new CTabItem[this.items.length];
        System.arraycopy(this.items, 0, tabItems, 0, this.items.length);
        return tabItems;
    }

    private int getLastItem() {
        if (this.items.length == 0) {
            return -1;
        }
        Rectangle area = this.getClientArea();
        if (area.width <= 0) {
            return 0;
        }
        Rectangle toolspace = this.getToolSpace();
        if (toolspace.width == 0) {
            return this.items.length - 1;
        }
        int width = area.width - toolspace.width;
        int index = this.topTabIndex;
        int tabWidth = this.items[index].width;
        while (index < this.items.length - 1) {
            if ((tabWidth += this.items[index + 1].width) > width) break;
            ++index;
        }
        return index;
    }

    public CTabItem getSelection() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.items[this.selectedIndex];
    }

    public int getSelectionIndex() {
        return this.selectedIndex;
    }

    private Rectangle getToolSpace() {
        Rectangle toolspace;
        boolean showArrows;
        boolean bl = showArrows = this.scroll_leftVisible() || this.scroll_rightVisible();
        if (!showArrows && this.topRight == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (showArrows) {
            toolspace = this.arrowBar.getBounds();
            toolspace.width += this.borderRight;
            if (this.topRight != null) {
                toolspace.width += this.topRight.getSize().x;
            }
        } else {
            toolspace = this.topRight.getBounds();
            toolspace.width += this.borderRight;
        }
        return toolspace;
    }

    public Control getTopRight() {
        this.checkWidget();
        return this.topRight;
    }

    public int indexOf(CTabItem item) {
        if (item == null) {
            SWT.error((int)4);
        }
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void initAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                int index;
                String name = null;
                int childID = e.childID;
                if (childID >= 0 && childID < CTabFolder.this.items.length && (index = (name = CTabFolder.this.items[childID].getText()).indexOf(38)) > 0) {
                    name = String.valueOf(name.substring(0, index)) + name.substring(index + 1);
                }
                e.result = name;
            }

            public void getHelp(AccessibleEvent e) {
                String help = null;
                int childID = e.childID;
                if (childID == -1) {
                    help = CTabFolder.this.getToolTipText();
                } else if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    help = CTabFolder.this.items[childID].getToolTipText();
                }
                e.result = help;
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                char mnemonic;
                String text;
                String shortcut = null;
                int childID = e.childID;
                if (childID >= 0 && childID < CTabFolder.this.items.length && (text = CTabFolder.this.items[childID].getText()) != null && (mnemonic = CTabFolder.this.getMnemonic(text)) != '\u0000') {
                    shortcut = "Alt+" + mnemonic;
                }
                e.result = shortcut;
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = CTabFolder.this.toControl(new Point(e.x, e.y));
                int childID = -2;
                int i = 0;
                while (i < CTabFolder.this.items.length) {
                    if (CTabFolder.this.items[i].getBounds().contains(testPoint)) {
                        childID = i;
                        break;
                    }
                    ++i;
                }
                if (childID == -2) {
                    Rectangle location = CTabFolder.this.getBounds();
                    location.height -= CTabFolder.this.getClientArea().height;
                    if (location.contains(testPoint)) {
                        childID = -1;
                    }
                }
                e.childID = childID;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = null;
                int childID = e.childID;
                if (childID == -1) {
                    location = CTabFolder.this.getBounds();
                }
                if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    location = CTabFolder.this.items[childID].getBounds();
                }
                if (location != null) {
                    Point pt = CTabFolder.this.toDisplay(new Point(location.x, location.y));
                    e.x = pt.x;
                    e.y = pt.y;
                    e.width = location.width;
                    e.height = location.height;
                }
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = CTabFolder.this.items.length;
            }

            public void getDefaultAction(AccessibleControlEvent e) {
                String action = null;
                int childID = e.childID;
                if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    action = "Switch";
                }
                e.result = action;
            }

            public void getFocus(AccessibleControlEvent e) {
                int childID = -2;
                if (CTabFolder.this.isFocusControl()) {
                    childID = CTabFolder.this.selectedIndex == -1 ? -1 : CTabFolder.this.selectedIndex;
                }
                e.childID = childID;
            }

            public void getRole(AccessibleControlEvent e) {
                int role = 0;
                int childID = e.childID;
                if (childID == -1) {
                    role = 60;
                } else if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    role = 37;
                }
                e.detail = role;
            }

            public void getSelection(AccessibleControlEvent e) {
                e.childID = CTabFolder.this.selectedIndex == -1 ? -2 : CTabFolder.this.selectedIndex;
            }

            public void getState(AccessibleControlEvent e) {
                int state = 0;
                int childID = e.childID;
                if (childID == -1) {
                    state = 0;
                } else if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    state = 0x200000;
                    if (CTabFolder.this.isFocusControl()) {
                        state |= 0x100000;
                    }
                    if (CTabFolder.this.selectedIndex == childID) {
                        state |= 2;
                        if (CTabFolder.this.isFocusControl()) {
                            state |= 4;
                        }
                    }
                }
                e.detail = state;
            }

            public void getChildren(AccessibleControlEvent e) {
                Object[] children = new Object[CTabFolder.this.items.length];
                int i = 0;
                while (i < CTabFolder.this.items.length) {
                    children[i] = new Integer(i);
                    ++i;
                }
                e.children = children;
            }
        });
        this.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (CTabFolder.this.isFocusControl()) {
                    if (CTabFolder.this.selectedIndex == -1) {
                        accessible.setFocus(-1);
                    } else {
                        accessible.setFocus(CTabFolder.this.selectedIndex);
                    }
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                if (CTabFolder.this.selectedIndex == -1) {
                    accessible.setFocus(-1);
                } else {
                    accessible.setFocus(CTabFolder.this.selectedIndex);
                }
            }
        });
    }

    private void setButtonBounds() {
        this.updateArrowBar();
        this.updateCloseBar();
        Rectangle area = super.getClientArea();
        int offset = 0;
        if (this.topRight != null) {
            Point size = this.topRight.computeSize(-1, this.tabHeight);
            int x = area.x + area.width - this.borderRight - size.x;
            int y = this.onBottom ? area.y + area.height - this.borderBottom - size.y : area.y + this.borderTop;
            this.topRight.setBounds(x, y, size.x, size.y);
            offset = size.x;
        }
        boolean leftVisible = this.scroll_leftVisible();
        boolean rightVisible = this.scroll_rightVisible();
        if (leftVisible || rightVisible) {
            Point size = this.arrowBar.computeSize(-1, this.tabHeight);
            int x = area.x + area.width - this.borderRight - size.x - offset;
            int y = this.onBottom ? area.y + area.height - this.borderBottom - size.y : area.y + this.borderTop;
            this.arrowBar.setBounds(x, y, size.x, size.y);
            ToolItem[] items = this.arrowBar.getItems();
            items[0].setEnabled(leftVisible);
            items[1].setEnabled(rightVisible);
            this.arrowBar.setVisible(true);
        } else {
            this.arrowBar.setVisible(false);
        }
        if (this.showClose) {
            this.inactiveCloseBar.setVisible(false);
            CTabItem item = this.getSelection();
            if (item == null) {
                this.closeBar.setVisible(false);
            } else {
                int toolbarHeight = this.tabHeight - 3 - 3 + 2;
                Point size = this.closeBar.computeSize(-1, toolbarHeight);
                int x = item.x + item.width - size.x - 2;
                int y = item.y + Math.max(0, (item.height - toolbarHeight) / 2);
                this.closeBar.setBounds(x, y, size.x, toolbarHeight);
                Rectangle toolspace = this.getToolSpace();
                Point folderSize = this.getSize();
                boolean visible = (toolspace.width == 0 || x < toolspace.x) && x + size.x < folderSize.x - this.borderRight;
                this.closeBar.setVisible(visible);
            }
        }
    }

    private boolean setItemLocation() {
        CTabItem tab;
        if (this.items.length == 0) {
            return false;
        }
        Rectangle area = super.getClientArea();
        int x = area.x;
        int y = area.y + this.borderTop;
        if (this.onBottom) {
            y = Math.max(0, area.y + area.height - this.borderBottom - this.tabHeight);
        }
        boolean changed = false;
        int i = this.topTabIndex - 1;
        while (i >= 0) {
            tab = this.items[i];
            if (!(changed || tab.x == (x -= tab.width) && tab.y == y)) {
                changed = true;
            }
            tab.x = x;
            tab.y = y;
            --i;
        }
        x = area.x + this.borderLeft;
        i = this.topTabIndex;
        while (i < this.items.length) {
            tab = this.items[i];
            tab.x = x;
            tab.y = y;
            x += tab.width;
            ++i;
        }
        this.setButtonBounds();
        return changed;
    }

    private void setLastItem(int index) {
        if (index < 0 || index > this.items.length - 1) {
            return;
        }
        Rectangle area = this.getClientArea();
        if (area.width <= 0) {
            return;
        }
        int maxWidth = area.width;
        Rectangle toolspace = this.getToolSpace();
        if (toolspace.width > 0) {
            maxWidth -= toolspace.width;
        }
        int tabWidth = this.items[index].width;
        while (index > 0) {
            if ((tabWidth += this.items[index - 1].width) > maxWidth) break;
            --index;
        }
        this.topTabIndex = index;
        this.setItemLocation();
        this.redrawTabArea(-1);
    }

    boolean setItemBounds() {
        boolean changed = false;
        if (this.isDisposed()) {
            return changed;
        }
        Rectangle area = super.getClientArea();
        this.xClient = area.x + this.borderLeft + this.marginWidth;
        this.yClient = this.onBottom ? area.y + this.borderTop + this.marginHeight : area.y + this.borderTop + this.tabHeight + 1 + this.marginHeight;
        if (area.width <= 0 || area.height <= 0 || this.items.length == 0) {
            return changed;
        }
        int[] widths = new int[this.items.length];
        GC gc = new GC((Drawable)this);
        int i = 0;
        while (i < this.items.length) {
            widths[i] = this.items[i].preferredWidth(gc);
            ++i;
        }
        gc.dispose();
        int oldAverageWidth = 0;
        int averageWidth = (area.width - this.borderLeft - this.borderRight) / this.items.length;
        while (averageWidth > oldAverageWidth) {
            int width = area.width - this.borderLeft - this.borderRight;
            int count = this.items.length;
            int i2 = 0;
            while (i2 < this.items.length) {
                if (widths[i2] < averageWidth) {
                    width -= widths[i2];
                    --count;
                }
                ++i2;
            }
            oldAverageWidth = averageWidth;
            if (count <= 0) continue;
            averageWidth = width / count;
        }
        averageWidth = Math.max(averageWidth, this.MIN_TAB_WIDTH * this.tabHeight);
        int i3 = 0;
        while (i3 < this.items.length) {
            if (widths[i3] > averageWidth) {
                widths[i3] = averageWidth;
            }
            ++i3;
        }
        int totalWidth = 0;
        int i4 = 0;
        while (i4 < this.items.length) {
            CTabItem tab = this.items[i4];
            if (tab.height != this.tabHeight || tab.width != widths[i4]) {
                changed = true;
            }
            tab.height = this.tabHeight;
            tab.width = widths[i4];
            totalWidth += widths[i4];
            ++i4;
        }
        int areaWidth = area.x + area.width - this.borderRight;
        if (totalWidth <= areaWidth) {
            this.topTabIndex = 0;
        }
        if (this.setItemLocation()) {
            changed = true;
        }
        if (this.correctLastItem()) {
            changed = true;
        }
        return changed;
    }

    private boolean onMnemonic(Event event) {
        char key = event.character;
        int i = 0;
        while (i < this.items.length) {
            char mnemonic;
            if (this.items[i] != null && (mnemonic = this.getMnemonic(this.items[i].getText())) != '\u0000' && Character.toUpperCase(key) == Character.toUpperCase(mnemonic)) {
                this.setSelection(i, true);
                return true;
            }
            ++i;
        }
        return false;
    }

    private void onPaint(Event event) {
        Font font = this.getFont();
        if (this.oldFont == null || !this.oldFont.equals((Object)font)) {
            this.oldFont = font;
            this.resetTabSize(true);
        }
        GC gc = event.gc;
        Rectangle rect = super.getClientArea();
        if (this.items.length == 0) {
            if (this.showBorders) {
                if ((this.getStyle() & 0x800000) != 0) {
                    gc.setForeground(this.borderColor1);
                    gc.drawRectangle(rect.x, rect.y, rect.x + rect.width - 1, rect.y + rect.height - 1);
                } else {
                    gc.setForeground(this.borderColor1);
                    gc.drawRectangle(rect.x, rect.y, rect.x + rect.width - 3, rect.y + rect.height - 3);
                    gc.setBackground(this.getParent().getBackground());
                    gc.fillRectangle(rect.x + rect.width - 2, rect.y, 2, rect.height);
                    gc.fillRectangle(rect.x, rect.y + rect.height - 2, rect.width, 2);
                }
                gc.setForeground(this.getForeground());
            }
            return;
        }
        this.drawBorder(gc);
        rect.x += this.borderLeft;
        rect.y += this.borderTop;
        rect.width -= this.borderLeft + this.borderRight;
        rect.height -= this.borderTop + this.borderBottom;
        Rectangle clip = gc.getClipping();
        gc.setClipping(clip.intersection(rect));
        int i = 0;
        while (i < this.items.length) {
            if (i != this.selectedIndex && event.getBounds().intersects(this.items[i].getBounds())) {
                this.items[i].onPaint(gc, false);
            }
            ++i;
        }
        if (this.selectedIndex != -1) {
            this.items[this.selectedIndex].onPaint(gc, true);
        }
        if (this.insertionIndex > -2) {
            gc.setForeground(this.getDisplay().getSystemColor(26));
            if (this.insertionIndex == -1) {
                Rectangle bounds = this.items[0].getBounds();
                gc.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height - 1);
                gc.drawLine(bounds.x - 2, bounds.y, bounds.x + 2, bounds.y);
                gc.drawLine(bounds.x - 1, bounds.y + 1, bounds.x + 1, bounds.y + 1);
                gc.drawLine(bounds.x - 1, bounds.y + bounds.height - 2, bounds.x + 1, bounds.y + bounds.height - 2);
                gc.drawLine(bounds.x - 2, bounds.y + bounds.height - 1, bounds.x + 2, bounds.y + bounds.height - 1);
            } else {
                Rectangle bounds = this.items[this.insertionIndex].getBounds();
                gc.drawLine(bounds.x + bounds.width, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height - 1);
                gc.drawLine(bounds.x + bounds.width - 2, bounds.y, bounds.x + bounds.width + 2, bounds.y);
                gc.drawLine(bounds.x + bounds.width - 1, bounds.y + 1, bounds.x + bounds.width + 1, bounds.y + 1);
                gc.drawLine(bounds.x + bounds.width - 1, bounds.y + bounds.height - 2, bounds.x + bounds.width + 1, bounds.y + bounds.height - 2);
                gc.drawLine(bounds.x + bounds.width - 2, bounds.y + bounds.height - 1, bounds.x + bounds.width + 2, bounds.y + bounds.height - 1);
            }
        }
        gc.setForeground(this.getForeground());
        gc.setBackground(this.getBackground());
    }

    private void redrawTabArea(int index) {
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        if (index == -1) {
            Rectangle area = super.getClientArea();
            if (area.width == 0 || area.height == 0) {
                return;
            }
            width = area.x + area.width - this.borderLeft - this.borderRight;
            height = this.tabHeight + 1;
            x = area.x + this.borderLeft;
            y = area.y + this.borderTop;
            if (this.onBottom) {
                y = Math.max(0, area.y + area.height - this.borderBottom - height);
            }
        } else {
            CTabItem item = this.items[index];
            x = item.x;
            y = item.y;
            Rectangle area = super.getClientArea();
            width = area.x + area.width - x;
            height = item.height;
        }
        this.redraw(x, y, width, height, false);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void removeCTabFolderListener(CTabFolderListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        if (this.tabListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.tabListeners.length) {
            if (listener == this.tabListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.tabListeners.length == 1) {
            this.tabListeners = new CTabFolderListener[0];
            this.showClose = false;
            this.setButtonBounds();
            return;
        }
        CTabFolderListener[] newTabListeners = new CTabFolderListener[this.tabListeners.length - 1];
        System.arraycopy(this.tabListeners, 0, newTabListeners, 0, index);
        System.arraycopy(this.tabListeners, index + 1, newTabListeners, index, this.tabListeners.length - index - 1);
        this.tabListeners = newTabListeners;
    }

    private void onResize() {
        Control control;
        if (this.items.length == 0) {
            this.redraw();
            return;
        }
        if (this.setItemBounds()) {
            this.redrawTabArea(-1);
        }
        Point size = this.getSize();
        if (this.oldSize == null) {
            this.redraw();
        } else if (this.onBottom && size.y != this.oldSize.y) {
            this.redraw();
        } else {
            int x1 = Math.min(size.x, this.oldSize.x);
            if (size.x != this.oldSize.x) {
                x1 -= 10;
            }
            int y1 = Math.min(size.y, this.oldSize.y);
            if (size.y != this.oldSize.y) {
                y1 -= 10;
            }
            int x2 = Math.max(size.x, this.oldSize.x);
            int y2 = Math.max(size.y, this.oldSize.y);
            this.redraw(0, y1, x2 + 10, y2 - y1, false);
            this.redraw(x1, 0, x2 - x1, y2, false);
        }
        this.oldSize = size;
        if (this.selectedIndex != -1 && (control = this.items[this.selectedIndex].getControl()) != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.background = color;
        this.inactiveCloseBar.setBackground(color);
        this.arrowBar.setBackground(color);
        if (this.topRight != null) {
            this.topRight.setBackground(color);
        }
        if (this.gradientColors == null) {
            this.closeBar.setBackground(color);
        }
    }

    public void setSelectionBackground(Color[] colors, int[] percents) {
        int i;
        this.checkWidget();
        if (colors != null) {
            if (percents == null || percents.length != colors.length - 1) {
                SWT.error((int)5);
            }
            if (this.getDisplay().getDepth() < 15) {
                colors = new Color[]{colors[0]};
                percents = new int[]{};
            }
            i = 0;
            while (i < percents.length) {
                if (percents[i] < 0 || percents[i] > 100) {
                    SWT.error((int)5);
                }
                if (i > 0 && percents[i] < percents[i - 1]) {
                    SWT.error((int)5);
                }
                ++i;
            }
        }
        if (this.backgroundImage == null) {
            if (this.gradientColors != null && colors != null && this.gradientColors.length == colors.length) {
                boolean same = false;
                int i2 = 0;
                while (i2 < this.gradientColors.length) {
                    same = this.gradientColors[i2] == null ? colors[i2] == null : this.gradientColors[i2].equals((Object)colors[i2]);
                    if (!same) break;
                    ++i2;
                }
                if (same) {
                    i2 = 0;
                    while (i2 < this.gradientPercents.length) {
                        boolean bl = same = this.gradientPercents[i2] == percents[i2];
                        if (!same) break;
                        ++i2;
                    }
                }
                if (same) {
                    return;
                }
            }
        } else {
            this.backgroundImage = null;
        }
        if (colors == null) {
            this.gradientColors = null;
            this.gradientPercents = null;
            this.closeBar.setBackground(this.background);
        } else {
            this.gradientColors = new Color[colors.length];
            i = 0;
            while (i < colors.length) {
                this.gradientColors[i] = colors[i];
                ++i;
            }
            this.gradientPercents = new int[percents.length];
            i = 0;
            while (i < percents.length) {
                this.gradientPercents[i] = percents[i];
                ++i;
            }
            if (this.getDisplay().getDepth() < 15) {
                this.closeBar.setBackground(this.background);
            } else {
                this.closeBar.setBackground(this.gradientColors[this.gradientColors.length - 1]);
            }
        }
        if (this.selectedIndex > -1) {
            this.redrawTabArea(this.selectedIndex);
        }
    }

    public void setSelectionBackground(Image image) {
        this.checkWidget();
        if (image == this.backgroundImage) {
            return;
        }
        if (image != null) {
            this.gradientColors = null;
            this.gradientPercents = null;
        }
        this.backgroundImage = image;
        this.redrawTabArea(this.selectedIndex);
    }

    public void setBorderVisible(boolean show) {
        this.checkWidget();
        this.showBorders = show;
        if (this.showBorders) {
            if ((this.getStyle() & 0x800000) != 0) {
                this.borderRight = 1;
                this.borderLeft = 1;
                this.borderTop = 1;
                this.borderBottom = 1;
            } else {
                this.borderTop = 1;
                this.borderLeft = 1;
                this.borderBottom = 3;
                this.borderRight = 3;
            }
        } else {
            this.borderRight = 0;
            this.borderLeft = 0;
            this.borderTop = 0;
            this.borderBottom = 0;
        }
        this.oldSize = null;
        this.notifyListeners(11, new Event());
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.equals((Object)this.getFont())) {
            return;
        }
        super.setFont(font);
        this.oldFont = this.getFont();
        this.resetTabSize(true);
    }

    public void setSelectionForeground(Color color) {
        this.checkWidget();
        if (this.selectionForeground == color) {
            return;
        }
        if (color == null) {
            color = this.getForeground();
        }
        this.selectionForeground = color;
        if (this.selectedIndex > -1) {
            this.redrawTabArea(this.selectedIndex);
        }
    }

    public void setInsertMark(CTabItem item, boolean after) {
        this.checkWidget();
        int index = -1;
        if (item != null) {
            index = this.indexOf(item);
        }
        this.setInsertMark(index, after);
    }

    public void setInsertMark(int index, boolean after) {
        this.checkWidget();
        if (index < -1 || index >= this.getItemCount()) {
            SWT.error((int)5);
        }
        if (index == -1) {
            index = -2;
        } else {
            int n = index = after ? index : --index;
        }
        if (this.insertionIndex == index) {
            return;
        }
        int oldIndex = this.insertionIndex;
        this.insertionIndex = index;
        if (index > -1) {
            this.redrawTabArea(index);
        }
        if (oldIndex > 1) {
            this.redrawTabArea(oldIndex);
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            return;
        }
        if (this.selectedIndex == index) {
            return;
        }
        int oldIndex = this.selectedIndex;
        this.selectedIndex = index;
        Control control = this.items[index].control;
        if (control != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
            control.setVisible(true);
        }
        if (oldIndex != -1 && (control = this.items[oldIndex].control) != null && !control.isDisposed()) {
            control.setVisible(false);
        }
        this.showItem(this.items[this.selectedIndex]);
        this.setButtonBounds();
        this.redrawTabArea(-1);
    }

    public void setTopRight(Control control) {
        this.checkWidget();
        if (control != null && control.getParent() != this) {
            SWT.error((int)5);
        }
        this.topRight = control;
        this.resetTabSize(true);
    }

    public void showItem(CTabItem item) {
        int index;
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        if (item.isDisposed()) {
            SWT.error((int)5);
        }
        if ((index = this.indexOf(item)) < this.topTabIndex) {
            this.topTabIndex = index;
            this.setItemLocation();
            this.redrawTabArea(-1);
            return;
        }
        Rectangle area = this.getClientArea();
        if (area.width <= 0) {
            this.topTabIndex = index;
            return;
        }
        int rightEdge = area.x + area.width;
        Rectangle rect = this.getToolSpace();
        if (rect.width > 0) {
            rightEdge -= rect.width;
        }
        if (item.x + item.width < rightEdge) {
            return;
        }
        this.setLastItem(index);
    }

    public void showSelection() {
        this.checkWidget();
        if (this.selectedIndex != -1) {
            this.showItem(this.getSelection());
        }
    }

    char getMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return string.charAt(index);
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    public void setSelection(CTabItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        int index = this.indexOf(item);
        this.setSelection(index);
    }

    private void setSelection(int index, boolean notify) {
        int oldSelectedIndex = this.selectedIndex;
        this.setSelection(index);
        if (notify && this.selectedIndex != oldSelectedIndex && this.selectedIndex != -1) {
            Event event = new Event();
            event.item = this.getItem(this.selectedIndex);
            this.notifyListeners(13, event);
        }
    }

    private Image scaleImage(Image image, int oldSize, int newSize) {
        Display display = this.getDisplay();
        Color foreground = this.getForeground();
        Color black = display.getSystemColor(2);
        Color background = this.getBackground();
        PaletteData palette = new PaletteData(new RGB[]{foreground.getRGB(), background.getRGB(), black.getRGB()});
        ImageData imageData = new ImageData(newSize, newSize, 4, palette);
        imageData.transparentPixel = 1;
        Image temp = new Image((Device)display, imageData);
        GC gc = new GC((Drawable)temp);
        gc.setBackground(background);
        gc.fillRectangle(0, 0, newSize, newSize);
        gc.drawImage(image, 0, 0, oldSize, oldSize, 0, 0, newSize, newSize);
        gc.dispose();
        return temp;
    }

    private void updateCloseBar() {
        int imageHeight;
        int maxHeight;
        int toolbarTrim = 4;
        if (Util.isPhoton()) {
            toolbarTrim = 6;
        }
        if (Util.isGtk()) {
            toolbarTrim = 8;
        }
        if ((maxHeight = this.tabHeight - 3 - 3 - toolbarTrim) < 3) {
            return;
        }
        int n = imageHeight = maxHeight < 9 ? 9 : maxHeight;
        if (this.closeImage != null && this.closeImage.getBounds().height == imageHeight) {
            return;
        }
        if (this.closeBar != null) {
            this.closeBar.dispose();
        }
        this.closeBar = null;
        if (this.inactiveCloseBar != null) {
            this.inactiveCloseBar.dispose();
        }
        this.inactiveCloseBar = null;
        this.createCloseBar();
        ToolItem closeItem = this.closeBar.getItems()[0];
        ToolItem inactiveCloseItem = this.inactiveCloseBar.getItems()[0];
        if (this.closeImage != null) {
            this.closeImage.dispose();
        }
        Display display = this.getDisplay();
        Color foreground = this.getForeground();
        Color black = display.getSystemColor(2);
        Color background = this.getBackground();
        PaletteData palette = new PaletteData(new RGB[]{foreground.getRGB(), background.getRGB(), black.getRGB()});
        ImageData imageData = new ImageData(imageHeight, imageHeight, 4, palette);
        imageData.transparentPixel = 1;
        this.closeImage = new Image((Device)display, imageData);
        GC gc = new GC((Drawable)this.closeImage);
        gc.setBackground(background);
        gc.fillRectangle(0, 0, imageHeight, imageHeight);
        gc.setForeground(black);
        int h = imageHeight / 2 * 2;
        int inset = (h - 8) / 2;
        gc.drawLine(inset, inset, h - inset - 1, h - inset - 1);
        gc.drawLine(inset + 1, inset, h - inset, h - inset - 1);
        gc.drawLine(inset, h - inset - 1, h - inset - 1, inset);
        gc.drawLine(inset + 1, h - inset - 1, h - inset, inset);
        gc.dispose();
        if (maxHeight < imageHeight) {
            Image temp = this.scaleImage(this.closeImage, imageHeight, maxHeight);
            this.closeImage.dispose();
            this.closeImage = temp;
        }
        closeItem.setImage(this.closeImage);
        inactiveCloseItem.setImage(this.closeImage);
    }

    private void updateArrowBar() {
        int imageHeight;
        int maxHeight;
        int toolbarTrim = 6;
        if (Util.isGtk()) {
            toolbarTrim = 8;
        }
        if ((maxHeight = this.tabHeight - toolbarTrim) < 3) {
            return;
        }
        int n = imageHeight = maxHeight < 9 ? 9 : maxHeight;
        if (this.arrowLeftImage != null && this.arrowLeftImage.getBounds().height == imageHeight) {
            return;
        }
        if (this.arrowBar != null) {
            this.arrowBar.dispose();
        }
        this.arrowBar = null;
        if (this.arrowLeftImage != null) {
            this.arrowLeftImage.dispose();
        }
        if (this.arrowRightImage != null) {
            this.arrowRightImage.dispose();
        }
        this.createArrowBar();
        ToolItem[] items = this.arrowBar.getItems();
        ToolItem left = items[0];
        ToolItem right = items[1];
        Display display = this.getDisplay();
        Color foreground = this.getForeground();
        Color black = display.getSystemColor(2);
        Color background = this.getBackground();
        PaletteData palette = new PaletteData(new RGB[]{foreground.getRGB(), background.getRGB(), black.getRGB()});
        ImageData imageData = new ImageData(7, imageHeight, 4, palette);
        imageData.transparentPixel = 1;
        this.arrowLeftImage = new Image((Device)display, imageData);
        GC gc = new GC((Drawable)this.arrowLeftImage);
        gc.setBackground(background);
        gc.fillRectangle(0, 0, 7, imageHeight);
        gc.setBackground(black);
        int h = imageHeight / 2 * 2;
        int midpoint = h / 2 - 1;
        int[] pointArr = new int[]{6, midpoint - 5, 1, midpoint, 6, midpoint + 5};
        gc.fillPolygon(pointArr);
        gc.dispose();
        palette = new PaletteData(new RGB[]{foreground.getRGB(), background.getRGB(), black.getRGB()});
        imageData = new ImageData(7, imageHeight, 4, palette);
        imageData.transparentPixel = 1;
        this.arrowRightImage = new Image((Device)display, imageData);
        gc = new GC((Drawable)this.arrowRightImage);
        gc.setBackground(background);
        gc.fillRectangle(0, 0, 7, imageHeight);
        gc.setBackground(black);
        pointArr = new int[]{1, midpoint - 5, 6, midpoint, 1, midpoint + 5};
        gc.fillPolygon(pointArr);
        gc.dispose();
        if (maxHeight < imageHeight) {
            Image leftTemp = this.scaleImage(this.arrowLeftImage, imageHeight, maxHeight);
            this.arrowLeftImage.dispose();
            this.arrowLeftImage = leftTemp;
            Image rightTemp = this.scaleImage(this.arrowRightImage, imageHeight, maxHeight);
            this.arrowRightImage.dispose();
            this.arrowRightImage = rightTemp;
        }
        left.setImage(this.arrowLeftImage);
        right.setImage(this.arrowRightImage);
    }

    private void onMouseDoubleClick(Event event) {
        Event e = new Event();
        e.item = this.getItem(new Point(event.x, event.y));
        this.notifyListeners(14, e);
    }

    private void onMouseDown(Event event) {
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i].getBounds().contains(new Point(event.x, event.y))) {
                if (i == this.selectedIndex) {
                    this.showSelection();
                    return;
                }
                this.forceFocus();
                this.setSelection(i, true);
                if (this.isFocusControl()) {
                    this.setFocus();
                }
                return;
            }
            ++i;
        }
    }

    private void onMouseExit(Event event) {
        Rectangle inactiveBounds = this.inactiveCloseBar.getBounds();
        if (inactiveBounds.contains(event.x, event.y)) {
            return;
        }
        this.inactiveCloseBar.setVisible(false);
        this.inactiveItem = null;
        this.showToolTip = false;
        this.toolTipItem = null;
        if (this.tip != null && !this.tip.isDisposed() && this.tip.isVisible()) {
            this.tip.setVisible(false);
        }
    }

    private void onMouseHover(Event event) {
        if (this.tip == null || this.tip.isDisposed()) {
            return;
        }
        this.showToolTip = true;
        this.showToolTip(event.x, event.y);
    }

    private void showToolTip(int x, int y) {
        CTabItem item = this.getItem(new Point(x, y));
        if (item != null) {
            if (item == this.toolTipItem) {
                return;
            }
            this.toolTipItem = item;
            String tooltip = item.getToolTipText();
            if (tooltip != null && tooltip.length() > 0) {
                Display display = this.tip.getDisplay();
                this.label.setForeground(display.getSystemColor(28));
                this.label.setBackground(display.getSystemColor(29));
                this.label.setText(tooltip);
                Point labelSize = this.label.computeSize(-1, -1);
                labelSize.x += 2;
                labelSize.y += 2;
                this.label.setSize(labelSize);
                this.tip.pack();
                Rectangle area = this.tip.getClientArea();
                this.label.setSize(area.width, area.height);
                Point pt = new Point(item.x + item.width / 4, item.y + item.height + 2);
                pt = this.toDisplay(pt);
                Rectangle rect = display.getBounds();
                Point tipSize = this.tip.getSize();
                pt.x = Math.max(0, Math.min(pt.x, rect.width - tipSize.x));
                pt.y = Math.max(0, Math.min(pt.y, rect.height - tipSize.y));
                this.tip.setLocation(pt);
                this.tip.setVisible(true);
                return;
            }
        }
        this.toolTipItem = null;
        if (this.tip != null && !this.tip.isDisposed() && this.tip.isVisible()) {
            this.tip.setVisible(false);
        }
    }

    private void onMouseMove(Event event) {
        if (this.showToolTip) {
            this.showToolTip(event.x, event.y);
        }
        if (!this.showClose) {
            return;
        }
        CTabItem item = null;
        int i = 0;
        while (i < this.items.length) {
            Rectangle rect = this.items[i].getBounds();
            if (rect.contains(new Point(event.x, event.y))) {
                item = this.items[i];
                break;
            }
            ++i;
        }
        if (item == this.inactiveItem) {
            return;
        }
        this.inactiveCloseBar.setVisible(false);
        this.inactiveItem = null;
        if (item == null || item == this.getSelection()) {
            return;
        }
        int toolbarHeight = this.tabHeight - 3 - 3 + 2;
        Point size = this.inactiveCloseBar.computeSize(-1, toolbarHeight);
        int x = item.x + item.width - size.x - 2;
        int y = item.y + Math.max(0, (item.height - toolbarHeight) / 2);
        Rectangle toolspace = this.getToolSpace();
        Point folderSize = this.getSize();
        if ((toolspace.width == 0 || x < toolspace.x) && x + size.x < folderSize.x - this.borderRight) {
            this.inactiveCloseBar.setBounds(x, y, size.x, toolbarHeight);
            this.inactiveCloseBar.setVisible(true);
            this.inactiveItem = item;
        }
    }

    private void onTraverse(Event event) {
        switch (event.detail) {
            case 2: 
            case 8: 
            case 16: {
                event.doit = true;
                break;
            }
            case 128: {
                event.doit = this.onMnemonic(event);
                if (!event.doit) break;
                event.detail = 0;
                break;
            }
            case 256: 
            case 512: {
                event.doit = this.onPageTraversal(event);
                if (!event.doit) break;
                event.detail = 0;
            }
        }
    }

    private boolean onPageTraversal(Event event) {
        int count = this.getItemCount();
        if (count == 0) {
            return false;
        }
        int index = this.getSelectionIndex();
        if (index == -1) {
            index = 0;
        } else {
            int offset = event.detail == 512 ? 1 : -1;
            index = (index + offset + count) % count;
        }
        this.setSelection(index, true);
        return true;
    }

    private boolean scroll_leftVisible() {
        return this.topTabIndex > 0;
    }

    private boolean scroll_rightVisible() {
        if (this.items.length < 2) {
            return false;
        }
        Rectangle area = this.getClientArea();
        int rightEdge = area.x + area.width;
        if (rightEdge <= 0) {
            return false;
        }
        if (this.topTabIndex > 0) {
            rightEdge -= this.arrowBar.getSize().x;
        }
        if (this.topRight != null) {
            rightEdge -= this.topRight.getSize().x;
        }
        CTabItem item = this.items[this.items.length - 1];
        return item.x + item.width > rightEdge;
    }

    private void scroll_scrollLeft() {
        if (this.items.length == 0) {
            return;
        }
        this.setLastItem(this.topTabIndex - 1);
    }

    private void scroll_scrollRight() {
        int lastIndex = this.getLastItem();
        this.topTabIndex = lastIndex + 1;
        this.setItemLocation();
        this.correctLastItem();
        this.redrawTabArea(-1);
    }

    private boolean correctLastItem() {
        Rectangle area = this.getClientArea();
        int rightEdge = area.x + area.width;
        if (rightEdge <= 0) {
            return false;
        }
        Rectangle toolspace = this.getToolSpace();
        if (toolspace.width > 0) {
            rightEdge -= toolspace.width;
        }
        CTabItem item = this.items[this.items.length - 1];
        if (item.x + item.width < rightEdge) {
            this.setLastItem(this.items.length - 1);
            return true;
        }
        return false;
    }

    public void setTabHeight(int height) {
        this.checkWidget();
        if (height < 0) {
            SWT.error((int)5);
        }
        this.fixedTabHeight = true;
        if (this.tabHeight == height) {
            return;
        }
        this.tabHeight = height;
        this.oldSize = null;
        this.notifyListeners(11, new Event());
    }

    void resetTabSize(boolean checkHeight) {
        int oldHeight = this.tabHeight;
        if (!this.fixedTabHeight && checkHeight) {
            int tempHeight = 0;
            GC gc = new GC((Drawable)this);
            int i = 0;
            while (i < this.items.length) {
                tempHeight = Math.max(tempHeight, this.items[i].preferredHeight(gc));
                ++i;
            }
            gc.dispose();
            if (this.topRight != null) {
                tempHeight = Math.max(tempHeight, this.topRight.computeSize((int)-1, (int)-1).y);
            }
            this.tabHeight = tempHeight;
        }
        if (this.tabHeight != oldHeight) {
            this.oldSize = null;
            this.notifyListeners(11, new Event());
        } else {
            this.setItemBounds();
            this.redraw();
        }
    }

    public void setTabPosition(int position) {
        this.checkWidget();
        if (position != 128 && position != 1024) {
            SWT.error((int)5);
        }
        if (this.onBottom != (position == 1024)) {
            this.onBottom = position == 1024;
            this.setBorderVisible(this.showBorders);
            this.resetTabSize(true);
        }
    }

    public int getTabPosition() {
        if (this.onBottom) {
            return 1024;
        }
        return 128;
    }
}

