/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.StringToObjectMapImpl;
import org.eclipse.e4.ui.model.application.impl.StringToStringMapImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIEventPublisher
extends EContentAdapter {
    private IEclipseContext context;

    public UIEventPublisher(IEclipseContext e4Context) {
        this.context = e4Context;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification.isTouch()) {
            return;
        }
        HashMap<String, Object> argMap = new HashMap<String, Object>();
        String topic = this.formatData(notification, argMap);
        if (topic != null) {
            IEventBroker eventManager = (IEventBroker)this.context.get(IEventBroker.class);
            eventManager.send(topic, argMap);
        }
    }

    private String formatData(Notification notification, Map<String, Object> argMap) {
        Map.Entry<String, Object> newValue;
        Map.Entry<String, Object> oldValue;
        MApplicationElement appElement = null;
        EStructuralFeature feature = null;
        String attributeName = null;
        String topic = null;
        Object notifier = notification.getNotifier();
        if (notifier instanceof MApplicationElement) {
            appElement = (MApplicationElement)notifier;
            feature = (EStructuralFeature)notification.getFeature();
            attributeName = feature.getName();
            topic = this.getTopic(feature, this.getEventType(notification));
            oldValue = notification.getOldValue();
            newValue = notification.getNewValue();
        } else if (notifier instanceof StringToObjectMapImpl) {
            appElement = (MApplicationElement)((StringToObjectMapImpl)notifier).eContainer();
            String key = ((StringToObjectMapImpl)notifier).getKey();
            Object storedNewValue = appElement.getTransientData().get(key);
            Object notificationNewValue = notification.getNewValue();
            if (notificationNewValue != storedNewValue) {
                throw new IllegalArgumentException("A StringToObjectMap that was NOT MApplicationElement.transientData changed.  You must modify UIEventPublisher appropriately");
            }
            attributeName = "transientData";
            topic = this.getTopic(attributeName, this.getEventType(notification));
            oldValue = this.createMapEntry(key, notification.getOldValue());
            newValue = this.createMapEntry(key, notification.getNewValue());
        } else if (notifier instanceof StringToStringMapImpl) {
            appElement = (MApplicationElement)((StringToStringMapImpl)notifier).eContainer();
            String key = ((StringToStringMapImpl)notifier).getKey();
            Object storedNewValue = appElement.getPersistedState().get(key);
            Object notificationNewValue = notification.getNewValue();
            if (notificationNewValue != storedNewValue) {
                throw new IllegalArgumentException("A StringToStringMap that was NOT MApplicationElement.persistedState changed.  You must modify UIEventPublisher appropriately");
            }
            attributeName = "persistedState";
            topic = this.getTopic(attributeName, this.getEventType(notification));
            oldValue = this.createMapEntry(key, notification.getOldValue());
            newValue = this.createMapEntry(key, notification.getNewValue());
        } else {
            return null;
        }
        argMap.put("EventType", this.getEventType(notification));
        argMap.put("ChangedElement", appElement);
        argMap.put("AttName", attributeName);
        if (notification.getEventType() == 1 || notification.getEventType() == 3 || notification.getEventType() == 4) {
            argMap.put("NewValue", newValue);
            argMap.put("OldValue", oldValue);
        }
        if (appElement instanceof MUIElement) {
            argMap.put("Widget", ((MUIElement)appElement).getWidget());
        }
        return topic;
    }

    private String getEventType(Notification notification) {
        switch (notification.getEventType()) {
            case 3: {
                return "ADD";
            }
            case 4: {
                return "REMOVE";
            }
            case 1: {
                return "SET";
            }
        }
        return "UNKNOWN";
    }

    private Map.Entry<String, Object> createMapEntry(final String key, final Object value) {
        return new Map.Entry<String, Object>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public Object getValue() {
                return value;
            }

            @Override
            public Object setValue(Object value2) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private String getTopic(EStructuralFeature eFeature, String type) {
        EClass eContainingClass = eFeature.getEContainingClass();
        return "org/eclipse/e4/ui/model/" + eContainingClass.getEPackage().getName() + "/" + eContainingClass.getName() + "/" + eFeature.getName() + "/" + type;
    }

    private String getTopic(String attributeName, String type) {
        String topicBase = "org/eclipse/e4/ui/model/application/ApplicationElement/";
        return String.valueOf(topicBase) + attributeName + "/" + type;
    }
}

