/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclient;

import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.filetransfer.IRetrieveFileTransferOptions;
import org.eclipse.ecf.provider.filetransfer.httpclient.HttpClientOptions;

public class ConnectionManagerHelper {
    public static final int DEFAULT_CONNECTION_TIMEOUT = HttpClientOptions.RETRIEVE_DEFAULT_CONNECTION_TIMEOUT;
    public static final int DEFAULT_READ_TIMEOUT = HttpClientOptions.RETRIEVE_DEFAULT_READ_TIMEOUT;
    private MultiThreadedHttpConnectionManager connectionManager;

    private static int getIntegerProperty(String prop, int intDefault) {
        int retVal = intDefault;
        String systemProp = System.getProperty(prop);
        if (systemProp != null) {
            try {
                retVal = Integer.parseInt(systemProp);
            }
            catch (NumberFormatException e) {
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("Bad value for property '" + prop + "' : " + e + ". Using default value " + intDefault + "."));
            }
        }
        return retVal;
    }

    private static long getLongProperty(String prop, long longDefault) {
        long retVal = longDefault;
        String systemProp = System.getProperty(prop);
        if (systemProp != null) {
            try {
                retVal = Long.parseLong(systemProp);
            }
            catch (NumberFormatException e) {
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("Bad value for property '" + prop + "' : " + e + ". Using default value " + longDefault + "."));
            }
        }
        return retVal;
    }

    private static boolean shouldReuseConnectionsOption() {
        boolean retVal = true;
        String systemProp = System.getProperty("org.eclipse.ecf.provider.filetransfer.httpclient.reuseConnections.enabled");
        if (systemProp != null) {
            retVal = Boolean.valueOf(systemProp);
        }
        return retVal;
    }

    public static int getConnectTimeout(Map options) {
        int result = DEFAULT_CONNECTION_TIMEOUT;
        Map localOptions = options;
        if (localOptions != null) {
            Object o = localOptions.get(IRetrieveFileTransferOptions.CONNECT_TIMEOUT);
            if (o != null) {
                if (o instanceof Integer) {
                    result = (Integer)o;
                } else if (o instanceof String) {
                    result = new Integer((String)o);
                }
                return result;
            }
            o = localOptions.get("org.eclipse.ecf.provider.filetransfer.httpclient.retrieve.connectTimeout");
            if (o != null) {
                if (o instanceof Integer) {
                    result = (Integer)o;
                } else if (o instanceof String) {
                    result = new Integer((String)o);
                }
            }
        }
        return result;
    }

    public static int getSocketReadTimeout(Map options) {
        int result = DEFAULT_READ_TIMEOUT;
        Map localOptions = options;
        if (localOptions != null) {
            Object o = localOptions.get(IRetrieveFileTransferOptions.READ_TIMEOUT);
            if (o != null) {
                if (o instanceof Integer) {
                    result = (Integer)o;
                } else if (o instanceof String) {
                    result = new Integer((String)o);
                }
                return result;
            }
            o = localOptions.get("org.eclipse.ecf.provider.filetransfer.httpclient.retrieve.readTimeout");
            if (o != null) {
                if (o instanceof Integer) {
                    result = (Integer)o;
                } else if (o instanceof String) {
                    result = new Integer((String)o);
                }
            }
        }
        return result;
    }

    public synchronized void initConnectionManager(HttpClient httpClient, Map options) {
        if (!ConnectionManagerHelper.shouldReuseConnectionsOption()) {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"Connections are not reused. To reuse connections set system property 'org.eclipse.ecf.provider.filetransfer.httpclient.reuseConnections.enabled' to true.");
            ConnectionManagerHelper.initParameters(httpClient, (HttpConnectionManager)new MultiThreadedHttpConnectionManager(), false, options);
            return;
        }
        if (this.connectionManager == null) {
            this.connectionManager = new MultiThreadedHttpConnectionManager();
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"Created shared connection manager.");
        } else {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"Reusing shared connection manager.");
        }
        ConnectionManagerHelper.initParameters(httpClient, (HttpConnectionManager)this.connectionManager, true, options);
    }

    private static void initParameters(HttpClient httpClient, HttpConnectionManager cm, boolean cmIsShared, Map options) {
        long closeIdlePeriod;
        if (cmIsShared && (closeIdlePeriod = ConnectionManagerHelper.getLongProperty("org.eclipse.ecf.provider.filetransfer.httpclient.poolCloseIdle", 180000L)) > 0L) {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("Closing connections which were idle at least " + closeIdlePeriod + " milliseconds."));
            cm.closeIdleConnections(closeIdlePeriod);
        }
        httpClient.setHttpConnectionManager(cm);
        int readTimeout = ConnectionManagerHelper.getSocketReadTimeout(options);
        cm.getParams().setSoTimeout(readTimeout);
        int connectTimeout = ConnectionManagerHelper.getConnectTimeout(options);
        cm.getParams().setConnectionTimeout(connectTimeout);
        if (cmIsShared) {
            HttpConnectionManagerParams cmParams = cm.getParams();
            int maxHostConnections = ConnectionManagerHelper.getIntegerProperty("org.eclipse.ecf.provider.filetransfer.httpclient.maxConnectionsPerHost", 4);
            int maxTotalConnections = ConnectionManagerHelper.getIntegerProperty("org.eclipse.ecf.provider.filetransfer.httpclient.maxConnectionsTotal", 200);
            cmParams.setDefaultMaxConnectionsPerHost(maxHostConnections);
            cmParams.setMaxTotalConnections(maxTotalConnections);
            long connectionManagerTimeout = ConnectionManagerHelper.getLongProperty("org.eclipse.ecf.provider.filetransfer.httpclient.poolConnectionTimeout", 0L);
            httpClient.getParams().setConnectionManagerTimeout(connectionManagerTimeout);
        }
    }

    public synchronized void shutdown() {
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
            this.connectionManager = null;
        }
    }
}

