/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoRectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    long buttonHandle;
    long entryHandle;
    long textRenderer;
    long cellHandle;
    long popupHandle;
    long menuHandle;
    int lastEventTime;
    int visibleCount = 10;
    long gdkEventKey = 0L;
    int fixStart = -1;
    int fixEnd = -1;
    String[] items = new String[0];
    boolean selectionAdded;
    int indexSelected;
    public static final int LIMIT = 65535;

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.add(string, this.items.length);
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index < 0 || index > this.items.length) {
            this.error(6);
        }
        String[] newItems = new String[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        newItems[index] = string;
        System.arraycopy(this.items, index, newItems, index + 1, this.items.length - index);
        this.items = newItems;
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        OS.gtk_combo_box_insert_text(this.handle, index, buffer);
        if ((this.style & 0x4000000) != 0 && this.popupHandle != 0L) {
            OS.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2L);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int style) {
        style &= 0xFFFFF7FF;
        style &= 0xFFFFFCFF;
        if (((style = Combo.checkBits(style, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return style & 0xFFFFFFF7;
        }
        return style;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            int position = OS.gtk_editable_get_position(this.entryHandle);
            OS.gtk_editable_select_region(this.entryHandle, position, position);
        }
    }

    void clearText() {
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        if ((this.style & 8) != 0) {
            int index = OS.gtk_combo_box_get_active(this.handle);
            if (index != -1) {
                long modelHandle = OS.gtk_combo_box_get_model(this.handle);
                long[] ptr = new long[1];
                long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
                OS.gtk_tree_model_iter_nth_child(modelHandle, iter, 0L, index);
                OS.gtk_tree_model_get(modelHandle, iter, 0, ptr, -1L);
                OS.g_free(iter);
                if (ptr[0] != 0L && OS.strlen(ptr[0]) > 0) {
                    this.postEvent(24);
                }
                OS.g_free(ptr[0]);
            }
        } else {
            OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
        }
        OS.gtk_combo_box_set_active(this.handle, -1);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        return this.computeNativeSize(this.handle, wHint, hHint, changed);
    }

    public void copy() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            OS.gtk_editable_copy_clipboard(this.entryHandle);
        }
    }

    void createHandle(int index) {
        this.state |= 0x28;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        long oldList = OS.gtk_window_list_toplevels();
        if ((this.style & 8) != 0) {
            this.handle = OS.gtk_combo_box_new_text();
            if (this.handle == 0L) {
                this.error(2);
            }
            this.cellHandle = OS.gtk_bin_get_child(this.handle);
            if (this.cellHandle == 0L) {
                this.error(2);
            }
        } else {
            this.handle = OS.gtk_combo_box_entry_new_text();
            if (this.handle == 0L) {
                this.error(2);
            }
            this.entryHandle = OS.gtk_bin_get_child(this.handle);
            if (this.entryHandle == 0L) {
                this.error(2);
            }
        }
        this.popupHandle = this.findPopupHandle(oldList);
        OS.gtk_container_add(this.fixedHandle, this.handle);
        this.textRenderer = OS.gtk_cell_renderer_text_new();
        if (this.textRenderer == 0L) {
            this.error(2);
        }
        int pad = 0;
        if (OS.GTK_VERSION < OS.VERSION(2, 6, 0)) {
            pad = 1;
        }
        OS.g_object_set(this.textRenderer, OS.ypad, pad, 0L);
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.gtk_cell_layout_clear(this.handle);
        this.display.setWarnings(warnings);
        OS.gtk_cell_layout_pack_start(this.handle, this.textRenderer, true);
        OS.gtk_cell_layout_set_attributes(this.handle, this.textRenderer, OS.text, 0, 0L);
        if (OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
            OS.gtk_widget_size_request(this.handle, new GtkRequisition());
        }
        if (this.popupHandle != 0L) {
            this.findMenuHandle();
        }
        this.findButtonHandle();
        if ((this.style & 8) != 0 && this.buttonHandle != 0L) {
            OS.GTK_WIDGET_UNSET_FLAGS(this.buttonHandle, 0x100000);
        }
    }

    public void cut() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            OS.gtk_editable_cut_clipboard(this.entryHandle);
        }
    }

    void deregister() {
        long imContext;
        super.deregister();
        if (this.buttonHandle != 0L) {
            this.display.removeWidget(this.buttonHandle);
        }
        if (this.entryHandle != 0L) {
            this.display.removeWidget(this.entryHandle);
        }
        if (this.popupHandle != 0L) {
            this.display.removeWidget(this.popupHandle);
        }
        if (this.menuHandle != 0L) {
            this.display.removeWidget(this.menuHandle);
        }
        if ((imContext = this.imContext()) != 0L) {
            this.display.removeWidget(imContext);
        }
    }

    boolean filterKey(int keyval, long event) {
        int time = OS.gdk_event_get_time(event);
        if (time != this.lastEventTime) {
            this.lastEventTime = time;
            long imContext = this.imContext();
            if (imContext != 0L) {
                return OS.gtk_im_context_filter_keypress(imContext, event);
            }
        }
        this.gdkEventKey = event;
        return false;
    }

    long findPopupHandle(long oldList) {
        long result = 0L;
        long currentList = OS.gtk_window_list_toplevels();
        long oldFromList = oldList;
        long newFromList = OS.g_list_last(currentList);
        while (newFromList != 0L) {
            long newToplevel = OS.g_list_data(newFromList);
            boolean isFound = false;
            oldFromList = oldList;
            while (oldFromList != 0L) {
                long oldToplevel = OS.g_list_data(oldFromList);
                if (newToplevel == oldToplevel) {
                    isFound = true;
                    break;
                }
                oldFromList = OS.g_list_next(oldFromList);
            }
            if (!isFound) {
                result = newToplevel;
                break;
            }
            newFromList = OS.g_list_previous(newFromList);
        }
        OS.g_list_free(oldList);
        OS.g_list_free(currentList);
        return result;
    }

    void findButtonHandle() {
        OS.gtk_container_forall(this.handle, this.display.allChildrenProc, 0L);
        if (this.display.allChildren != 0L) {
            long list = this.display.allChildren;
            while (list != 0L) {
                long widget = OS.g_list_data(list);
                if (OS.GTK_IS_BUTTON(widget)) {
                    this.buttonHandle = widget;
                    break;
                }
                list = OS.g_list_next(list);
            }
            OS.g_list_free(this.display.allChildren);
            this.display.allChildren = 0L;
        }
    }

    void findMenuHandle() {
        OS.gtk_container_forall(this.popupHandle, this.display.allChildrenProc, 0L);
        if (this.display.allChildren != 0L) {
            long list = this.display.allChildren;
            while (list != 0L) {
                long widget = OS.g_list_data(list);
                if (OS.G_OBJECT_TYPE(widget) == OS.GTK_TYPE_MENU()) {
                    this.menuHandle = widget;
                    break;
                }
                list = OS.g_list_next(list);
            }
            OS.g_list_free(this.display.allChildren);
            this.display.allChildren = 0L;
        }
    }

    void fixModal(long group, long modalGroup) {
        if (this.popupHandle != 0L) {
            if (group != 0L) {
                OS.gtk_window_group_add_window(group, this.popupHandle);
            } else if (modalGroup != 0L) {
                OS.gtk_window_group_remove_window(modalGroup, this.popupHandle);
            }
        }
    }

    void fixIM() {
        long imContext;
        if (this.gdkEventKey != 0L && this.gdkEventKey != -1L && (imContext = this.imContext()) != 0L) {
            OS.gtk_im_context_filter_keypress(imContext, this.gdkEventKey);
            this.gdkEventKey = -1L;
            return;
        }
        this.gdkEventKey = 0L;
    }

    long fontHandle() {
        if (this.entryHandle != 0L) {
            return this.entryHandle;
        }
        return super.fontHandle();
    }

    long focusHandle() {
        if ((this.style & 8) != 0 && this.buttonHandle != 0L) {
            return this.buttonHandle;
        }
        if (this.entryHandle != 0L) {
            return this.entryHandle;
        }
        return super.focusHandle();
    }

    boolean hasFocus() {
        if (super.hasFocus()) {
            return true;
        }
        return this.entryHandle != 0L && OS.GTK_WIDGET_HAS_FOCUS(this.entryHandle);
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.changed, this.display.closures[6], true);
        if (this.entryHandle != 0L) {
            OS.g_signal_connect_closure(this.entryHandle, OS.changed, this.display.closures[6], true);
            OS.g_signal_connect_closure(this.entryHandle, OS.insert_text, this.display.closures[26], false);
            OS.g_signal_connect_closure(this.entryHandle, OS.delete_text, this.display.closures[13], false);
            OS.g_signal_connect_closure(this.entryHandle, OS.activate, this.display.closures[1], false);
            OS.g_signal_connect_closure(this.entryHandle, OS.populate_popup, this.display.closures[37], false);
        }
        int eventMask = 772;
        long[] handles = new long[]{this.buttonHandle, this.entryHandle, this.menuHandle};
        int i = 0;
        while (i < handles.length) {
            long eventHandle = handles[i];
            if (eventHandle != 0L) {
                OS.gtk_widget_add_events(eventHandle, eventMask);
                OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[2], 0, this.display.closures[2], false);
                OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[4], 0, this.display.closures[4], false);
                OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[33], 0, this.display.closures[33], false);
                OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[2], 0, this.display.closures[3], true);
                OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[4], 0, this.display.closures[5], true);
                OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[33], 0, this.display.closures[34], true);
                if (eventHandle != this.focusHandle()) {
                    OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[16], 0, this.display.closures[16], false);
                }
            }
            ++i;
        }
        long imContext = this.imContext();
        if (imContext != 0L) {
            OS.g_signal_connect_closure(imContext, OS.commit, this.display.closures[9], false);
            int id = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
            int blockMask = 17;
            OS.g_signal_handlers_block_matched(imContext, blockMask, id, 0, 0L, 0L, this.entryHandle);
        }
        if (this.menuHandle != 0L) {
            OS.g_signal_connect_closure(this.menuHandle, OS.selection_done, this.display.closures[68], true);
        }
    }

    long imContext() {
        return this.entryHandle != 0L ? OS.GTK_ENTRY_IM_CONTEXT(this.entryHandle) : 0L;
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            return;
        }
        if (OS.gtk_combo_box_get_active(this.handle) == index) {
            this.clearText();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        this.clearText();
    }

    boolean dragDetect(int x, int y, boolean filter, boolean dragOnTimeout, boolean[] consume) {
        if (filter && this.entryHandle != 0L) {
            int[] index = new int[1];
            int[] trailing = new int[1];
            long layout = OS.gtk_entry_get_layout(this.entryHandle);
            OS.pango_layout_xy_to_index(layout, x * 1024, y * 1024, index, trailing);
            long ptr = OS.pango_layout_get_text(layout);
            int position = (int)OS.g_utf8_pointer_to_offset(ptr, ptr + (long)index[0]) + trailing[0];
            int[] start = new int[1];
            int[] end = new int[1];
            OS.gtk_editable_get_selection_bounds(this.entryHandle, start, end);
            if (start[0] <= position && position < end[0] && super.dragDetect(x, y, filter, dragOnTimeout, consume)) {
                if (consume != null) {
                    consume[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(x, y, filter, dragOnTimeout, consume);
    }

    long enterExitHandle() {
        return this.fixedHandle;
    }

    long eventWindow() {
        return this.paintWindow();
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public Point getCaretLocation() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return new Point(0, 0);
        }
        int index = OS.gtk_editable_get_position(this.entryHandle);
        if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
            index = OS.gtk_entry_text_index_to_layout_index(this.entryHandle, index);
        }
        int[] offset_x = new int[1];
        int[] offset_y = new int[1];
        OS.gtk_entry_get_layout_offsets(this.entryHandle, offset_x, offset_y);
        long layout = OS.gtk_entry_get_layout(this.entryHandle);
        PangoRectangle pos = new PangoRectangle();
        OS.pango_layout_index_to_pos(layout, index, pos);
        int x = offset_x[0] + OS.PANGO_PIXELS(pos.x) - this.getBorderWidth();
        int y = offset_y[0] + OS.PANGO_PIXELS(pos.y);
        return new Point(x, y);
    }

    public int getCaretPosition() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return 0;
        }
        long ptr = OS.gtk_entry_get_text(this.entryHandle);
        return (int)OS.g_utf8_offset_to_utf16_offset(ptr, OS.gtk_editable_get_position(this.entryHandle));
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public String getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.length;
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.fontHeight(this.getFontDescription(), this.handle);
    }

    public String[] getItems() {
        this.checkWidget();
        String[] result = new String[this.items.length];
        System.arraycopy(this.items, 0, result, 0, this.items.length);
        return result;
    }

    public boolean getListVisible() {
        this.checkWidget();
        return this.popupHandle != 0L && OS.GTK_WIDGET_VISIBLE(this.popupHandle);
    }

    String getNameText() {
        return this.getText();
    }

    public int getOrientation() {
        return super.getOrientation();
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            int length = 0;
            int index = OS.gtk_combo_box_get_active(this.handle);
            if (index != -1) {
                length = this.getItem(index).length();
            }
            return new Point(0, length);
        }
        int[] start = new int[1];
        int[] end = new int[1];
        if (this.entryHandle != 0L) {
            OS.gtk_editable_get_selection_bounds(this.entryHandle, start, end);
            long ptr = OS.gtk_entry_get_text(this.entryHandle);
            start[0] = (int)OS.g_utf8_offset_to_utf16_offset(ptr, start[0]);
            end[0] = (int)OS.g_utf8_offset_to_utf16_offset(ptr, end[0]);
        }
        return new Point(start[0], end[0]);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.gtk_combo_box_get_active(this.handle);
    }

    public String getText() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            long str = OS.gtk_entry_get_text(this.entryHandle);
            if (str == 0L) {
                return "";
            }
            int length = OS.strlen(str);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, str, (long)length);
            return new String(Converter.mbcsToWcs(null, buffer));
        }
        int index = OS.gtk_combo_box_get_active(this.handle);
        return index != -1 ? this.getItem(index) : "";
    }

    String getText(int start, int stop) {
        return this.getText().substring(start, stop - 1);
    }

    public int getTextHeight() {
        this.checkWidget();
        GtkRequisition requisition = new GtkRequisition();
        this.gtk_widget_size_request(this.handle, requisition);
        return OS.GTK_WIDGET_REQUISITION_HEIGHT(this.handle);
    }

    public int getTextLimit() {
        this.checkWidget();
        int limit = this.entryHandle != 0L ? OS.gtk_entry_get_max_length(this.entryHandle) : 0;
        return limit == 0 ? LIMIT : limit;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    long gtk_activate(long widget) {
        this.sendSelectionEvent(14);
        return 0L;
    }

    long gtk_button_press_event(long widget, long event) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, (long)GdkEventButton.sizeof);
        if (gdkEvent.type == 4 && gdkEvent.button == 1) {
            return this.gtk_button_press_event(widget, event, false);
        }
        return super.gtk_button_press_event(widget, event);
    }

    long gtk_changed(long widget) {
        if (widget == this.handle) {
            int index;
            if (this.entryHandle == 0L) {
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return 0L;
                }
            }
            if ((index = OS.gtk_combo_box_get_active(this.handle)) != -1) {
                this.sendSelectionEvent(13);
            }
            this.indexSelected = -1;
            return 0L;
        }
        boolean keyPress = false;
        long eventPtr = OS.gtk_get_current_event();
        if (eventPtr != 0L) {
            GdkEventKey gdkEvent = new GdkEventKey();
            OS.memmove(gdkEvent, eventPtr, (long)GdkEventKey.sizeof);
            switch (gdkEvent.type) {
                case 8: {
                    keyPress = true;
                }
            }
            OS.gdk_event_free(eventPtr);
        }
        if (keyPress) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        return 0L;
    }

    long gtk_commit(long imContext, long text) {
        if (text == 0L) {
            return 0L;
        }
        if (!OS.gtk_editable_get_editable(this.entryHandle)) {
            return 0L;
        }
        int length = OS.strlen(text);
        if (length == 0) {
            return 0L;
        }
        byte[] buffer = new byte[length];
        OS.memmove(buffer, text, (long)length);
        char[] chars = Converter.mbcsToWcs(null, buffer);
        char[] newChars = this.sendIMKeyEvent(1, null, chars);
        if (newChars == null) {
            return 0L;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(imContext, 16, 0, 0, 0L, 0L, 9L);
        int id = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
        int mask = 17;
        OS.g_signal_handlers_unblock_matched(imContext, mask, id, 0, 0L, 0L, this.entryHandle);
        if (newChars == chars) {
            OS.g_signal_emit_by_name(imContext, OS.commit, text);
        } else {
            buffer = Converter.wcsToMbcs(null, newChars, true);
            OS.g_signal_emit_by_name(imContext, OS.commit, buffer);
        }
        OS.g_signal_handlers_unblock_matched(imContext, 16, 0, 0, 0L, 0L, 9L);
        OS.g_signal_handlers_block_matched(imContext, mask, id, 0, 0L, 0L, this.entryHandle);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            OS.gtk_editable_set_position(this.entryHandle, this.fixStart);
            OS.gtk_editable_select_region(this.entryHandle, this.fixStart, this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0L;
    }

    long gtk_delete_text(long widget, long start_pos, long end_pos) {
        int end;
        int start;
        String newText;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        long ptr = OS.gtk_entry_get_text(this.entryHandle);
        if (end_pos == -1L) {
            end_pos = OS.g_utf8_strlen(ptr, -1L);
        }
        if ((newText = this.verifyText("", start = (int)OS.g_utf8_offset_to_utf16_offset(ptr, start_pos), end = (int)OS.g_utf8_offset_to_utf16_offset(ptr, end_pos))) == null) {
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.delete_text);
        } else if (newText.length() > 0) {
            int[] pos = new int[]{(int)end_pos};
            byte[] buffer = Converter.wcsToMbcs(null, newText, false);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
            OS.gtk_editable_insert_text(this.entryHandle, buffer, buffer.length, pos);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_editable_set_position(this.entryHandle, pos[0]);
        }
        return 0L;
    }

    long gtk_event_after(long widget, long gdkEvent) {
        GdkEvent event = new GdkEvent();
        OS.memmove(event, gdkEvent, (long)GdkEvent.sizeof);
        switch (event.type) {
            case 4: {
                long grabHandle;
                if (OS.GTK_VERSION < OS.VERSION(2, 8, 0) && !this.selectionAdded && (grabHandle = OS.gtk_grab_get_current()) != 0L && OS.G_OBJECT_TYPE(grabHandle) == OS.GTK_TYPE_MENU()) {
                    this.menuHandle = grabHandle;
                    OS.g_signal_connect_closure_by_id(this.menuHandle, this.display.signalIds[4], 0, this.display.closures[4], false);
                    OS.g_signal_connect_closure_by_id(this.menuHandle, this.display.signalIds[4], 0, this.display.closures[5], true);
                    OS.g_signal_connect_closure(this.menuHandle, OS.selection_done, this.display.closures[68], false);
                    this.display.addWidget(this.menuHandle, this);
                    this.selectionAdded = true;
                }
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, gdkEvent, (long)GdkEventButton.sizeof);
                if (gdkEventButton.button != 1) break;
                if (!this.sendMouseEvent(3, gdkEventButton.button, this.display.clickCount, 0, false, gdkEventButton.time, gdkEventButton.x_root, gdkEventButton.y_root, false, gdkEventButton.state)) {
                    return 1L;
                }
                if (OS.GTK_VERSION < OS.VERSION(2, 6, 0) || (this.style & 8) != 0 || widget != this.buttonHandle) break;
                OS.gtk_widget_grab_focus(this.entryHandle);
                break;
            }
            case 12: {
                if (OS.GTK_VERSION < OS.VERSION(2, 6, 0) || (this.style & 8) != 0) break;
                GdkEventFocus gdkEventFocus = new GdkEventFocus();
                OS.memmove(gdkEventFocus, gdkEvent, (long)GdkEventFocus.sizeof);
                if (gdkEventFocus.in != 0) {
                    OS.gtk_combo_box_set_focus_on_click(this.handle, false);
                    break;
                }
                OS.gtk_combo_box_set_focus_on_click(this.handle, true);
            }
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    long gtk_focus_out_event(long widget, long event) {
        this.fixIM();
        return super.gtk_focus_out_event(widget, event);
    }

    long gtk_insert_text(long widget, long new_text, long new_text_length, long position) {
        int start;
        String newText;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        if (new_text == 0L || new_text_length == 0L) {
            return 0L;
        }
        byte[] buffer = new byte[(int)new_text_length];
        OS.memmove(buffer, new_text, (long)buffer.length);
        String oldText = new String(Converter.mbcsToWcs(null, buffer));
        int[] pos = new int[1];
        OS.memmove(pos, position, 4L);
        long ptr = OS.gtk_entry_get_text(this.entryHandle);
        if (pos[0] == -1) {
            pos[0] = (int)OS.g_utf8_strlen(ptr, -1L);
        }
        if ((newText = this.verifyText(oldText, start = (int)OS.g_utf8_offset_to_utf16_offset(ptr, pos[0]), start)) != oldText) {
            int[] newStart = new int[1];
            int[] newEnd = new int[1];
            OS.gtk_editable_get_selection_bounds(this.entryHandle, newStart, newEnd);
            if (newText != null) {
                if (newStart[0] != newEnd[0]) {
                    OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
                    OS.gtk_editable_delete_selection(this.entryHandle);
                    OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
                }
                byte[] buffer3 = Converter.wcsToMbcs(null, newText, false);
                OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
                OS.gtk_editable_insert_text(this.entryHandle, buffer3, buffer3.length, pos);
                OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
                newStart[0] = newEnd[0] = pos[0];
            }
            pos[0] = newEnd[0];
            if (newStart[0] != newEnd[0]) {
                this.fixStart = newStart[0];
                this.fixEnd = newEnd[0];
            }
            OS.memmove(position, pos, 4L);
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.insert_text);
        }
        return 0L;
    }

    long gtk_key_press_event(long widget, long event) {
        long result = super.gtk_key_press_event(widget, event);
        if (result != 0L) {
            this.gdkEventKey = 0L;
            this.fixIM();
            return result;
        }
        if (this.gdkEventKey == -1L) {
            result = 1L;
        }
        this.gdkEventKey = 0L;
        if ((this.style & 8) == 0) {
            int oldIndex;
            GdkEventKey keyEvent = new GdkEventKey();
            OS.memmove(keyEvent, event, (long)GdkEventKey.sizeof);
            int newIndex = oldIndex = OS.gtk_combo_box_get_active(this.handle);
            int key = keyEvent.keyval;
            switch (key) {
                case 65364: 
                case 65433: {
                    if (oldIndex == this.items.length - 1) break;
                    newIndex = oldIndex + 1;
                    break;
                }
                case 65362: 
                case 65431: {
                    if (oldIndex == -1 || oldIndex == 0) break;
                    newIndex = oldIndex - 1;
                    break;
                }
                case 65365: 
                case 65434: {
                    newIndex = 0;
                    break;
                }
                case 65366: 
                case 65435: {
                    newIndex = this.items.length - 1;
                }
            }
            if (newIndex != oldIndex) {
                OS.gtk_combo_box_set_active(this.handle, newIndex);
                return 1L;
            }
        }
        return result;
    }

    long gtk_populate_popup(long widget, long menu) {
        if ((this.style & 0x4000000) != 0) {
            OS.gtk_widget_set_direction(menu, 2);
            OS.gtk_container_forall(menu, this.display.setDirectionProc, 2L);
        }
        return 0L;
    }

    long gtk_selection_done(long menushell) {
        int index = OS.gtk_combo_box_get_active(this.handle);
        if (this.indexSelected == -1) {
            this.indexSelected = index;
        } else if (index != -1 && this.indexSelected == index) {
            this.sendSelectionEvent(13);
        }
        return 0L;
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (start < 0 || start >= this.items.length) {
            return -1;
        }
        int i = start;
        while (i < this.items.length) {
            if (string.equals(this.items[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    boolean isFocusHandle(int widget) {
        if (this.buttonHandle != 0L && (long)widget == this.buttonHandle) {
            return true;
        }
        if (this.entryHandle != 0L && (long)widget == this.entryHandle) {
            return true;
        }
        return super.isFocusHandle(widget);
    }

    long paintWindow() {
        long childHandle = this.entryHandle != 0L ? this.entryHandle : this.handle;
        OS.gtk_widget_realize(childHandle);
        long window = OS.GTK_WIDGET_WINDOW(childHandle);
        if ((this.style & 8) != 0) {
            return window;
        }
        long children = OS.gdk_window_get_children(window);
        if (children != 0L) {
            window = OS.g_list_data(children);
        }
        OS.g_list_free(children);
        return window;
    }

    public void paste() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            OS.gtk_editable_paste_clipboard(this.entryHandle);
        }
    }

    long parentingHandle() {
        return this.fixedHandle;
    }

    void register() {
        long imContext;
        super.register();
        if (this.buttonHandle != 0L) {
            this.display.addWidget(this.buttonHandle, this);
        }
        if (this.entryHandle != 0L) {
            this.display.addWidget(this.entryHandle, this);
        }
        if (this.popupHandle != 0L) {
            this.display.addWidget(this.popupHandle, this);
        }
        if (this.menuHandle != 0L) {
            this.display.addWidget(this.menuHandle, this);
        }
        if ((imContext = this.imContext()) != 0L) {
            this.display.addWidget(imContext, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.entryHandle = 0L;
        this.buttonHandle = 0L;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.textRenderer = 0L;
        this.fixIM();
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            this.error(6);
        }
        String[] oldItems = this.items;
        String[] newItems = new String[oldItems.length - 1];
        System.arraycopy(oldItems, 0, newItems, 0, index);
        System.arraycopy(oldItems, index + 1, newItems, index, oldItems.length - index - 1);
        this.items = newItems;
        if (OS.gtk_combo_box_get_active(this.handle) == index) {
            this.clearText();
        }
        OS.gtk_combo_box_remove_text(this.handle, index);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.items.length) {
            this.error(6);
        }
        String[] oldItems = this.items;
        String[] newItems = new String[oldItems.length - (end - start + 1)];
        System.arraycopy(oldItems, 0, newItems, 0, start);
        System.arraycopy(oldItems, end + 1, newItems, start, oldItems.length - end - 1);
        this.items = newItems;
        int index = OS.gtk_combo_box_get_active(this.handle);
        if (start <= index && index <= end) {
            this.clearText();
        }
        int i = end;
        while (i >= start) {
            OS.gtk_combo_box_remove_text(this.handle, i);
            --i;
        }
    }

    public void remove(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void removeAll() {
        this.checkWidget();
        int count = this.items.length;
        this.items = new String[0];
        this.clearText();
        int i = count - 1;
        while (i >= 0) {
            OS.gtk_combo_box_remove_text(this.handle, i);
            --i;
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            return;
        }
        int selected = OS.gtk_combo_box_get_active(this.handle);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_combo_box_set_active(this.handle, index);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        if ((this.style & 8) != 0 && selected != index) {
            this.sendEvent(24);
        }
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        if (this.entryHandle != 0L) {
            OS.gtk_widget_modify_base(this.entryHandle, 0, color);
        }
        if (this.cellHandle != 0L) {
            OS.g_object_set(this.cellHandle, OS.background_gdk, color, 0L);
        }
        OS.g_object_set(this.textRenderer, OS.background_gdk, color, 0L);
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int newHeight = height;
        if (resize) {
            newHeight = Math.max(this.getTextHeight(), height);
        }
        return super.setBounds(x, y, width, newHeight, move, resize);
    }

    void setFontDescription(long font) {
        super.setFontDescription(font);
        if (this.entryHandle != 0L) {
            OS.gtk_widget_modify_font(this.entryHandle, font);
        }
        OS.g_object_set(this.textRenderer, OS.font_desc, font, 0L);
        if ((this.style & 8) != 0) {
            int index = OS.gtk_combo_box_get_active(this.handle);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_combo_box_set_active(this.handle, -1);
            OS.gtk_combo_box_set_active(this.handle, index);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        }
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        if (this.entryHandle != 0L) {
            this.setForegroundColor(this.entryHandle, color);
        }
        OS.g_object_set(this.textRenderer, OS.foreground_gdk, color, 0L);
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index < 0 || index >= this.items.length) {
            this.error(5);
        }
        this.items[index] = string;
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        OS.gtk_combo_box_remove_text(this.handle, index);
        OS.gtk_combo_box_insert_text(this.handle, index, buffer);
        if ((this.style & 0x4000000) != 0 && this.popupHandle != 0L) {
            OS.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2L);
        }
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                this.error(5);
            }
            ++i;
        }
        int count = this.items.length;
        this.items = new String[items.length];
        System.arraycopy(items, 0, this.items, 0, items.length);
        this.clearText();
        int i2 = count - 1;
        while (i2 >= 0) {
            OS.gtk_combo_box_remove_text(this.handle, i2);
            --i2;
        }
        i2 = 0;
        while (i2 < items.length) {
            String string = items[i2];
            byte[] buffer = Converter.wcsToMbcs(null, string, true);
            OS.gtk_combo_box_insert_text(this.handle, i2, buffer);
            if ((this.style & 0x4000000) != 0 && this.popupHandle != 0L) {
                OS.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2L);
            }
            ++i2;
        }
    }

    public void setListVisible(boolean visible) {
        this.checkWidget();
        if (visible) {
            OS.gtk_combo_box_popup(this.handle);
        } else {
            OS.gtk_combo_box_popdown(this.handle);
        }
    }

    void setOrientation(boolean create) {
        super.setOrientation(create);
        if ((this.style & 0x4000000) != 0 || !create) {
            int dir;
            int n = dir = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.entryHandle != 0L) {
                OS.gtk_widget_set_direction(this.entryHandle, dir);
            }
            if (this.cellHandle != 0L) {
                OS.gtk_widget_set_direction(this.cellHandle, dir);
            }
            if (!create && this.popupHandle != 0L) {
                OS.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, dir);
            }
        }
    }

    public void setOrientation(int orientation) {
        super.setOrientation(orientation);
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            return;
        }
        if (this.entryHandle != 0L) {
            long ptr = OS.gtk_entry_get_text(this.entryHandle);
            int start = (int)OS.g_utf16_offset_to_utf8_offset(ptr, selection.x);
            int end = (int)OS.g_utf16_offset_to_utf8_offset(ptr, selection.y);
            OS.gtk_editable_set_position(this.entryHandle, start);
            OS.gtk_editable_select_region(this.entryHandle, start, end);
        }
    }

    public void setText(String string) {
        long ptr;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int index = this.indexOf(string);
            if (index == -1) {
                return;
            }
            this.select(index);
            return;
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, (int)OS.g_utf16_strlen(ptr = OS.gtk_entry_get_text(this.entryHandle), -1L))) == null) {
            return;
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
        OS.gtk_entry_set_text(this.entryHandle, buffer);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
        this.sendEvent(24);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        if (this.entryHandle != 0L) {
            OS.gtk_entry_set_max_length(this.entryHandle, limit);
        }
    }

    void setToolTipText(Shell shell, String newString) {
        if (this.entryHandle != 0L) {
            shell.setToolTipText(this.entryHandle, newString);
        }
        if (this.buttonHandle != 0L) {
            shell.setToolTipText(this.buttonHandle, newString);
        }
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count < 0) {
            return;
        }
        this.visibleCount = count;
    }

    boolean checkSubwindow() {
        return false;
    }

    boolean translateTraversal(GdkEventKey keyEvent) {
        int key = keyEvent.keyval;
        switch (key) {
            case 65293: 
            case 65421: {
                long imContext = this.imContext();
                if (imContext == 0L) break;
                long[] preeditString = new long[1];
                OS.gtk_im_context_get_preedit_string(imContext, preeditString, null, null);
                if (preeditString[0] == 0L) break;
                int length = OS.strlen(preeditString[0]);
                OS.g_free(preeditString[0]);
                if (length == 0) break;
                return false;
            }
        }
        return super.translateTraversal(keyEvent);
    }

    String verifyText(String string, int start, int end) {
        if (string.length() == 0 && start == end) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        long eventPtr = OS.gtk_get_current_event();
        if (eventPtr != 0L) {
            GdkEventKey gdkEvent = new GdkEventKey();
            OS.memmove(gdkEvent, eventPtr, (long)GdkEventKey.sizeof);
            switch (gdkEvent.type) {
                case 8: {
                    this.setKeyState(event, gdkEvent);
                }
            }
            OS.gdk_event_free(eventPtr);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

