/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclarationWrapper;
import org.eclipse.dltk.ast.parser.ASTCacheManager;
import org.eclipse.dltk.ast.parser.IASTCache;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemCollector;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.RuntimePerformanceMonitor;
import org.eclipse.dltk.internal.core.ModelManager;

public class SourceParserUtil {
    private static final String AST = "ast";
    private static final String ERRORS = "errors";
    private static boolean useASTCaching = true;
    private static boolean useASTPersistenceCaching = true;

    public static IModuleDeclaration parse(IModuleSource module, String natureId, IProblemReporter reporter) {
        IModelElement element = module.getModelElement();
        ISourceParser parser = DLTKLanguageManager.getSourceParser(element != null ? element.getScriptProject().getProject() : null, natureId);
        return parser.parse(module, reporter);
    }

    public static IModuleDeclaration parse(final ISourceModule module, IProblemReporter reporter) {
        String astKey;
        String errorKey;
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(module);
        if (toolkit == null) {
            return null;
        }
        IModuleDeclaration moduleDeclaration = null;
        RuntimePerformanceMonitor.PerformanceNode p1 = RuntimePerformanceMonitor.begin();
        ISourceModuleInfoCache.ISourceModuleInfo mifo = ModelManager.getModelManager().getSourceModuleInfoCache().get(module);
        if (mifo != null && useASTCaching) {
            IASTCache[] providers;
            ProblemCollector collector;
            errorKey = SourceParserUtil.getKey(ERRORS, 0);
            astKey = SourceParserUtil.getKey(AST, 0);
            moduleDeclaration = (IModuleDeclaration)mifo.get(astKey);
            if (moduleDeclaration != null && reporter != null && (collector = (ProblemCollector)mifo.get(errorKey)) != null) {
                collector.copyTo(reporter);
            }
            if (moduleDeclaration == null && useASTPersistenceCaching && (providers = ASTCacheManager.getProviders(toolkit.getNatureId())) != null) {
                IASTCache[] iASTCacheArray = providers;
                int n = providers.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTCache provider = iASTCacheArray[n2];
                    IASTCache.ASTCacheEntry restored = provider.restoreModule(module);
                    if (restored != null) {
                        if (reporter != null && restored.problems != null) {
                            restored.problems.copyTo(reporter);
                        }
                        mifo.put(astKey, restored.module);
                        if (restored.problems != null && !restored.problems.isEmpty()) {
                            mifo.put(errorKey, restored.problems);
                        } else {
                            mifo.remove(errorKey);
                        }
                        moduleDeclaration = restored.module;
                        break;
                    }
                    ++n2;
                }
            }
        } else {
            errorKey = null;
            astKey = null;
        }
        p1.done(toolkit.getNatureId(), "Retrive AST from cache", 0L);
        if (moduleDeclaration == null) {
            p1.renew();
            ISourceParser sourceParser = DLTKLanguageManager.getSourceParser(module.getScriptProject().getProject(), toolkit.getNatureId());
            if (sourceParser != null) {
                ProblemCollector collector = mifo != null ? new ProblemCollector() : null;
                IModuleSource source = module instanceof IModuleSource ? (IModuleSource)((Object)module) : new IModuleSource(){

                    public String getFileName() {
                        return module.getPath().toString();
                    }

                    public String getSourceContents() {
                        try {
                            return module.getSource();
                        }
                        catch (ModelException modelException) {
                            return "";
                        }
                    }

                    public IModelElement getModelElement() {
                        return module;
                    }

                    public char[] getContentsAsCharArray() {
                        try {
                            return module.getSourceAsCharArray();
                        }
                        catch (ModelException modelException) {
                            return CharOperation.NO_CHAR;
                        }
                    }
                };
                moduleDeclaration = sourceParser.parse(source, collector != null ? collector : reporter);
                if (collector != null && reporter != null) {
                    collector.copyTo(reporter);
                }
                p1.done(toolkit.getNatureId(), "AST parse time", 0L);
                if (moduleDeclaration != null && mifo != null && useASTCaching) {
                    IASTCache[] providers;
                    mifo.put(astKey, moduleDeclaration);
                    if (useASTPersistenceCaching && (providers = ASTCacheManager.getProviders(toolkit.getNatureId())) != null) {
                        IASTCache[] iASTCacheArray = providers;
                        int n = providers.length;
                        int n3 = 0;
                        while (n3 < n) {
                            IASTCache provider = iASTCacheArray[n3];
                            provider.storeModule(module, moduleDeclaration, collector);
                            ++n3;
                        }
                    }
                    if (collector != null && !collector.isEmpty()) {
                        mifo.put(errorKey, collector);
                    } else {
                        mifo.remove(errorKey);
                    }
                }
            }
        }
        return moduleDeclaration;
    }

    public static ModuleDeclaration getModuleDeclaration(ISourceModule module) {
        return SourceParserUtil.getModuleDeclaration(module, null, 0);
    }

    public static ModuleDeclaration getModuleDeclaration(ISourceModule module, IProblemReporter reporter) {
        return SourceParserUtil.getModuleDeclaration(module, reporter, 0);
    }

    @Deprecated
    public static ModuleDeclaration getModuleDeclaration(ISourceModule module, IProblemReporter reporter, int flags) {
        ISourceModuleInfoCache sourceModuleInfoCache = ModelManager.getModelManager().getSourceModuleInfoCache();
        return SourceParserUtil.getModuleDeclaration(module, reporter, sourceModuleInfoCache.get(module), flags);
    }

    @Deprecated
    public static ModuleDeclaration getModuleDeclaration(ISourceModule module, IProblemReporter reporter, ISourceModuleInfoCache.ISourceModuleInfo mifo) {
        return SourceParserUtil.getModuleDeclaration(module, reporter, mifo, 0);
    }

    @Deprecated
    public static ModuleDeclaration getModuleDeclaration(ISourceModule module, IProblemReporter reporter, ISourceModuleInfoCache.ISourceModuleInfo mifo, int flags) {
        return SourceParserUtil.wrap(SourceParserUtil.parse(module, reporter));
    }

    private static String getKey(String baseKey, int flags) {
        return flags == 0 ? baseKey : String.valueOf(baseKey) + flags;
    }

    public static ModuleDeclaration getModuleDeclaration(IModuleSource module, String natureId, IProblemReporter reporter) {
        IModuleDeclaration result = SourceParserUtil.parse(module, natureId, reporter);
        return SourceParserUtil.wrap(result);
    }

    private static ModuleDeclaration wrap(IModuleDeclaration result) {
        if (result != null) {
            if (result instanceof ModuleDeclaration) {
                return (ModuleDeclaration)result;
            }
            return new ModuleDeclarationWrapper(result);
        }
        return null;
    }

    public static IModuleDeclaration getModuleFromCache(ISourceModuleInfoCache.ISourceModuleInfo mifo, IProblemReporter reporter) {
        if (mifo != null && useASTCaching) {
            ProblemCollector collector;
            IModuleDeclaration moduleDeclaration = (IModuleDeclaration)mifo.get(SourceParserUtil.getKey(AST, 0));
            if (moduleDeclaration != null && reporter != null && (collector = (ProblemCollector)mifo.get(SourceParserUtil.getKey(ERRORS, 0))) != null) {
                collector.copyTo(reporter);
            }
            return moduleDeclaration;
        }
        return null;
    }

    public static void putModuleToCache(ISourceModuleInfoCache.ISourceModuleInfo info, IModuleDeclaration module, ProblemCollector collector) {
        if (info != null && useASTCaching) {
            info.put(SourceParserUtil.getKey(AST, 0), module);
            String errorKey = SourceParserUtil.getKey(ERRORS, 0);
            if (collector != null && !collector.isEmpty()) {
                info.put(errorKey, collector);
            } else {
                info.remove(errorKey);
            }
        }
    }

    public static void disableCache() {
        useASTCaching = false;
    }

    public static void enableCache() {
        useASTCaching = true;
    }

    public static void clearCache() {
        ModelManager.getModelManager().getSourceModuleInfoCache().clear();
    }
}

