/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IPreferencesLookupDelegate;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.internal.ui.actions.ActionMessages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.ui.formatter.IScriptFormatter;
import org.eclipse.dltk.ui.formatter.IScriptFormatterFactory;
import org.eclipse.dltk.ui.formatter.ScriptFormatterManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IWorkbenchSite;

public class FormatAction
extends SelectionDispatchAction {
    protected FormatAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.FormatAction_label);
    }

    public void run(IStructuredSelection selection) {
        ModuleCollector collector = new ModuleCollector();
        for (Object obj : selection) {
            if (!(obj instanceof IModelElement)) continue;
            try {
                ((IModelElement)obj).accept((IModelElementVisitor)collector);
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
            }
        }
        if (!collector.modules.isEmpty()) {
            for (ISourceModule module : collector.modules) {
                IScriptProject project;
                IScriptFormatterFactory formatterFactory;
                IResource resource = module.getResource();
                if (resource == null || resource.getType() != 1 || !resource.exists() || (formatterFactory = ScriptFormatterManager.getSelected(project = module.getScriptProject())) == null) continue;
                try {
                    String source = module.getSource();
                    Document document = new Document(source);
                    String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                    Map<String, String> preferences = formatterFactory.retrievePreferences((IPreferencesLookupDelegate)new PreferencesLookupDelegate(project));
                    IScriptFormatter formatter = formatterFactory.createFormatter(lineDelimiter, preferences);
                    TextEdit edit = formatter.format(source, 0, source.length(), 0);
                    if (edit == null) continue;
                    edit.apply((IDocument)document);
                    String newSource = document.get();
                    if (source.equals(newSource)) continue;
                    module.becomeWorkingCopy(null, null);
                    module.getBuffer().setContents(newSource);
                    module.commitWorkingCopy(true, null);
                }
                catch (Exception e) {
                    DLTKUIPlugin.log(e);
                    break;
                }
            }
        }
    }

    private static class ModuleCollector
    implements IModelElementVisitor {
        final List modules = new ArrayList();

        private ModuleCollector() {
        }

        public boolean visit(IModelElement element) {
            if (element instanceof ISourceModule) {
                ISourceModule module = (ISourceModule)element;
                if (!module.isReadOnly()) {
                    this.modules.add(element);
                }
                return false;
            }
            return element.getElementType() < 5;
        }
    }
}

