/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.branding.splash.internal;

import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.splash.BasicSplashHandler;

public class SplashHandler
extends BasicSplashHandler {
    private static final int DEFAULT_FOREGROUND_COLOR = 13817855;
    private static final Rectangle DEFAULT_MESSAGE_RECT = new Rectangle(1, 1, 10, 100);
    private static final Rectangle DEFAULT_PROGRESS_RECT = new Rectangle(1, 12, 10, 100);
    private Font font;

    public void init(Shell splash) {
        int foregroundColorInteger;
        super.init(splash);
        String progressRectString = null;
        String messageRectString = null;
        String foregroundColorString = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            progressRectString = product.getProperty("startupProgressRect");
            messageRectString = product.getProperty("startupMessageRect");
            foregroundColorString = product.getProperty("startupForegroundColor");
        }
        Rectangle messageRect = StringConverter.asRectangle(messageRectString, (Rectangle)DEFAULT_MESSAGE_RECT);
        this.setMessageRect(messageRect);
        Rectangle progressRect = StringConverter.asRectangle((String)progressRectString, (Rectangle)DEFAULT_PROGRESS_RECT);
        this.setProgressRect(progressRect);
        try {
            foregroundColorInteger = Integer.parseInt(foregroundColorString, 16);
        }
        catch (NumberFormatException numberFormatException) {
            foregroundColorInteger = 13817855;
        }
        this.setForeground(new RGB((foregroundColorInteger & 0xFF0000) >> 16, (foregroundColorInteger & 0xFF00) >> 8, foregroundColorInteger & 0xFF));
        String version = System.getProperty("product.version");
        int lastIndexOf = version.lastIndexOf(46);
        if (lastIndexOf != -1) {
            version = version.substring(0, lastIndexOf);
        }
        final String buildId = "Version: " + version;
        final Point position = new Point(280, 150);
        this.font = new Font((Device)Display.getDefault(), new FontData("Helvetica", Platform.getOS().equals("macosx") ? 9 : 7, 1));
        this.getContent().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(SplashHandler.this.getForeground());
                e.gc.setFont(SplashHandler.this.font);
                e.gc.drawText(buildId, position.x, position.y, true);
            }
        });
    }

    public void dispose() {
        this.font.dispose();
        super.dispose();
    }
}

