/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.remote.core.internal.lua;

import java.util.EnumSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.koneki.ldt.core.IProjectSourceVisitor;
import org.eclipse.koneki.ldt.core.LuaUtils;
import org.eclipse.koneki.ldt.remote.core.internal.lua.LuaSubSystem;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public final class LuaRSEUtil {
    private LuaRSEUtil() {
    }

    public static void uploadFiles(final IRemoteFileSubSystem subsystem, IScriptProject project, final String destinationFolderPath, IProgressMonitor monitor) throws CoreException {
        IProjectSourceVisitor visitor = new IProjectSourceVisitor(){

            public void processFile(IPath absolutePath, IPath relativePath, String charset, IProgressMonitor monitor) throws CoreException {
                String destinationPath = String.valueOf(destinationFolderPath) + subsystem.getSeparator() + relativePath.toPortableString();
                String destinationEncoding = subsystem.getRemoteEncoding();
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                try {
                    subsystem.upload(absolutePath.toOSString(), charset, destinationPath, destinationEncoding, (IProgressMonitor)subMonitor.newChild(1));
                }
                catch (SystemMessageException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.koneki.ldt.remote.core", "Unable to upload files", (Throwable)e));
                }
            }

            public void processDirectory(IPath absolutePath, IPath relativePath, IProgressMonitor monitor) throws CoreException {
                String innerDestinationFolderPath = String.valueOf(destinationFolderPath) + subsystem.getSeparator() + relativePath.toPortableString();
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                try {
                    IRemoteFile remoteFolder = subsystem.getRemoteFileObject(innerDestinationFolderPath, (IProgressMonitor)subMonitor);
                    subsystem.createFolder(remoteFolder, (IProgressMonitor)subMonitor.newChild(1));
                }
                catch (SystemMessageException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.koneki.ldt.remote.core", "Unable to upload files", (Throwable)e));
                }
            }
        };
        LuaUtils.visitSourceFiles((IScriptProject)project, EnumSet.complementOf(EnumSet.of(LuaUtils.ProjectFragmentFilter.ARCHIVE, LuaUtils.ProjectFragmentFilter.EXECUTION_ENVIRONMENT)), (IProjectSourceVisitor)visitor, (IProgressMonitor)monitor);
    }

    public static LuaSubSystem getLuaSubSystem(IHost host) {
        if (host == null) {
            return null;
        }
        ISubSystem[] iSubSystemArray = host.getSubSystems();
        int n = iSubSystemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISubSystem subsytem = iSubSystemArray[n2];
            if (subsytem instanceof LuaSubSystem) {
                return (LuaSubSystem)subsytem;
            }
            ++n2;
        }
        return null;
    }
}

