/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.AccumulatingProblemReporter;
import org.eclipse.dltk.internal.core.ModelElementDelta;
import org.eclipse.dltk.internal.core.ModelElementDeltaBuilder;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelOperation;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.ReconcileBuilder;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.search.ProjectIndexerManager;
import org.eclipse.dltk.internal.core.util.Messages;

public class ReconcileWorkingCopyOperation
extends ModelOperation {
    private boolean forceProblemDetection;
    private WorkingCopyOwner workingCopyOwner;
    private ModelElementDeltaBuilder deltaBuilder;

    public ReconcileWorkingCopyOperation(ISourceModule module, boolean forceProblemDetection, WorkingCopyOwner workingCopyOwner) {
        super(new IModelElement[]{module});
        this.forceProblemDetection = forceProblemDetection;
        this.workingCopyOwner = workingCopyOwner;
    }

    protected void executeOperation() throws ModelException {
        if (this.progressMonitor != null) {
            if (this.progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.progressMonitor.beginTask(Messages.element_reconciling, 2);
        }
        try {
            SourceModule workingCopy = this.getWorkingCopy();
            ModelManager.PerWorkingCopyInfo requestor = workingCopy.getPerWorkingCopyInfo();
            this.deltaBuilder = new ModelElementDeltaBuilder(workingCopy);
            this.makeConsistent(workingCopy, requestor);
            ModelElementDelta delta = this.deltaBuilder.delta;
            if (delta != null) {
                this.addReconcileDelta(workingCopy, delta);
            }
        }
        finally {
            if (this.progressMonitor != null) {
                this.progressMonitor.done();
            }
        }
    }

    public void makeConsistent(SourceModule workingCopy, IProblemRequestor problemRequestor) throws ModelException {
        if (!workingCopy.isConsistent()) {
            workingCopy.makeConsistent(this.progressMonitor);
            this.deltaBuilder.buildDeltas();
            ProjectIndexerManager.reconciled(workingCopy);
        } else if (this.forceProblemDetection && problemRequestor.isActive()) {
            AccumulatingProblemReporter reporter = new AccumulatingProblemReporter(workingCopy, problemRequestor);
            SourceParserUtil.parse(workingCopy, reporter);
            IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(workingCopy);
            if (toolkit != null) {
                new ReconcileBuilder(toolkit.getNatureId(), workingCopy, reporter).build();
            }
            reporter.reportToRequestor();
        }
    }

    protected SourceModule getWorkingCopy() {
        return (SourceModule)this.getElementToProcess();
    }

    public boolean isReadOnly() {
        return true;
    }

    protected IModelStatus verify() {
        IModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        SourceModule workingCopy = this.getWorkingCopy();
        if (!workingCopy.isWorkingCopy()) {
            return new ModelStatus(969, workingCopy);
        }
        return status;
    }
}

