/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.css2;

import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler2;
import org.eclipse.e4.ui.css.core.dom.properties.css2.AbstractCSSPropertyFontHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyFontHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.exceptions.UnsupportedPropertyException;
import org.eclipse.e4.ui.css.swt.dom.ItemElement;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTFontHelper;
import org.eclipse.e4.ui.css.swt.helpers.SWTElementHelpers;
import org.eclipse.e4.ui.css.swt.properties.custom.CTabETabHelper;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyFontSWTHandler
extends AbstractCSSPropertyFontHandler
implements ICSSPropertyHandler2 {
    public static final ICSSPropertyFontHandler INSTANCE = new CSSPropertyFontSWTHandler();
    private static final String CSS_CTABITEM_SELECTED_FONT_LISTENER_KEY = "CSS_CTABFOLDER_SELECTED_FONT_LISTENER_KEY";

    private static void setFont(Widget widget, Font font) {
        if (widget instanceof CTabItem) {
            ((CTabItem)widget).setFont(font);
        } else if (widget instanceof Control) {
            ((Control)widget).setFont(font);
        }
    }

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget(element);
        if (widget != null) {
            CSS2FontProperties fontProperties = CSSSWTFontHelper.getCSS2FontProperties(widget, engine.getCSSElementContext((Object)widget));
            if (fontProperties != null) {
                super.applyCSSProperty(element, property, value, pseudo, engine);
                if (widget instanceof CTabItem) {
                    Control parent = CTabETabHelper.getParent(widget);
                    FontSelectionListener listener = (FontSelectionListener)parent.getData(CSS_CTABITEM_SELECTED_FONT_LISTENER_KEY);
                    if (listener == null) {
                        listener = new FontSelectionListener(engine);
                        parent.addListener(9, (Listener)listener);
                        parent.setData(CSS_CTABITEM_SELECTED_FONT_LISTENER_KEY, (Object)listener);
                    } else {
                        listener.setEngine(engine);
                    }
                    listener.setShouldStyle(true);
                }
            }
            return true;
        }
        if (element instanceof CSS2FontProperties) {
            super.applyCSSProperty(element, property, value, pseudo, engine);
            return true;
        }
        return false;
    }

    public void applyCSSPropertyFontFamily(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget(element);
        CSS2FontProperties fontProperties = CSSSWTFontHelper.getCSS2FontProperties(widget, engine.getCSSElementContext((Object)widget));
        if (fontProperties instanceof CSS2FontProperties) {
            this.applyCSSPropertyFontFamily(fontProperties, value, pseudo, engine);
            return;
        }
        throw new UnsupportedPropertyException("font-family");
    }

    public void applyCSSPropertyFontSize(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget(element);
        CSS2FontProperties fontProperties = CSSSWTFontHelper.getCSS2FontProperties(widget, engine.getCSSElementContext((Object)widget));
        if (fontProperties instanceof CSS2FontProperties) {
            this.applyCSSPropertyFontSize(fontProperties, value, pseudo, engine);
            return;
        }
        throw new UnsupportedPropertyException("font-size");
    }

    public void applyCSSPropertyFontWeight(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget(element);
        CSS2FontProperties fontProperties = CSSSWTFontHelper.getCSS2FontProperties(widget, engine.getCSSElementContext((Object)widget));
        if (fontProperties instanceof CSS2FontProperties) {
            this.applyCSSPropertyFontWeight(fontProperties, value, pseudo, engine);
            return;
        }
        throw new UnsupportedPropertyException("font-weight");
    }

    public void applyCSSPropertyFontStyle(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget(element);
        CSS2FontProperties fontProperties = CSSSWTFontHelper.getCSS2FontProperties(widget, engine.getCSSElementContext((Object)widget));
        if (fontProperties instanceof CSS2FontProperties) {
            this.applyCSSPropertyFontStyle(fontProperties, value, pseudo, engine);
            return;
        }
        throw new UnsupportedPropertyException("font-style");
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget(element);
        if (widget != null) {
            return super.retrieveCSSProperty((Object)widget, property, pseudo, engine);
        }
        return null;
    }

    public String retrieveCSSPropertyFontAdjust(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyFontFamily(Object element, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = (Widget)element;
        return CSSSWTFontHelper.getFontFamily(widget);
    }

    public String retrieveCSSPropertyFontSize(Object element, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = (Widget)element;
        return CSSSWTFontHelper.getFontSize(widget);
    }

    public String retrieveCSSPropertyFontStretch(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyFontStyle(Object element, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = (Widget)element;
        return CSSSWTFontHelper.getFontStyle(widget);
    }

    public String retrieveCSSPropertyFontVariant(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyFontWeight(Object element, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = (Widget)element;
        return CSSSWTFontHelper.getFontWeight(widget);
    }

    public void onAllCSSPropertiesApplyed(Object element, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget(element);
        if (widget == null || widget instanceof CTabItem) {
            return;
        }
        CSS2FontProperties fontProperties = CSSSWTFontHelper.getCSS2FontProperties(widget, engine.getCSSElementContext((Object)widget));
        if (fontProperties == null) {
            return;
        }
        Font font = (Font)engine.convert((CSSValue)fontProperties, Font.class, (Object)widget);
        CSSPropertyFontSWTHandler.setFont(widget, font);
    }

    private class FontSelectionListener
    implements Listener {
        private String[] fontAttributes = new String[]{"font", "font-family", "font-size", "font-adjust", "font-stretch", "font-style", "font-variant", "font-weight"};
        private CSSEngine engine;
        private Item selection;
        private boolean shouldStyle;

        public FontSelectionListener(CSSEngine engine) {
            this.engine = engine;
        }

        public void setEngine(CSSEngine engine) {
            this.engine = engine;
        }

        public void setShouldStyle(boolean shouldStyle) {
            this.shouldStyle = shouldStyle;
        }

        private void applyStyles(CSSStyleDeclaration styleDeclaration, String pseudo, Item item) {
            CSS2FontProperties fontProperties = CSSSWTFontHelper.getCSS2FontProperties((Widget)item, this.engine.getCSSElementContext((Object)item));
            ItemElement itemElement = new ItemElement(item, this.engine);
            if (fontProperties != null) {
                this.reset(fontProperties);
                int j = 0;
                while (j < this.fontAttributes.length) {
                    CSSValue value = styleDeclaration.getPropertyCSSValue(this.fontAttributes[j]);
                    if (value != null) {
                        try {
                            CSSPropertyFontSWTHandler.super.applyCSSProperty(itemElement, this.fontAttributes[j], value, pseudo, this.engine);
                        }
                        catch (Exception e) {
                            this.engine.handleExceptions(e);
                        }
                    }
                    ++j;
                }
                try {
                    Font font = (Font)this.engine.convert((CSSValue)fontProperties, Font.class, (Object)item);
                    CSSPropertyFontSWTHandler.setFont((Widget)item, font);
                }
                catch (Exception e) {
                    this.engine.handleExceptions(e);
                }
            }
        }

        private void styleUnselected(Item[] items) {
            int i = 0;
            while (i < items.length) {
                CSSStyleDeclaration unselectedStyle = this.engine.getViewCSS().getComputedStyle(this.engine.getElement((Object)items[i]), null);
                if (unselectedStyle == null) {
                    CSSPropertyFontSWTHandler.setFont((Widget)items[i], null);
                } else {
                    this.applyStyles(unselectedStyle, null, items[i]);
                }
                ++i;
            }
        }

        private boolean styleSelected(Item selection) {
            CSSStyleDeclaration selectedStyle = this.engine.getViewCSS().getComputedStyle(this.engine.getElement((Object)selection), "selected");
            if (selectedStyle == null) {
                return false;
            }
            this.applyStyles(selectedStyle, "selected", selection);
            return true;
        }

        private void reset(CSS2FontProperties properties) {
            properties.setFamily(null);
            properties.setSize(null);
            properties.setSizeAdjust(null);
            properties.setWeight(null);
            properties.setStyle(null);
            properties.setVariant(null);
            properties.setStretch(null);
        }

        public void handleEvent(Event e) {
            if (e.widget instanceof CTabFolder) {
                CTabFolder folder = (CTabFolder)e.widget;
                CTabItem selection = folder.getSelection();
                CTabItem[] items = folder.getItems();
                if (!this.shouldStyle && this.selection == selection) {
                    return;
                }
                this.styleUnselected((Item[])items);
                if (selection != null && !this.styleSelected((Item)selection)) {
                    CSSPropertyFontSWTHandler.setFont((Widget)selection, null);
                }
                this.selection = selection;
                this.shouldStyle = false;
            }
        }
    }
}

