/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.rse.core.IRSESystemType;

public final class SystemTypeMatcher {
    private final List patterns = new LinkedList();
    private boolean matchAllTypes = false;

    public SystemTypeMatcher(String declaredSystemTypeIds) {
        String[] ids;
        if (declaredSystemTypeIds != null && (ids = declaredSystemTypeIds.split(";")) != null && ids.length > 0) {
            int i = 0;
            while (i < ids.length) {
                String id = ids[i].trim();
                if (id.equals("*")) {
                    this.matchAllTypes = true;
                    this.patterns.clear();
                    return;
                }
                if (id.length() > 0) {
                    SystemTypeIdPattern pattern = new SystemTypeIdPattern(Pattern.compile(this.makeRegex(id)));
                    this.patterns.add(pattern);
                }
                ++i;
            }
        }
    }

    private String makeRegex(String pattern) {
        assert (pattern != null);
        String translated = pattern;
        if (translated.indexOf(46) != -1) {
            translated = translated.replaceAll("\\.", "\\.");
        }
        if (translated.indexOf(42) != -1) {
            translated = translated.replaceAll("\\*", ".*");
        }
        if (translated.indexOf(63) != -1) {
            translated = translated.replaceAll("\\?", ".");
        }
        return translated;
    }

    public boolean supportsAllSystemTypes() {
        return this.matchAllTypes;
    }

    public boolean matches(IRSESystemType systemType) {
        assert (systemType != null);
        if (this.matchAllTypes) {
            return true;
        }
        for (SystemTypeIdPattern matcher : this.patterns) {
            if (!matcher.matches(systemType)) continue;
            return true;
        }
        return false;
    }

    private final class SystemTypeIdPattern {
        private final Pattern pattern;

        public SystemTypeIdPattern(Pattern pattern) {
            assert (pattern != null);
            this.pattern = pattern;
        }

        public boolean matches(IRSESystemType systemType) {
            assert (systemType != null);
            return this.pattern.matcher(systemType.getId()).matches();
        }
    }
}

