/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.codeassist;

import java.util.Collection;
import java.util.Map;
import org.eclipse.dltk.codeassist.ISelectionEngine;
import org.eclipse.dltk.codeassist.ISelectionRequestor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.internal.codeassist.impl.AssistOptions;
import org.eclipse.dltk.internal.codeassist.impl.Engine;
import org.eclipse.dltk.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.dltk.internal.core.SearchableEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScriptSelectionEngine
extends Engine
implements ISelectionEngine {
    protected ISelectionRequestor requestor;

    public ScriptSelectionEngine() {
        super(null);
    }

    public void setEnvironment(SearchableEnvironment environment) {
        this.nameEnvironment = environment;
        this.lookupEnvironment = new LookupEnvironment(this, this.nameEnvironment);
    }

    @Override
    public void setRequestor(ISelectionRequestor requestor) {
        this.requestor = requestor;
    }

    protected void reportModelElement(IModelElement element) {
        this.requestor.acceptModelElement(element);
    }

    protected void reportModelElements(IModelElement[] elements) {
        IModelElement[] iModelElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement element = iModelElementArray[n2];
            this.requestor.acceptModelElement(element);
            ++n2;
        }
    }

    protected void reportModelElements(Collection<IModelElement> elements) {
        for (IModelElement element : elements) {
            this.requestor.acceptModelElement(element);
        }
    }

    protected void reportForeignElement(Object object) {
        this.requestor.acceptForeignElement(object);
    }

    protected void reportElement(Object element) {
        this.requestor.acceptElement(element, null);
    }

    protected void reportElement(Object element, ISourceRange range) {
        this.requestor.acceptElement(element, range);
    }

    @Override
    public void setOptions(Map options) {
        this.options = new AssistOptions(options);
    }
}

